#include "sparkfun.h"
#include "rtos.h"

/*
    1234567890ABCDEF
   [Buero       52°C]
   [T26> P N x 11:42]
    ^  ^ ^ ^ ^   ^
    |  | | | |   |
    |  | | | |   |
    |  | | | |   +-- 27: Uhrzeit "hh:mm" / Datum "Mar03" / Uptime "  42d"
    |  | | | |
    |  | | | +-- 25: Reserve
    |  | | |
    |  | | +-- 23: NTP Status: t=lesen, T=ok, ?=error
    |  | |
    |  | +-- 21: Netz: P)ost O)k E)rror [1-9] = in x Minuten gehts los
    |  |
    |  +-- 19: < senden, > lesen, = fertig, ? fehler
    |
    +-- 16: gerade/zuletzt gemessener Sensor

*/

SparkFun::SparkFun(PinName tx) : Serial(tx, NC) {
    baud(9600);
}

void SparkFun::clear(void) {
    control_sequence(0x01);
}

void SparkFun::set_cursor_position(int pos) {
    if (pos >= 16) {
        pos = 64 + pos - 16;
    }
    control_sequence(0x80 + pos);
}

void SparkFun::control_sequence(char c) {
    putc(0xfe);
    putc(c);
}

void SparkFun::print_init_message(void) {
    clear();
    
    set_cursor_position(0);    
    puts("TempSensor");
    
    // will get overridden very soon.
    // set_cursor_position(16);
    // puts("init");
}

void SparkFun::show_sensor_measure(char *name, char *measure) {
    Thread::wait(50); // time for 48 characters.
    set_cursor_position(0);
    printf("%-12s%4s", name, measure);
}

void SparkFun::clear_current_sensor(void) {
    Thread::wait(50); // time for 48 characters.
    set_cursor_position(16);
    puts("    ");
}

void SparkFun::show_current_sensor(char kind, int nr, char status) {
    Thread::wait(50); // time for 48 characters.
    set_cursor_position(16);
    printf("%c%02d%c", kind, nr, status);
}

void SparkFun::show_current_status(char status) {
    Thread::wait(50); // time for 48 characters.
    set_cursor_position(19);
    putc(status);
}

void SparkFun::show_network_status(char status) {
    Thread::wait(50); // time for 48 characters.
    set_cursor_position(21);
    putc(status);
}

void SparkFun::show_ntp_status(char status) {
    Thread::wait(50); // time for 48 characters.
    set_cursor_position(23);
    putc(status);
}

void SparkFun::show_spare_status(char status) {
    Thread::wait(50); // time for 48 characters.
    set_cursor_position(25);
    putc(status);
}

void SparkFun::show_time_text(char *text) {
    Thread::wait(50); // time for 48 characters.
    set_cursor_position(27);
    printf("%-5s", text);
}
