#ifndef SENSOR_H
#define SENSOR_H

#include "mbed.h"

class Sensor {
public:
    // T26: buero/temperatur    Buero
    Sensor(char kind, PinName pin, char *url_part, char *name);
    
    void set_value(int v);
    int get_value(void);
    
    char get_kind(void);
    int get_pin(void);
    char *get_url_part(void);
    char *get_name(void);
    
    virtual void prepare_measure(void);
    virtual void measure(void);
    virtual void cleanup_measure(void);
    virtual char *last_measure(void);
    
protected:
    char kind;
    PinName pin;
    char *url_part;
    char *name;
    int value;
};

#endif
