#include "one_wire.h"

/* "borrowed" from snatch59: OneWireCRC and simplified for my needs */
 
const int timing[] = {6, 64, 60, 10, 9, 55, 0, 480, 70, 410};
 
OneWire::OneWire(PinName pin) : port(pin) {
}
 
int OneWire::reset() {
    int result = 0;    // sample presence pulse result
        
    wait_us(timing[6]);
    port.output();
    port = 0;
    wait_us(timing[7]);
    port.input();
    wait_us(timing[8]);
    result = !(port & 0x01);
    wait_us(timing[9]);
    
    return result;
}
 
void OneWire::write_bit(int bit) {
    bit = bit & 0x01;
    
    if (bit) {
        // Write '1' bit
        port.output();
        port = 0;
        wait_us(timing[0]);
        port.input();
        wait_us(timing[1]);
    } else {
        // Write '0' bit
        port.output();
        port = 0;
        wait_us(timing[2]);
        port.input();
        wait_us(timing[3]);
    }
}
 
int OneWire::read_bit() {
    int result;
    
    port.output();
    port = 0;
    wait_us(timing[0]);
    port.input();
    wait_us(timing[4]);
    result = port & 0x01;
    wait_us(timing[5]);
       
    return result;
}
 
void OneWire::write_byte(int data) {
    // Loop to write each bit in the byte, LS-bit first
    for (int loop = 0; loop < 8; loop++) {
        write_bit(data & 0x01);
        
        // shift the data byte for the next bit
        data >>= 1;
    }
}
 
int OneWire::read_byte() {
    int result = 0;
    
    for (int loop = 0; loop < 8; loop++) {
        // shift the result to get it ready for the next bit
        result >>= 1;
        
        // if result is one, then set MS bit
        if (read_bit()) result |= 0x80;
    }
    
    return result;
}
 
void OneWire::block(char* data, int data_len) {
    for (int loop = 0; loop < data_len; loop++) {
        data[loop] = read_byte(); // original: touchByte(data[loop]);
    }
}

void OneWire::prepare_read() {
    reset();
    write_byte(SKIP_ROM);
    write_byte(CONVERT);

    // switch on parasite power while waiting.
    port.output();
    port = 1;
}

int OneWire::read_temperature() {
    char data[9];
    short *raw_temp = (short *) data;
    int temperature = -99;
    
    reset();
    write_byte(SKIP_ROM);
    write_byte(READSCRATCH);
    block(data, 9);
    
    if (data[5] == 255 && data[7] == 16) {
        temperature = *raw_temp >> 4;
    }
    
    return temperature;
}
