#include "temperature_sensor.h"
#include "rtos.h"

TemperatureSensor::TemperatureSensor(PinName pin, char *url_part, char *name): Sensor('T', pin, url_part, name), one_wire(pin) {
}

void TemperatureSensor::prepare_measure(void) {
    one_wire.prepare_read();
    Thread::wait(1000);
}

void TemperatureSensor::measure(void) {
    value = one_wire.read_temperature();
}

char *TemperatureSensor::last_measure(void) {
    sprintf(buffer, "%d\337C", value);
    
    return buffer;
}
