#ifndef SPARKFUN_H
#define SPARKFUN_H

#include "mbed.h"

class SparkFun : public Serial {
public:
    SparkFun(PinName tx);

    // low level functions
    void clear(void);
    void set_cursor_position(int pos);
    void control_sequence(char c);
    
    // high level functions
    void print_init_message(void);
    void show_sensor_measure(char *name, char *measure);
    void clear_current_sensor(void);
    void show_current_sensor(char kind, int nr, char status = ' ');
    void show_current_status(char status);
    void show_network_status(char status);
    void show_ntp_status(char status);
    void show_spare_status(char status);
    void show_time_text(char *text);
};

#endif
