#include "local_time.h"

LocalTime::LocalTime() {}

struct tm *LocalTime::tm() {
    time_t seconds = time(NULL);
    
    struct tm *t = localtime(&seconds);
    if (seconds > last_sunday(t->tm_year, 3) && seconds < last_sunday(t->tm_year, 10)) {
        seconds += 7200;
    } else {
        seconds += 3600;
    }

    return localtime(&seconds);
}

time_t LocalTime::last_sunday(int year, int month) {
    struct tm t1;
    
    t1.tm_sec = 0;   t1.tm_min = 0;     t1.tm_hour = month == 10 ? 3 : 2;
    t1.tm_mday = 31; t1.tm_mon = month; t1.tm_year = year;
    
    // convert to seconds since epoch
    time_t seconds = mktime(&t1);
    
    // convert back to tm because we need to know the week day
    struct tm *t2 = localtime(&seconds);
    
    // subtract weekday to get back last sunday of month requested
    return seconds - 86400 * t2->tm_wday;
}