#include "collector_proxy.h"
#include "HTTPClient.h"

#include <cstring>

CollectorProxy::CollectorProxy(const char *url) :base_url(url) {}

int CollectorProxy::send_measure(char *path_part, int value) {
    HTTPClient http;
    HTTPMap data;
    char str[512];
    HTTPText in_text(str, 512);
    
    char url[200];
    strcpy(url, base_url);
    strcat(url, "/");
    strcat(url, path_part);

    char value_buffer[10];
    sprintf(value_buffer, "%d", value);
    data.put("value", value_buffer);

    int ret = http.post(url, data, &in_text);

    if (!ret) {
        // printf("Executed POST successfully - read %d characters\n", strlen(str));
        // printf("Result: %s\n", str);
        return 1;
    } else {
        // printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        return 0;
    }
}
