#include "Led_Lcd.h"

LCD_DISCO_F429ZI lcd;

LedLcd :: LedLcd(unsigned char ucColumn){
    ucColumnPosition = (80 * ucColumn);
    lcd.Clear(LCD_COLOR_BLACK);
}
 
void LedLcd::On (unsigned char ucLed){
    unsigned char ucRectangleIndex;   
    for (ucRectangleIndex = 0; ucRectangleIndex <4; ucRectangleIndex++){
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(ucColumnPosition, (80*ucRectangleIndex), 80, 80);
        lcd.SetTextColor(LCD_COLOR_BLUE);
        lcd.FillRect(ucColumnPosition + 2, 2+80*ucRectangleIndex, 78, 78);
        lcd.SetTextColor(LCD_COLOR_RED);
    }
    if (ucLed <4){
        lcd.FillRect(ucColumnPosition + 2, ucLed*80+2, 78, 78);
    }
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetFont(&Font24); 
    char RectNumber [2];
    for (ucRectangleIndex = 0 ; ucRectangleIndex  < 4; ucRectangleIndex ++){
        sprintf(RectNumber, "%d", ucRectangleIndex );
        lcd.DisplayStringAt(ucColumnPosition, 80*ucRectangleIndex  , (uint8_t *)&RectNumber, LEFT_MODE);
    }
}
               
               
