#include "mbed.h"
#include "ball.h"

Ball::Ball() {
  int x=y=width=height=color=xInc=yInc=0;
}

Ball::Ball(int x, int y, int w, int h, int c, int xi, int yi)
 : x(x), y(y), width(w), height(h), color(c), xInc(xi), yInc(yi) {}
 
 
/* 
 * Member Function move:
 * Description: Colors in the previous ball black
 *  and moves ball to new position.
 */
void Ball::move(NokiaLCD &lcd) {
  draw(lcd, true);
  x += xInc; y += yInc;
}

/* 
 * Member Function draw:
 * Description: Draws object on screen
 *  if isBlack, color in black.
 */
void Ball::draw(NokiaLCD &lcd, bool isBlack) const {
  lcd.fill(x, y, width, height, (isBlack) ? 0x000000 : color);
}

int Ball::size() const {
  return width*height;
}

int Ball::getX() const {
  return x;
}

int Ball::getY() const {
  return y;
}

bool Ball::hitX() {
  return (x+width<=width) || (x+width>=132);
}

bool Ball::hitY() {
  return (y<=0) || (y+height>=130);
}

/* 
 * Member Function hitP1:
 * Description: Checks to see if there is
 *  a collision between paddle1 and the ball.
 *  Has special functionality for changing
 *  y-incline based on collision point.
 */
bool Ball::hitP1(int _x, int _y, int _height) {
  bool hit = ((_x>=x) && (xInc<0)) && 
         (((_y<=y) && (_y+_height>=y+height)) ||
          ((_y>=y) && (_y<=y+height)) ||
          ((_y+_height>=y) && (_y+_height<=y+height))
         );
  if(hit) {
    if(_y+_height-y < 4 && yInc>0) yInc = 2;
    if(y-_y < 4 && yInc<0) yInc = -2;
    else yInc = (yInc>0) ? 1 : -1;
  }
  return hit;
}


/* 
 * Member Function hitP2:
 * Description: Checks to see if there is
 *  a collision between paddle2 and the ball.
 *  Has special functionality for changing
 *  y-incline based on collision point.
 */
bool Ball::hitP2(int _x, int _y, int _height) {
  bool hit = ((_x<=x+width) && (xInc>0)) && 
         (((_y<=y) && (_y+_height>=y+height)) ||
          ((_y>=y) && (_y<=y+height)) ||
          ((_y+_height>=y) && (_y+_height<=y+height))
         );
  if(hit) {
    if(_y+_height-y < 4 && yInc>0) yInc = 2;
    if(y-_y < 4 && yInc<0) yInc = -2;
    else yInc = (yInc>0) ? 1 : -1;
  }
  return hit;
}

void Ball::reverseX() {
  xInc *= -1;
}

void Ball::reverseY() {
  yInc *= -1;
}