#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "HMC6352.h"

HMC6352 compass(p9, p10);
Serial pc(USBTX, USBRX);
SPI spi(p11, p12, p13);

DigitalOut latch(p15);
DigitalOut enable(p16);

//Function controlling the brightness of shiftbright leds
void RGB_LED(int redx, int greenx, int bluex)
{
    unsigned int low_color=0;
    unsigned int high_color=0;
    int red, green, blue;
    red = ((redx - 48)*25)&0x3FF ;          // subtract 48 from input to read ascii code correctly
    blue = ((bluex - 48)*25)&0x3FF ;        // scale by a factor of 25 so the LED's are brighter
    green = ((greenx - 48)*25)&0x3FF ;      // and with 0x3FF so the colors are no more than 10 bits
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    enable=1;
    latch=0;
    enable=0;
    wait(.25);
}


int main()
{
    // set the frequency and format of the spi connection to shiftbright
    spi.format(16,0);
    spi.frequency(500000);

    char *r, *b, *g;
    int enable=0;
    char r1=48,b1=48,g1=48; //Declare the colors zero or off in ascii code
    char recv[3];
    
    // run shiftbright function with zeros to start with shiftbright off
    RGB_LED((int)r1, (int)g1, (int)b1);

    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect(); 
    //printf("IP Address is %s\n\r", eth.getIPAddress());

    compass.setOpMode(HMC6352_CONTINUOUS, 1, 20);

    Websocket ws("ws://sockets.mbed.org:443/ws/demo/wo");   // set socket connection server address
    ws.connect();                                               // connect socket server
    int res = ws.send("MBED Connected");                        // send msg confirming connection



    while (1) {

        // when the socket recieves information store it in recv
        if (ws.read(recv)) { 

            // if first character of the msg recieved is C send compass reading to socket
            if(recv[0] == 'C') {
                float compass_reading;
                char reading[20];
                compass_reading = compass.sample() / 10.0;
                snprintf(reading, sizeof(reading), "%f", compass_reading);
                ws.send(reading);
                ws.send("Heading is:");
            }
            
            // when r is input the character after a space is put as the brightness of the red LED
            if(recv[0] == 'r') {
                r= strtok(recv, " ");
                r= strtok( NULL," ");
                r1 = *r;
            }

            // when b is input the character after a space is put as the brightness of the blue LED
            if(recv[0] == 'b') {
                b= strtok(recv, " ");
                b= strtok( NULL," ");
                b1 = *b;
            }
            
            // when g is input the character after a space is put as the brightness of the green LED
            if(recv[0] == 'g') {
                g= strtok(recv, " ");
                g= strtok( NULL," ");
                g1 = *g;
            }
            
            // when 0 is input the shiftbright turns all LED's off
            if(recv[0] == '0') {
                g1=48;
                r1=48;
                b1=48;
            }
            
            // call on the LED function everytime an input comes from the socket
            RGB_LED((int)r1, (int)g1, (int)b1);

        }
    }

}