#include "mbed.h"
#include <mpr121.h>
#include "NokiaLCD.h"

Serial device(p13,p14);
Serial pc(USBTX, USBRX);

//PwmOut IRLED(p21);
// Setup the i2c bus on pins 28 and 27
I2C i2c1(p9, p10);
I2C i2c2(p28, p27);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr1(&i2c1, Mpr121::ADD_VSS);
Mpr121 mpr2(&i2c2, Mpr121::ADD_VSS);

NokiaLCD lcd2(p5, p7, p8, p15, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
//NokiaLCD lcd3(p5, p7, p16, p17, NokiaLCD::LCD6610);
NokiaLCD lcd1(p5, p7, p18, p19, NokiaLCD::LCD6610);

void print_on_lcd(int n, int suit, int card, int id)
{
    char x,y,w;
    x = 0;
    y = 0;
    w = 0;
    switch(id) {
        case 0:
            // lcd1.reset();
            lcd1.background(0x2b8135);
            lcd1.foreground(0x000000);
            // lcd1.cls();
            lcd1.locate(0,3);
            /*if(n >= 0) {
                lcd1.printf("Raise to %d",n);
            }
            if(n == -1) {
                lcd1.printf("Fold");
            }
            if(n == -2) {
                lcd1.printf("Call");
            }
            if(n == -4) {
                lcd1.reset();
                lcd1.cls();
                lcd1.printf("Time up!");
            }
            if (n==-3) {
                lcd1.printf("Exceeds limit, enter new value");
            }*/

            if(n == -6) {
                lcd1.locate(5,6);
                if((suit==1)||(suit==2))lcd1.foreground(0x000000);
                if((suit==3)||(suit==4))lcd1.foreground(0xFF0000);
                if(suit == 1) {
                    y = 'S';
                } else if(suit == 2) {
                    y = 'C';
                } else if(suit == 3) {
                    y = 'H';
                } else y = 'D';
                if(card==2) x = '2';
                else if(card == 3) x = '3';
                else if(card == 4) x = '4';
                else if(card == 5) x = '5';
                else if(card == 6) x = '6';
                else if(card == 7) x = '7';
                else if(card == 8) x = '8';
                else if(card == 9) x = '9';
                else if(card == 10) {
                    x = '1';
                    w = '0';
                    lcd1.printf(" %c %c%c", y, x, w);
                } else if(card == 11) x = 'J';
                else if (card == 12) x = 'Q';
                else if (card == 13) x = 'K';
                else if (card == 1) x = 'A';
                if(card!=10)lcd1.printf(" %c %c", y, x);
            }
            if(n == -5) {
                lcd1.locate(5,8);
                if((suit==1)||(suit==2))lcd1.foreground(0x000000);
                if((suit==3)||(suit==4))lcd1.foreground(0xFF0000);
                if(suit == 1) {
                    y = 'S';
                } else if(suit == 2) {
                    y = 'C';
                } else if(suit == 3) {
                    y = 'H';
                } else y = 'D';
                if(card==2) x = '2';
                else if(card == 3) x = '3';
                else if(card == 4) x = '4';
                else if(card == 5) x = '5';
                else if(card == 6) x = '6';
                else if(card == 7) x = '7';
                else if(card == 8) x = '8';
                else if(card == 9) x = '9';
                else if(card == 0) {
                    x = '1';
                    w = '0';
                    lcd1.printf(" %c %c%c", y, x, w);
                } else if(card == 11) x = 'J';
                else if (card == 12) x = 'Q';
                else if (card == 13) x = 'K';
                else if (card == 1) x = 'A';
                if(card!=10)lcd1.printf(" %c %c", y, x);
            }
            break;
        case -9:
            if(suit==0) {
                lcd1.foreground(0x000000);
                lcd1.locate(0, 1);
                lcd1.printf("Current wallet:");
                lcd1.locate(6,3);
                lcd1.printf("%d",n);
            } else if(suit==1) {
                lcd2.foreground(0x000000);
                lcd2.locate(0, 1);
                lcd2.printf("Current wallet:");
                lcd2.locate(6,3);
                lcd2.printf("%d",n);
            }
            break;
        case -8://(bet-Playerbet[ID],ID, 0, -8)
            if(suit==0) {
                lcd1.foreground(0x000000);
                lcd1.locate(4, 10);
                if(card==0)lcd1.printf("To Call: ");
                if(card==1)lcd1.printf("To Raise:");
                lcd1.locate(6,12);
                lcd1.printf("%d",n);
            } else if(suit==1) {
                lcd2.foreground(0x000000);
                lcd2.locate(4, 10);
                if(card==0)lcd2.printf("To Call:");
                if(card==1)lcd2.printf("To Raise:");
                lcd2.locate(6,12);
                lcd2.printf("%d",n);
            }
            break;
        case 1:
            //lcd2.reset();
            lcd2.background(0x2b8135);
            lcd2.foreground(0x000000);
            //lcd2.cls();
            lcd2.locate(0,3);
            /*if(n >= 0) {
                lcd2.printf("Raise to %d",n);
            }
            if(n == -1) {
                lcd2.printf("Fold");
            }
            if(n == -2) {
                lcd2.printf("Call");
            }
            if(n == -4) {
                lcd2.reset();
                lcd2.cls();
                lcd2.printf("Time up!");
            }
            if (n == -3) {
                lcd2.printf("Exceeds limit, enter new value");
            }*/

            if(n == -6) {
                lcd2.locate(5,6);
                if((suit==1)||(suit==2))lcd2.foreground(0x000000);
                if((suit==3)||(suit==4))lcd2.foreground(0xFF0000);
                if(suit == 1) {
                    y = 'S';
                } else if(suit == 2) {
                    y = 'C';
                } else if(suit == 3) {
                    y = 'H';
                } else y = 'D';
                if(card==2) x = '2';
                else if(card == 3) x = '3';
                else if(card == 4) x = '4';
                else if(card == 5) x = '5';
                else if(card == 6) x = '6';
                else if(card == 7) x = '7';
                else if(card == 8) x = '8';
                else if(card == 9) x = '9';
                else if(card == 0) {
                    x = '1';
                    w = '0';
                    lcd2.printf(" %c %c%c", y, x, w);
                } else if(card == 11) x = 'J';
                else if (card == 12) x = 'Q';
                else if (card == 13) x = 'K';
                else if (card == 1) x = 'A';
                if(card!=10)lcd2.printf(" %c %c", y, x);
            }

            if(n == -5) {
                lcd2.locate(5,8);
                if((suit==1)||(suit==2))lcd2.foreground(0x000000);
                if((suit==3)||(suit==4))lcd2.foreground(0xFF0000);
                if(suit == 1) {
                    y = 'S';
                } else if(suit == 2) {
                    y = 'C';
                } else if(suit == 3) {
                    y = 'H';
                } else y = 'D';
                if(card==2) x = '2';
                else if(card == 3) x = '3';
                else if(card == 4) x = '4';
                else if(card == 5) x = '5';
                else if(card == 6) x = '6';
                else if(card == 7) x = '7';
                else if(card == 8) x = '8';
                else if(card == 9) x = '9';
                else if(card == 10) {
                    x = '1';
                    w = '0';
                    lcd2.printf(" %c %c%c", y, x, w);
                } else if(card == 11) x = 'J';
                else if (card == 12) x = 'Q';
                else if (card == 13) x = 'K';
                else if (card == 1) x = 'A';
                if(card!=10)lcd2.printf(" %c %c", y, x);
            }
            break;
        case 2:
            lcd1.cls();
            break;
        case 3:
            lcd2.cls();
            break;
        default:
            lcd1.cls();
            lcd2.cls();
            x=1;
            break;

    }
    wait(rand()%1);
}

int read_keypad(int n)
{

    pc.printf("\nHello from the mbed & mpr121\n\r");

    Timer t;
    //float s;
    //int turn;
    unsigned char dataArray[2];
    unsigned int Amount[6];
    int max = 6;
    unsigned int Total = 0;
    int key = 0;
    int count = 0;
    //unsigned int card[2] = {3,12};
    //unsigned char suit[2] = {'S','H'};

    t.reset();
    t.start();

    while(1) {
        //pc.printf("\n Entered value is:");
        if(t.read() == 60.0) {
            print_on_lcd(-4, 0, 0, n);
            t.stop();
            return 0;
        }
        if((n == 0)||(n == 1)) {
            if(n == 0) {
                dataArray[0] = mpr1.read(0x00);
                dataArray[1] = mpr1.read(0x01);
            } else if(n == 1) {
                dataArray[0] = mpr2.read(0x00);
                dataArray[1] = mpr2.read(0x01);
            }
            if(dataArray[0] != 0) {
                switch(dataArray[0]) {
                    case 8:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 1);
                        //print_on_lcd(1);
                        Amount[count] = 1;
                        count++;
                        break;
                    case 128:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 2);
                        // print_on_lcd(2);
                        Amount[count] = 2;
                        count++;
                        break;
                    case 4:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 4);
                        //  print_on_lcd(4);
                        Amount[count] = 4;
                        count++;
                        break;
                    case 64:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 5);
                        Amount[count] = 5;
                        //  print_on_lcd(5);
                        count++;
                        break;
                    case 2:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 7);
                        Amount[count] = 7;//print_on_lcd(7);
                        count++;
                        break;
                    case 32:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 8);//print_on_lcd(8);
                        Amount[count] = 8;
                        count++;
                        break;
                    case 1:

                        if(count != 0) {
                            while( count != 0) {
                                Total += Amount[key]*(pow( 10, (float) (count-1) ));
                                count--;
                                key++;
                            }
                            pc.printf("Total is: %d \r\n",Total);
                            //print_on_lcd(Total, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            t.stop();
                            return Total;
                        } else {
                            pc.printf("MPR value: %s \r\n", "Call");
                            print_on_lcd(-2, 0, 0, n);
                            t.stop();
                            return -2;
                        }
                    case 16:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 0);
                        Amount[count] = 0;
                        count++;
                        break;
                }
                wait(0.5);
                dataArray[0] = 0;
            } else {
                if(dataArray[1] != 0) {
                    switch(dataArray[1]) {
                        case 8:
                            if(count == max) {
                                pc.printf("Exceeds limit, enter new value \r\n");
                                //print_on_lcd(-3, 0, 0, n);
                                for(int i=0; i<6; i++) {
                                    Amount[i] = 0;
                                }
                                count = 0;
                                break;
                            }
                            pc.printf("MPR value: %d \r\n", 3);
                            Amount[count] = 3;
                            count++;
                            break;
                        case 4:
                            if(count == max) {
                                pc.printf("Exceeds limit, enter new value \r\n");
                                //print_on_lcd(-3, 0, 0, n);
                                for(int i=0; i<6; i++) {
                                    Amount[i] = 0;
                                }
                                count = 0;
                                break;
                            }
                            pc.printf("MPR value: %d \r\n", 6);
                            Amount[count] = 6;
                            count++;
                            break;
                        case 2:
                            if(count == max) {
                                pc.printf("Exceeds limit, enter new value \r\n");
                                //print_on_lcd(-3, 0, 0, n);
                                for(int i=0; i<6; i++) {
                                    Amount[i] = 0;
                                }
                                count = 0;
                                break;
                            }
                            pc.printf("MPR value: %d \r\n", 9);
                            Amount[count] = 9;
                            count++;
                            break;
                        case 1:
                            if(count != 0) {
                                while( count != 0) {
                                    Total += Amount[key]*(pow( 10, (float) (count-1) ));
                                    count--;
                                    key++;
                                }
                                pc.printf("Total is: %d \r\n",Total);
                                //print_on_lcd(Total, 0, 0, n);
                                for(int i=0; i<6; i++) {
                                    Amount[i] = 0;
                                }
                                t.stop();
                                return Total;
                            } else {
                                pc.printf("MPR value: %s \r\n", "Fold");
                                //print_on_lcd(-1, 0, 0, n);
                                for(int i=0; i<6; i++) {
                                    Amount[i] = 0;
                                }
                                count = 0;
                                t.stop();
                                return 0;
                            }
                    }
                    wait(0.5);
                    dataArray[1] = 0;
                }
            }
        } else {
        }
    }
}

int main()
{
    char temp = '0',index,tempc,temp_suit,temp_card, n=0;
    int player = 0, Amount,Amount1,temp_int,temp_int1,i=0,arr[7],suit[2],card[2];
    //wait(3);
    lcd1.reset();
    lcd1.foreground(0x000000);
    lcd1.background(0x2b8135);
    lcd1.fill(0, 0, 136, 136, 0x2b8135);
    lcd1.locate(0,1);

    lcd2.reset();
    lcd2.foreground(0x000000);
    lcd2.background(0x2b8135);
    lcd2.fill(0, 0, 136, 136, 0x2b8135);
    lcd2.locate(0,1);
    n=0;

    while(1) {
        pc.printf("\nPlayer id is:");
        temp = device.getc();
        if(n==2)n=0;
        i=0;
        pc.putc(temp);


        if(temp == '3') player = 0;
        if(temp == '4') player = 1;
        if(temp == '6') {
            print_on_lcd(2,0,0,player);
            print_on_lcd(3,0,0,player);
            //device.putc(temp);
        } else {
            //device.putc(temp);

            temp = device.getc();
            pc.printf("\noutside M");
            if(temp == 'M') {
                //device.putc(temp);
                pc.printf("\ninside M");
                tempc = device.getc();
                //pc.printf("\ntempc=%c",tempc);
                //for(int i=0; i<6; i++) {
                //index = device.getc();
                while(tempc != 'D') {
                    arr[i] =(tempc)-48;
                    pc.printf("\narr[i]=%d",arr[i]);
                    //if(i==5) tempc = device.getc();
                    tempc = device.getc();
                    //pc.printf("\ntempc=%c",tempc);
                    i++;
                }
                //Amount1=0;
                //Amount1 = 1+arr[4];
                //pc.printf("\namount = %d",Amount1);
                //Amount1 = (arr[1]*1) + (arr[2]*10) + (arr[3]*100) + (arr[4]*1000);
                Amount1 = 0;
                for(int j=0; j<6; j++) {
                    Amount1 = Amount1 + ((pow (10, (float) (j))) * arr[j]);
                    pc.printf("\nAmount = %d of player %d",Amount1,player);
                }
                //if(Amount1 == 500) Amount1 = Amount1*10;
                pc.printf("\nAmount = %d of player %d",Amount1,player);

                print_on_lcd(Amount1, player, 0, -9);
                Amount1=0;
                Amount = read_keypad(player);
                if(Amount == -2) device.putc('C');
                else if(Amount == 0) device.putc('F');
                else {
                    device.putc('R');
                    temp_int = Amount1-Amount;
                    for(int i=0; i<7; i++) {
                        temp_int1 = temp_int% ((int)(pow(10, (float)1)));
                        temp_int = temp_int/10;
                        device.putc( (char) temp_int1);
                    }
                    print_on_lcd(Amount1-Amount, player, 0, -9);
                    device.putc('R');
                }
                //print_on_lcd(Amount1-Amount, player, 0, -9);
            }

            if(temp == 'I') {
                temp_suit = device.getc();
                temp_card = device.getc();

                if(temp_suit == 'S') {
                    suit[player] = 1;
                } else if(temp_suit == 'C') {
                    suit[player] = 2;
                } else if(temp_suit == 'H') {
                    suit[player] = 3;
                } else suit[player] = 4;
                if(temp_card=='2') card[player] = 2;
                else if(temp_card == '3') card[player] = 3;
                else if(temp_card == '4') card[player] = 4;
                else if(temp_card == '5') card[player] = 5;
                else if(temp_card == '6') card[player] = 6;
                else if(temp_card == '7') card[player] = 7;
                else if(temp_card == '8') card[player] = 8;
                else if(temp_card == '9') card[player] = 9;
                else if(temp_card == '0') card[player] = 10;
                else if(temp_card == 'J') card[player] = 11;
                else if (temp_card == 'Q') card[player] = 12;
                else if (temp_card == 'K') card[player] = 13;
                else if (temp_card == 'A') card[player] = 1;
                print_on_lcd(n-6,suit[player],card[player],player);
                pc.printf("\nPlayer:%d suit:%d face:%d n-6:%d", player, suit[player], card[player],n-6);
                n++;
            }

            if(temp == 'Z') {
                if(player == 0)
                    print_on_lcd(0,0,0,2);
                if(player == 1)
                    print_on_lcd(0,0,0,3);
            }
        }
    }
}