#include <mbed.h>
#include <string>
#include <list>
#include <mpr121.h>
#include "NokiaLCD.h"

Serial pc(USBTX, USBRX);

Serial device(p13,p14);

// Setup the i2c bus on pins 28 and 27
I2C i2c2(p9, p10);
I2C i2c1(p28, p27);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr2(&i2c1, Mpr121::ADD_VSS);
Mpr121 mpr1(&i2c2, Mpr121::ADD_VSS);

NokiaLCD lcd1(p5, p7, p8, p15, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
NokiaLCD lcd3(p5, p7, p16, p17, NokiaLCD::LCD6610);
NokiaLCD lcd2(p5, p7, p18, p19, NokiaLCD::LCD6610);


int z=0, cards[52][2];

int secondary_players(int player_id, int Total, int face)
{
    int temp_int, arr[7],i = 0, Amount = 0, temp_int1;
    char temp = '0',operation;

    if(player_id == 2) device.putc('3');
    if(player_id == 3) device.putc('4');
    if(player_id == 0) device.putc('6');

    // temp= device.getc();
    wait(0.5);
    if((Total > 0) && (face == 0)) {
        device.putc('M');
        //temp=device.getc();
        pc.printf("\ninside M");
        temp_int = Total;
        //device.putc('0');
        //device.putc('0');
        for(int i=0; i<7; i++) {
            // wait(0.5);
            temp_int1 = temp_int% ((int)(pow(10, (float)1)));
            temp_int = temp_int/10;
            if(temp_int1 == 0) device.putc('0');
            if(temp_int1 == 1) device.putc('1');
            if(temp_int1 == 2) device.putc('2');
            if(temp_int1 == 3) device.putc('3');
            if(temp_int1 == 4) device.putc('4');
            if(temp_int1 == 5) device.putc('5');
            if(temp_int1 == 6) device.putc('6');
            if(temp_int1 == 7) device.putc('7');
            if(temp_int1 == 8) device.putc('8');
            if(temp_int1 == 9) device.putc('9');
            pc.printf("\namount:%d", temp_int1);
            //temp=device.getc();
        }
        device.putc('D');
        operation = device.getc();
        wait(1);

        for(int i=0; i<7; i++) arr[i] = 0;

        //i = 0;

        if(operation == 'C') return -2;//pc.printf("\nCALL");
        if(operation == 'F') return 0;//pc.printf("\nFOLD");
        if(operation == 'R') {
            //pc.printf("\nRAISE"); reading the bet amount from secondary mbed
            temp = device.getc();
            while(temp != 'R') {
                arr[i] = temp;
                pc.printf("\narr[i]=%d",arr[i]);
                i++;
                temp = device.getc();
            }
            for(int j=0; j<i; j++) {
                Amount = Amount + ((pow (10, (float) (j))) * arr[j]);
            }
            return Amount;
            //pc.printf("\nAmount = %d",Amount);
        }
    }

    if(face != 0) {
        device.putc('I');

        if(Total == 1) {
            device.putc('S');
        } else if(Total == 2) {
            device.putc('C');
        } else if(Total == 3) {
            device.putc('H');
        } else device.putc('D');
        if(face==2) device.putc('2');
        else if(face == 3) device.putc('3');
        else if(face == 4) device.putc('4');
        else if(face == 5) device.putc('5');
        else if(face == 6) device.putc('6');
        else if(face == 7) device.putc('7');
        else if(face == 8) device.putc('8');
        else if(face == 9) device.putc('9');
        else if(face == 10) device.putc('0');
        else if(face == 11) device.putc('J');
        else if (face == 12) device.putc('Q');
        else if (face == 13) device.putc('K');
        else if (face == 1) device.putc('A');

    }

    if((Total == 0) && (face == 0) && (player_id != 0)) {
        device.putc('Z');
    }

}

void print_on_dealerlcd( int n, int card, int suit, int op)
{

    //lcd2.reset();
    //lcd3.background(0x73fb76);
    //lcd3.cls();
    //lcd3.locate(0,1);
    char x, y, w;
    int m;
    x=0;
    if(op == 1) {
        lcd3.locate(0,1);
        if(n==0)lcd3.printf("Common cards:");
        if(n<3) {
            lcd3.locate(2+3*n,4+3*n);
        } else {
            m=n-3;
            lcd3.locate(6+3*m,4+3*m);
        }
        if((suit==1)||(suit==2))lcd3.foreground(0x000000);
        if((suit==3)||(suit==4))lcd3.foreground(0xFF0000);
        if(suit == 1) {
            y = 'S';
        } else if(suit == 2) {
            y = 'C';
        } else if(suit == 3) {
            y = 'H';
        } else y = 'D';
        if(card==2) x = '2';
        else if(card == 3) x = '3';
        else if(card == 4) x = '4';
        else if(card == 5) x = '5';
        else if(card == 6) x = '6';
        else if(card == 7) x = '7';
        else if(card == 8) x = '8';
        else if(card == 9) x = '9';
        else if(card == 10) {
            x = '1';
            w = '0';
            lcd3.printf(" %c%c",x,w);
            lcd3.printf(" %c", y);
        } else if(card == 11) x = 'J';
        else if (card == 12) x = 'Q';
        else if (card == 13) x = 'K';
        else if (card == 1) x = 'A';
        if(card!=10) {
            lcd3.printf(" %c",x);
            lcd3.printf(" %c", y);
        }

    } else if(op == 2) {
        lcd3.locate(0,13);
        lcd3.foreground(0x000000);
        lcd3.printf("Current player:%d", n+1);
    } else if(op == 3) {
        lcd3.locate(0,15);
        lcd3.foreground(0x000000);
        lcd3.printf("Current Pot:%d", n);
    } else {
        lcd3.reset();
        lcd3.foreground(0x000000);
        lcd3.background(0x2b8135);
        lcd3.fill(0, 0, 136, 136, 0x2b8135);
        lcd3.locate(0,0);
    }
}

void print_on_lcd(int n, int suit, int card, int id)
{
    char x,y,w;
    x = 0;
    y = 0;
    w = 0;
    switch(id) {
        case 0:
            // lcd1.reset();
            lcd1.background(0x2b8135);
            lcd1.foreground(0x000000);
            // lcd1.cls();
            lcd1.locate(0,3);
            if(n >= 0) {
                lcd1.printf("Raise to %d",n);
            }
            if(n == -1) {
                lcd1.printf("Fold");
            }
            if(n == -2) {
                lcd1.printf("Call");
            }
            if(n == -4) {
                lcd1.reset();
                lcd1.cls();
                lcd1.printf("Time up!");
            }
            if (n==-3) {
                lcd1.printf("Exceeds limit, enter new value");
            }

            if(n == -6) {
                lcd1.locate(5,6);
                if(suit == 1) {
                    y = 'S';
                } else if(suit == 2) {
                    y = 'C';
                } else if(suit == 3) {
                    y = 'H';
                } else y = 'D';
                if((y=='S')||(y=='C'))lcd1.foreground(0x000000);
                if((y=='H')||(y=='D'))lcd1.foreground(0xFF0000);
                if(card==2) x = '2';
                else if(card == 3) x = '3';
                else if(card == 4) x = '4';
                else if(card == 5) x = '5';
                else if(card == 6) x = '6';
                else if(card == 7) x = '7';
                else if(card == 8) x = '8';
                else if(card == 9) x = '9';
                else if(card == 10) {
                    x = '1';
                    w = '0';
                    lcd1.printf("%c%c %c", x, w, y);
                } else if(card == 11) x = 'J';
                else if (card == 12) x = 'Q';
                else if (card == 13) x = 'K';
                else if (card == 1) x = 'A';
                if(card!=10)lcd1.printf(" %c %c",x, y);
            }
            if(n == -5) {
                lcd1.locate(5,8);
                if(suit == 1) {
                    y = 'S';
                } else if(suit == 2) {
                    y = 'C';
                } else if(suit == 3) {
                    y = 'H';
                } else y = 'D';
                if((y=='S')||(y=='C'))lcd1.foreground(0x000000);
                if((y=='H')||(y=='D'))lcd1.foreground(0xFF0000);
                if(card==2) x = '2';
                else if(card == 3) x = '3';
                else if(card == 4) x = '4';
                else if(card == 5) x = '5';
                else if(card == 6) x = '6';
                else if(card == 7) x = '7';
                else if(card == 8) x = '8';
                else if(card == 9) x = '9';
                else if(card == 10) {
                    x = '1';
                    w = '0';
                    lcd1.printf("%c%c %c", x, w, y);
                } else if(card == 11) x = 'J';
                else if (card == 12) x = 'Q';
                else if (card == 13) x = 'K';
                else if (card == 1) x = 'A';
                if(card!=10)lcd1.printf(" %c %c", x, y);
            }
            break;
        case -9:
            if(suit==0) {
                lcd1.foreground(0x000000);
                lcd1.locate(0, 1);
                lcd1.printf("Current wallet:");
                lcd1.locate(6,3);
                lcd1.printf("%d",n);
            } else if(suit==1) {
                lcd2.foreground(0x000000);
                lcd2.locate(0, 1);
                lcd2.printf("Current wallet:");
                lcd2.locate(6,3);
                lcd2.printf("%d",n);
            }
            break;
        case -8://(bet-Playerbet[ID],ID, 0, -8)
            /*if(suit==0) {
                lcd1.foreground(0x000000);
                lcd1.locate(4, 10);
                if(card==0)lcd1.printf("To Call: ");
                if(card==1)lcd1.printf("To Raise:");
                lcd1.locate(6,12);
                lcd1.printf("%d",n);
            } else if(suit==1) {
                lcd2.foreground(0x000000);
                lcd2.locate(4, 10);
                if(card==0)lcd2.printf("To Call:");
                if(card==1)lcd2.printf("To Raise:");
                lcd2.locate(6,12);
                lcd2.printf("%d",n);
            }*/
            break;
        case 1:
            //lcd2.reset();
            lcd2.background(0x2b8135);
            lcd2.foreground(0x000000);
            //lcd2.cls();
            lcd2.locate(0,3);
            if(n >= 0) {
                lcd2.printf("Raise to %d",n);
            }
            if(n == -1) {
                lcd2.printf("Fold");
            }
            if(n == -2) {
                lcd2.printf("Call");
            }
            if(n == -4) {
                lcd2.reset();
                lcd2.cls();
                lcd2.printf("Time up!");
            }
            if (n == -3) {
                lcd2.printf("Exceeds limit, enter new value");
            }

            if(n != -6) {
                lcd2.locate(5,6);
                if(suit == 1) {
                    y = 'S';
                } else if(suit == 2) {
                    y = 'C';
                } else if(suit == 3) {
                    y = 'H';
                } else y = 'D';
                if((y=='S')||(y=='C'))lcd2.foreground(0x000000);
                if((y=='H')||(y=='D'))lcd2.foreground(0xFF0000);
                if(card==2) x = '2';
                else if(card == 3) x = '3';
                else if(card == 4) x = '4';
                else if(card == 5) x = '5';
                else if(card == 6) x = '6';
                else if(card == 7) x = '7';
                else if(card == 8) x = '8';
                else if(card == 9) x = '9';
                else if(card == 10) {
                    x = '1';
                    w = '0';
                    lcd2.printf("%c%c %c", x, w, y);
                } else if(card == 11) x = 'J';
                else if (card == 12) x = 'Q';
                else if (card == 13) x = 'K';
                else if (card == 1) x = 'A';
                if(card!=10)lcd2.printf(" %c %c", x, y);
            }

            if(n != -5) {
                lcd2.locate(5,8);
                if(suit == 1) {
                    y = 'S';
                } else if(suit == 2) {
                    y = 'C';
                } else if(suit == 3) {
                    y = 'H';
                } else y = 'D';
                if((y=='S')||(y=='C'))lcd2.foreground(0x000000);
                if((y=='H')||(y=='D'))lcd2.foreground(0xFF0000);
                if(card==2) x = '2';
                else if(card == 3) x = '3';
                else if(card == 4) x = '4';
                else if(card == 5) x = '5';
                else if(card == 6) x = '6';
                else if(card == 7) x = '7';
                else if(card == 8) x = '8';
                else if(card == 9) x = '9';
                else if(card == 10) {
                    x = '1';
                    w = '0';
                    lcd2.printf("%c %c%c", x, w, y);
                } else if(card == 11) x = 'J';
                else if (card == 12) x = 'Q';
                else if (card == 13) x = 'K';
                else if (card == 1) x = 'A';
                if(card!=10)lcd2.printf(" %c %c", x, y);
            }
            break;
        case 2:
            lcd1.cls();
            break;
        case 3:
            lcd2.cls();
            break;
        default:
            lcd2.cls();
            lcd1.cls();
            break;

    }
    wait(rand()%1);
}

int read_keypad(int n)
{

    pc.printf("\nHello from the mbed & mpr121\n\r");

    Timer t;
    //float s;
    //int turn;
    unsigned char dataArray[2];
    unsigned int Amount[6];
    int max = 6;
    unsigned int Total = 0;
    int key = 0;
    int count = 0;
    //unsigned int card[2] = {3,12};
    //unsigned char suit[2] = {'S','H'};

    t.reset();
    t.start();

    while(1) {
        //pc.printf("\n Entered value is:");
        if(t.read() == 60.0) {
            //print_on_lcd(-4, 0, 0, n);
            t.stop();
            return 0;
        }
        if((n == 0)||(n == 1)) {
            if(n == 0) {
                dataArray[0] = mpr1.read(0x00);
                dataArray[1] = mpr1.read(0x01);
            } else if(n == 1) {
                dataArray[0] = mpr2.read(0x00);
                dataArray[1] = mpr2.read(0x01);
            }
            if(dataArray[0] != 0) {
                switch(dataArray[0]) {
                    case 8:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 1);
                        //print_on_lcd(1);
                        Amount[count] = 1;
                        count++;
                        break;
                    case 128:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 2);
                        // print_on_lcd(2);
                        Amount[count] = 2;
                        count++;
                        break;
                    case 4:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 4);
                        //  print_on_lcd(4);
                        Amount[count] = 4;
                        count++;
                        break;
                    case 64:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 5);
                        Amount[count] = 5;
                        //  print_on_lcd(5);
                        count++;
                        break;
                    case 2:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 7);
                        Amount[count] = 7;//print_on_lcd(7);
                        count++;
                        break;
                    case 32:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 8);//print_on_lcd(8);
                        Amount[count] = 8;
                        count++;
                        break;
                    case 1:

                        if(count != 0) {
                            while( count != 0) {
                                Total += Amount[key]*(pow( 10, (float) (count-1) ));
                                count--;
                                key++;
                            }
                            pc.printf("Total is: %d \r\n",Total);
                            //print_on_lcd(Total, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            t.stop();
                            return Total;
                        } else {
                            pc.printf("MPR value: %s \r\n", "Call");
                            //print_on_lcd(-2, 0, 0, n);
                            t.stop();
                            return -2;
                        }
                    case 16:
                        if(count == max) {
                            pc.printf("Exceeds limit, enter new value \r\n");
                            //print_on_lcd(-3, 0, 0, n);
                            for(int i=0; i<6; i++) {
                                Amount[i] = 0;
                            }
                            count = 0;
                            break;
                        }
                        pc.printf("MPR value: %d \r\n", 0);
                        Amount[count] = 0;
                        count++;
                        break;
                }
                wait(0.5);
                dataArray[0] = 0;
            } else {
                if(dataArray[1] != 0) {
                    switch(dataArray[1]) {
                        case 8:
                            if(count == max) {
                                pc.printf("Exceeds limit, enter new value \r\n");
                                //print_on_lcd(-3, 0, 0, n);
                                for(int i=0; i<6; i++) {
                                    Amount[i] = 0;
                                }
                                count = 0;
                                break;
                            }
                            pc.printf("MPR value: %d \r\n", 3);
                            Amount[count] = 3;
                            count++;
                            break;
                        case 4:
                            if(count == max) {
                                pc.printf("Exceeds limit, enter new value \r\n");
                                //print_on_lcd(-3, 0, 0, n);
                                for(int i=0; i<6; i++) {
                                    Amount[i] = 0;
                                }
                                count = 0;
                                break;
                            }
                            pc.printf("MPR value: %d \r\n", 6);
                            Amount[count] = 6;
                            count++;
                            break;
                        case 2:
                            if(count == max) {
                                pc.printf("Exceeds limit, enter new value \r\n");
                                //print_on_lcd(-3, 0, 0, n);
                                for(int i=0; i<6; i++) {
                                    Amount[i] = 0;
                                }
                                count = 0;
                                break;
                            }
                            pc.printf("MPR value: %d \r\n", 9);
                            Amount[count] = 9;
                            count++;
                            break;
                        case 1:
                            if(count != 0) {
                                while( count != 0) {
                                    Total += Amount[key]*(pow( 10, (float) (count-1) ));
                                    count--;
                                    key++;
                                }
                                pc.printf("Total is: %d \r\n",Total);
                                //print_on_lcd(Total, 0, 0, n);
                                for(int i=0; i<6; i++) {
                                    Amount[i] = 0;
                                }
                                t.stop();
                                return Total;
                            } else {
                                pc.printf("MPR value: %s \r\n", "Fold");
                                //print_on_lcd(-1, 0, 0, n);
                                for(int i=0; i<6; i++) {
                                    Amount[i] = 0;
                                }
                                count = 0;
                                t.stop();
                                return 0;
                            }
                    }
                    wait(0.5);
                    dataArray[1] = 0;
                }
            }
        } else {
        }
    }
}

int checkcard ( int suit, int face, int reset)
{
    int i;

    switch(z) {
        case 0:
            cards[0][0]=suit;
            cards[0][1]=face;
            z++;
            break;
        default:
            for(i=0; i<z; i++) {
                if((cards[i][0]==suit)&&(cards[i][1]==face)) {
                    return 1;
                }
            }
            cards[z][0]=suit;
            cards[z][1]=face;
            z++;
            break;
    }
    if(reset==1) {
        z=0;
    }
    return 0;
}

//Main Poker Program
//Main Poker Program
int main()
{
    //initialize variables
    int pot=0, bet, bet2, round, check, temp, hand, suit, ID=0, blind=-1;
    int i, k, j, p=0, r, n, t;

    //seed random number generator

    srand(time(NULL));

    //ask how many players
    print_on_dealerlcd( 0, 0, 0, 4);
    lcd1.reset();
    lcd1.foreground(0x000000);
    lcd1.background(0x2b8135);
    lcd1.fill(0, 0, 136, 136, 0x2b8135);
    lcd1.locate(0,1);

    lcd2.reset();
    lcd2.foreground(0x000000);
    lcd2.background(0x2b8135);
    lcd2.fill(0, 0, 136, 136, 0x2b8135);
    lcd2.locate(0,1);

    while(p<2) {
        lcd1.printf("How many players?");
        pc.printf("\nAmount of players?");
        p=read_keypad(0);
        //p=2;
        if(p<2)pc.printf("\nnot enough players...");

    }
    int playermoney[p];

    //ask how much each player should start out with
    //while((pot<100)||(pot>1000000/p)) {
    lcd1.cls();
    lcd1.locate(0,1);
    lcd1.printf("Money each player starts with?");
    pc.printf("Money each player starts with?\n");
    pc.printf("\nbetween $100-$%d",1000000/p);
    pot=read_keypad(0);
    //pot=2000;
    //}
    for(k=0; k<p; k++) {
        playermoney[k]=pot;
        pc.printf("player %d\n", k+1);
    }

    //ask size of blind
    while((blind<0)||(blind>pot/16)) {
        lcd1.cls();
        lcd1.locate(0,1);
        lcd1.printf("Size of large");
        lcd1.locate(0,3);
        lcd1.printf("blind?");
        pc.printf("\nSize of large blind?");
        lcd1.locate(0,5);
        lcd1.printf("Between $0-$%d",pot/16);
        blind=read_keypad(0);
        //blind=20;
    }
    lcd1.cls();

    pot=0;

    //determine hands played to see who should be dealer
    for(hand=0; p>1; hand++) {
        int playerbet[p], playersuit[p][2], playerface[p][2], communitys[5], highcard[p], playerscore[p], AB[p], AP;
        int communityf[5], handface[7], handsuit[7], spade, heart, club, diamond, pot=0, count[14], m=0;
        i=checkcard(0,0,1);
        pc.printf("\n hand %d",hand);
        for(k=0; k<p; k++) {
            AB[k]=0;
        }
        AP=p;
        t=secondary_players(0, 0, 0);
        print_on_lcd(0, 0, 0, -10);


        for(round=1; round<5; round++) {
            for(k=0; k<p; k++) {
                playerbet[k]=0;
            }
            if(AP>1) {
                switch(round) {
                        //first round lay players cards
                    case 1 :
                        print_on_dealerlcd( 0, 0, 0, 4);
                        for (r=0; r<p; r++) {
                            for (k=0; k<2; k++) {
                                playersuit[r][k]= (rand()%4)+1;
                                playerface[r][k]= (rand()%13)+1;
                                check = checkcard( playersuit[r][k], playerface[r][k], 0);
                                pc.printf("\nCheck 1= %d",check);
                                if(check==1) {
                                    k--;
                                } else {
                                    if(r<2) {
                                        print_on_lcd(k-6, playersuit[r][k], playerface[r][k], r);
                                    } else {
                                        t=secondary_players(r, playersuit[r][k], playerface[r][k]);
                                    }
                                    pc.printf("\n operation:%d\t suit:%d\t face:%d\t player%d", k-6, playersuit[r][k], playerface[r][k], r+1);
                                }
                            }
                        }
                        break;

                        //second round lay 3 cards on table
                    case 2 :
                        for(k=0; k<3; k++) {
                            communitys[k]=(rand()%4)+1;
                            communityf[k]=(rand()%13)+1;
                            pc.printf("\n Amount:%d\t card:%d\t face:%d\t suit:%d\t Operation:%d ", 0, k, communityf[k], communitys[k], 1);
                            //function to make sure no cards are the same
                            check = checkcard ( communitys[k], communityf[k], 0);
                            pc.printf("\nCheck 2= %d",check);
                            if(check==1) {
                                k--;
                            } else {
                                print_on_dealerlcd( k, communityf[k], communitys[k], 1);
                                pc.printf("\n Amount:%d\t card:%d\t face:%d\t suit:%d\t Operation:%d ", 0, k, communityf[k], communitys[k], 1);
                                wait(rand()%1);
                            }
                        }
                        break;

                        //third round lay single card on table
                    case 3 :
                        for(k=0; k<1; k++) {
                            communitys[3]=(rand()%4)+1;
                            communityf[3]=(rand()%13)+1;
                            check = checkcard ( communitys[3], communityf[3], 0);
                            pc.printf("\n Amount:%d\t card:%d\t face:%d\t suit:%d\t Operation:%d ", 0, k, communityf[3], communitys[3], 1);
                            pc.printf("\nCheck 3= %d",check);
                            if(check==1) {
                                k--;
                            } else {
                                print_on_dealerlcd( 3, communityf[3], communitys[3], 1);
                                pc.printf("\n Amount:%d\t card:%d\t face:%d\t suit:%d\t Operation:%d ", 0, 3, communityf[3], communitys[3], 1);
                                wait(rand()%1);
                            }
                        }
                        break;

                        //fourth round lay single card on table
                    case 4 :
                        for(k=0; k<1; k++) {
                            communitys[4]=(rand()%4)+1;
                            communityf[4]=(rand()%13)+1;
                            check = checkcard ( communitys[4], communityf[4], 0);
                            if(check==1) {
                                k--;
                                pc.printf("\nCheck 4= %d",check);
                            } else {
                                print_on_dealerlcd( 4, communityf[4], communitys[4], 1);
                                wait(rand()%1);
                                pc.printf("\n Amount:%d\t card:%d\t face:%d \t suit:%d\t Operation:%d ", 0, 4, communityf[4], communitys[4], 1);
                            }
                        }
                        break;
                }

                //take bets from each player
                if(round!=1) bet=0;
                if(round==1) bet=blind;
                temp = hand%p;
                pc.printf("\ntemp:%d",temp);
                n=0;
                r=0;
                bet2=0;
                ID = temp;
                while(r<p) {
                    while(ID <= (p-1) ) {
                        if(AP>1) {
                            if((m==1)&&(blind!=0)) {
                                print_on_lcd(playermoney[ID]-blind/2, ID, 0, -9);
                            } else {
                                print_on_lcd(playermoney[ID], ID, 0, -9);
                            }
                            print_on_dealerlcd( ID, 0, 0, 2);
                            pc.printf("\nr=%d",r);
                            pc.printf("\nstart while");
                            if(AB[ID]!=1) {
                                //ID = temp;
                                //for(ID=hand%p; ID<p; ID++) {
                                pc.printf("\nin while");
                                if((round==1)||(playerbet[ID]!=0)) {
                                    if((round==1)&&(m==0)&&(blind!=0))playerbet[ID]=bet;
                                    if((round==1)&&(m==1)&&(blind!=0))playerbet[ID]=bet/2;
                                }
                                if(playerbet[ID]==-2)playerbet[ID]=0;
                                pc.printf("\npot:%d player%dmoney:%d",pot, ID+1, playermoney[ID]);
                                pc.printf("\nplayer%d bet?", ID+1);
                                if(ID>1) {
                                    if((m==0)&&(blind!=0)) {
                                        n=-2;
                                    } else {
                                        n = secondary_players(ID, playermoney[ID],0);
                                    }
                                } else {
                                    if((m==0)&&(blind!=0)) {
                                        n=-2;
                                    } else {
                                        print_on_lcd(bet-playerbet[ID], ID, 0, -8);
                                        n=read_keypad(ID);
                                    }
                                }
                                pc.printf("\nbet:%d player%dbet:%d",bet, ID+1,playerbet[ID]);
                                switch(n) {
                                    case -2:
                                        if(bet > 0) {
                                            if((blind!=0)&&(m==0)) {
                                                if(playermoney[ID]>playerbet[ID]) {
                                                    pot+=playerbet[ID];
                                                    playermoney[ID]-=playerbet[ID];
                                                    print_on_dealerlcd( pot, 0, 0, 3);
                                                    r--;
                                                }
                                            } else if((blind!=0)&&(m==1)) {
                                                if(playermoney[ID]>blind) {
                                                    pot+=blind;
                                                    playermoney[ID]-=blind;
                                                    print_on_dealerlcd( pot, 0, 0, 3);
                                                }
                                            } else if(playerbet[ID]==0) {
                                                if(bet<=playermoney[ID]) {
                                                    playerbet[ID] = bet;
                                                    pot += playerbet[ID];
                                                    playermoney[ID] -= bet;
                                                    print_on_dealerlcd( pot, 0, 0, 3);
                                                } else {
                                                    playerbet[ID]=0;
                                                    AB[ID]=1;
                                                    AP--;
                                                    if(ID<2) {
                                                        print_on_lcd(0, 0, 0, ID+2);
                                                    } else {
                                                        t=secondary_players(ID, 0, 0);
                                                    }
                                                }
                                            } else if(playerbet[ID]!=0) {
                                                //if(m==1)playerbet[ID]=bet;
                                                if(((bet-playerbet[ID])<=playermoney[ID])&&(playerbet[ID]<=bet)) {
                                                    bet2 = bet-playerbet[ID];
                                                    pot += bet2 ;
                                                    playerbet[ID] = bet;
                                                    playermoney[ID] -= bet2;
                                                    pc.printf("\ntest");
                                                    print_on_dealerlcd( pot, 0, 0, 3);
                                                } else {
                                                    playerbet[ID]=0;
                                                    AB[ID]=1;
                                                    AP--;
                                                    if(ID<2) {
                                                        print_on_lcd(0, 0, 0, ID+2);
                                                    } else {
                                                        t=secondary_players(ID, 0, 0);
                                                    }
                                                }
                                            }
                                        }
                                        if(bet ==0)playerbet[ID]=-2;
                                        break;
                                    case 0:
                                        if(bet==0) {
                                            playerbet[ID]=-2;
                                            pc.printf("\n#01 bet:%d player%dbet:%d",bet, ID+1,playerbet[ID]);
                                            break;
                                        }
                                        playerbet[ID]=0;
                                        if((m==1)&&(blind!=0)) {
                                            playermoney[ID] -= bet/2;
                                            pot += bet/2;
                                            print_on_dealerlcd( pot, 0, 0, 3);
                                        }
                                        AB[ID]=1;
                                        AP--;
                                        if(ID<2) {
                                            print_on_lcd(0, 0, 0, ID+2);
                                        } else {
                                            t=secondary_players(ID, 0, 0);
                                        }
                                        pc.printf("\n#02 bet:%d player%dbet:%d",bet, ID+1,playerbet[ID]);
                                        break;
                                    default:
                                        if(playerbet[ID]==0) {
                                            playerbet[ID]=n;
                                            if((playerbet[ID]<=playermoney[ID])&&(playerbet[ID]>=bet)) {
                                                //function to ask for bets and check bet amount
                                                playermoney[ID] -= playerbet[ID];
                                                pot += playerbet[ID];
                                                bet = playerbet[ID];
                                                print_on_dealerlcd( pot, 0, 0, 3);
                                                r=0;
                                            } else {
                                                pc.printf("\nplayer bet Incorrect!");
                                                ID--;
                                                r--;
                                            }
                                            pc.printf("\ndef bet:%d player%dbet:%d",bet, ID+1,playerbet[ID]);
                                        } else if(playerbet[ID]!=0) {
                                            pc.printf("\ndef1 bet:%d player%dbet:%d pot:%d",bet, ID+1,playerbet[ID], pot);
                                            if((n<=playermoney[ID])&&(n>=bet-playerbet[ID])) {
                                                pot += n;
                                                playerbet[ID] += n;
                                                bet = playerbet[ID];
                                                playermoney[ID] -= n;
                                                r=0;
                                                print_on_dealerlcd( pot, 0, 0, 3);
                                            } else {
                                                pc.printf("\nplayer bet Incorrect!");
                                                ID--;
                                                r--;
                                            }
                                        }
                                }



                            }
                        }
                        print_on_lcd(bet-playerbet[ID], ID, 0, -8);
                        if(ID<2)print_on_lcd(playermoney[ID], ID, 0, -9);
                        r++;
                        ID++;
                        m++;
                        pc.printf("\nincrement");
                        if(r>=p)break;
                    }

                    for(ID=0; ID<temp; ID++) {
                        if(AP>1) {
                            if((m=1)&&(blind!=0)) {
                                print_on_lcd(playermoney[ID]-blind/2, ID, 0, -9);
                            } else {
                                print_on_lcd(playermoney[ID], ID, 0, -9);
                            }
                            print_on_dealerlcd( ID, 0, 0, 2);
                            pc.printf("\nr=%d",r);
                            pc.printf("\nstart for");
                            if(AB[ID]!=1) {
                                //ID = temp;
                                //for(ID=hand%p; ID<p; ID++) {
                                pc.printf("\nin for");
                                if((round==1)||(playerbet[ID]!=0)) {
                                    if((round==1)&&(m==0)&&(blind!=0))playerbet[ID]=bet;
                                    if((round==1)&&(m==1)&&(blind!=0))playerbet[ID]=bet/2;
                                }
                                if(playerbet[ID]==-2)playerbet[ID]=0;
                                pc.printf("\npot:%d player%dmoney:%d",pot, ID+1, playermoney[ID]);
                                pc.printf("\nplayer%d bet?", ID+1);
                                if(ID>1) {
                                    if((m==0)&&(blind!=0)) {
                                        n=-2;
                                    } else {
                                        n = secondary_players(ID, playermoney[ID],0);
                                    }
                                } else {
                                    if((m==0)&&(blind!=0)) {
                                        n=-2;
                                    } else {
                                        print_on_lcd(bet-playerbet[ID], ID, 0, -8);
                                        n=read_keypad(ID);
                                    }
                                }
                                pc.printf("\nbet:%d player%dbet:%d",bet, ID+1,playerbet[ID]);
                                switch(n) {
                                    case -2:
                                        if(bet > 0) {
                                            if((blind!=0)&&(m==0)) {
                                                if(playermoney[ID]>playerbet[ID]) {
                                                    pot+=playerbet[ID];
                                                    playermoney[ID]-=playerbet[ID];
                                                    print_on_dealerlcd( pot, 0, 0, 3);
                                                    r--;
                                                }
                                            } else if((blind!=0)&&(m==1)) {
                                                if(playermoney[ID]>blind) {
                                                    pot+=blind;
                                                    playermoney[ID]-=blind;
                                                    print_on_dealerlcd( pot, 0, 0, 3);
                                                }
                                            } else if(playerbet[ID]==0) {
                                                if(bet<=playermoney[ID]) {
                                                    playerbet[ID] = bet;
                                                    pot += playerbet[ID];
                                                    playermoney[ID] -= bet;
                                                    print_on_dealerlcd( pot, 0, 0, 3);
                                                } else {
                                                    playerbet[ID]=0;
                                                    AB[ID]=1;
                                                    AP--;
                                                    if(ID<2) {
                                                        print_on_lcd(0, 0, 0, ID+2);
                                                    } else {
                                                        t=secondary_players(ID, 0, 0);
                                                    }
                                                }
                                            } else if(playerbet[ID]!=0) {
                                                //if(m==1)playerbet[ID]=bet;
                                                if(((bet-playerbet[ID])<=playermoney[ID])&&(playerbet[ID]<=bet)) {
                                                    bet2 = bet-playerbet[ID];
                                                    pot += bet2 ;
                                                    playerbet[ID] = bet;
                                                    playermoney[ID] -= bet2;
                                                    pc.printf("\ntest");
                                                    print_on_dealerlcd( pot, 0, 0, 3);
                                                } else {
                                                    playerbet[ID]=0;
                                                    AB[ID]=1;
                                                    AP--;
                                                    if(ID<2) {
                                                        print_on_lcd(0, 0, 0, ID+2);
                                                    } else {
                                                        t=secondary_players(ID, 0, 0);
                                                    }
                                                }
                                            }
                                        }
                                        if(bet ==0)playerbet[ID]=-2;
                                        break;
                                    case 0:
                                        if(bet==0) {
                                            playerbet[ID]=-2;
                                            pc.printf("\n#01 bet:%d player%dbet:%d",bet, ID+1,playerbet[ID]);
                                            break;
                                        }
                                        playerbet[ID]=0;
                                        if((m==1)&&(blind!=0)) {
                                            playermoney[ID] -= bet/2;
                                            pot += bet/2;
                                            print_on_dealerlcd( pot, 0, 0, 3);
                                        }
                                        AB[ID]=1;
                                        AP--;
                                        if(ID<2) {
                                            print_on_lcd(0, 0, 0, ID+2);
                                        } else {
                                            t=secondary_players(ID, 0, 0);
                                        }
                                        pc.printf("\n#02 bet:%d player%dbet:%d",bet, ID+1,playerbet[ID]);
                                        break;
                                    default:
                                        if(playerbet[ID]==0) {
                                            playerbet[ID]=n;
                                            if((playerbet[ID]<=playermoney[ID])&&(playerbet[ID]>=bet)) {
                                                //function to ask for bets and check bet amount
                                                playermoney[ID] -= playerbet[ID];
                                                pot += playerbet[ID];
                                                bet = playerbet[ID];
                                                print_on_dealerlcd( pot, 0, 0, 3);
                                                r=0;
                                            } else {
                                                pc.printf("\nplayer bet Incorrect!");
                                                ID--;
                                                r--;
                                            }
                                            pc.printf("\ndef bet:%d player%dbet:%d",bet, ID+1,playerbet[ID]);
                                        } else if(playerbet[ID]!=0) {
                                            pc.printf("\ndef1 bet:%d player%dbet:%d pot:%d",bet, ID+1,playerbet[ID], pot);
                                            if((n<=playermoney[ID])&&(n>=bet-playerbet[ID])) {
                                                pot += n;
                                                playerbet[ID] += n;
                                                bet = playerbet[ID];
                                                playermoney[ID] -= n;
                                                r=0;
                                                print_on_dealerlcd( pot, 0, 0, 3);
                                            } else {
                                                pc.printf("\nplayer bet Incorrect!");
                                                ID--;
                                                r--;
                                            }
                                        }
                                }



                            }
                        }
                        print_on_lcd(bet-playerbet[ID], ID, 0, -8);
                        if(ID<2)print_on_lcd(playermoney[ID], ID, 0, -9);
                        r++;
                        //ID++;
                        m++;
                        pc.printf("\nincrement");
                        if(r>=p)break;
                    }
                }

            }
        }

        //determine player's score
        if(AP==1) {
            for(k=0; k<p; k++) {
                if(AB[k]==1)playerscore[k]=0;
                if(AB[k]!=1)playerscore[k]=10;
            }
        }
        if(AP>1) {
            for (k=0; k<p; k++) {
                spade=0;
                heart=0;
                diamond=0;
                club=0;
                suit=0;
                for(i=0; i<14; i++) {
                    count[i]=0;
                }
                playerscore[k]=0;
                if(playerbet[k]==0) {
                    playerscore[k]=0;
                } else {
                    for (j=0; j<5; j++) {
                        handface[j] = communityf[j];
                        handsuit[j] = communitys[j];
                    }
                    handface[5] = playerface[k][0];
                    handface[6] = playerface[k][1];
                    handsuit[5] = playersuit[k][0];
                    handsuit[6] = playersuit[k][1];
                    if(playerface[k][0]>=playerface[k][1]) {
                        highcard[k]=playerface[k][0];
                    } else {
                        highcard[k]=playerface[k][1];
                    }
                    for(j=0; j<7; j++) {
                        pc.printf("\nplayer%d face:%d", k+1, handface[j]);
                    }
                    pc.printf("\nplayer%d highcard:%d",k+1, highcard[k]);

                    //player score ranking
                    //Straight Flush = 9
                    //Four of a kind = 8
                    //Full House = 7
                    //Flush = 6
                    //Straight = 5
                    //Threee of a kind = 4
                    //Two pair = 3
                    //One Pair = 2
                    //High Card = 1
                    //determine how many cards of each suit and face value there are
                    for(i=0; i<7; i++) {
                        if(handsuit[i] == 1)spade++;
                        if(handsuit[i] == 2)club++;
                        if(handsuit[i] == 3)heart++;
                        if(handsuit[i] == 4)diamond++;
                    }
                    for(r=0; r<7; r++) {
                        for(j=0; j<13; j++) {
                            if(handface[r]==j+1)count[j]++;
                        }
                    }
                    for(j=0; j<14; j++) {
                        pc.printf("\nplayer%d r=%d count=%d",k+1,j,count[j]);
                    }
                    count[13]=count[0];

                    //determine if four of a kind
                    for(r=0; r<13; r++) {
                        if(count[r]==4) playerscore[k] = 8;
                    }
                    pc.printf("\nfour of a kind:%d", playerscore[k]);
                    //determine if Full House
                    if(playerscore[k]==0) {
                        for(i=0; i<7; i++) {
                            if(count[i] == 3) {
                                for(j=0; j<7; j++) {
                                    if(count[j] >= 2) {
                                        playerscore[k]=7;
                                    }
                                }
                            }
                        }
                    }
                    //Determine if flush
                    if((spade >= 5)&&((playersuit[k][1]== 1)||(playersuit[k][0] == 1))) {
                        playerscore[k] = 6;
                        suit = 1;
                    }
                    if((club >= 5)&&((playersuit[k][1]== 2)||(playersuit[k][0]==2))) {
                        playerscore[k] = 6;
                        suit = 2;
                    }
                    if((heart >= 5)&&((playersuit[k][1]== 3)||(playersuit[k][0]==3))) {
                        playerscore[k] = 6;
                        suit = 3;
                    }
                    if((diamond >= 5)&&((playersuit[k][1]== 2)||(playersuit[k][0]==2))) {
                        playerscore[k] = 6;
                        suit = 4;
                    }
                    pc.printf("\nplayer%d suit%d", k+1, suit);
                    //Determine if straight or straight flush
                    m=0;
                    for(i=0; i<14; i++) {
                        if((count[i]>=1)&&(count[i+1]>=1)) {
                            m++;
                            if(m>=4) {
                                if(((i-3<playerface[k][1])&&(playerface[k][1]<i+2))||((i-3<playerface[k][0])&&(playerface[k][0]<i+2))) {
                                    if(playerscore[k]==6) {
                                        if(((i-3<playerface[k][1])&&(playerface[k][1]<i+2)&&(playersuit[k][1]==suit))||((i-3<playerface[k][0])&&(playerface[k][0]<i+2)&&(playersuit[k][0]==suit))) {
                                            playerscore[k]=9;
                                        }
                                    } else {
                                        playerscore[k]=5;
                                    }
                                }
                            } else {
                                m=0;
                            }
                        }
                    }


                    //Determine if three of a kind, two pair, or pair
                    m=0;
                    if(playerscore[k]==0) {
                        for(i=0; i<13; i++) {
                            if(count[i]==3) {
                                playerscore[k]=4;
                            } else {
                                if(count[i]==2) {
                                    m++;
                                }

                            }
                        }
                        if(m==2)playerscore[k]=3;
                        if(m==1)playerscore[k]=2;
                    }


                    //determine if only high card
                    if(playerscore[k] == 0) playerscore[k] = 1;
                }
                pc.printf("\nprelim player%d score:%d",k+1,playerscore[k]);
            }
        }
//determine winner based off player score
        temp=0;
        for(i=0; i<p; i++) {
            if(temp<=playerscore[i]) {
                temp=playerscore[i];
            } else {
                playerscore[i]=0;
            }
        }
        for(i=0; i<p; i++) {
            if(playerscore[i]<temp)playerscore[i]=0;
        }
//determine amount of winners
        m=0;
        for(i=0; i<p; i++) {
            if(playerscore[i]>0) m++;
            //pc.printf("\n amount of winners:%d", m);
        }
//Determine high card if multiple winners
        temp=0;
        if(m>1) {
            for(i=0; i<p; i++) {
                if(temp<=highcard[i]) {
                    temp=highcard[i];
                } else {
                    highcard[i]=0;
                }
            }
            for(i=0; i<p; i++) {
                if(highcard[i]<temp)playerscore[i]=0;
            }
        }
//determine if two players have the same high card
        m=0;
        for(i=0; i<p; i++) {
            if(playerscore[i]>0) m++;
            //pc.printf("\n amount of winners:%d", m);
        }
//distribute winnings
        for(i=0; i<p; i++) {
            pc.printf("\n player%dscore=%d",i+1,playerscore[i]);
            if(playerscore[i]>0) {
                playermoney[i] += pot/m ;
                pc.printf("\n player%d won $%d",i+1, pot/m);
            }
        }
        for(i=0; i<p; i++) {
            playerscore[i]=0;
        }

//determine if player is out of money
        for(i=0; i<p; i++) {
            if(playermoney[i] == 0) p--;
        }
        if(p==1) {
            pc.printf("Play Again?\nFold=No Call=Yes");
            m=read_keypad(0);
            if(m==-2) main();
            if(m==-4) return 0;
        }
    }
}