/*
 * Copyright (C) 2013 gsfan, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/* Copyright (C) 2014 Wiznet, MIT License
 *  port to the Wiznet Module WizFi250
 */
/* Copyright (C) 2017 Wiznet, MIT License
 *  port to the Wiznet Module WizFi310
 */

#include "WizFi310Interface.h"
#define var i ;
//DigitalIn PIR(D9);
//DigitalOut myled(LED1);
DigitalOut myled(LED2);

    
WizFi310Interface::WizFi310Interface(PinName tx, PinName rx, PinName cts, PinName rts, PinName reset, PinName alarm, int baud):
    WizFi310(tx, rx, cts, rts, reset, alarm, baud)
{

}

int WizFi310Interface::init(const char *name)
{
	startup();
    return setAddress(name);
}

int WizFi310Interface::init(const char* ip, const char* netmask, const char* gateway, const char* name)
{
    return setAddress(ip, netmask, gateway, name);
}

int WizFi310Interface::connect(Security sec, const char* ssid, const char* phrase, WiFiMode mode)
{
    setSsid(ssid);
    setSec(sec, phrase);

    switch (mode)
    {
    case WM_STATION:
        return join(WizFi310::WM_STATION);
    case WM_AP:
        return join(WizFi310::WM_AP);
    }

    return 0;
}

int WizFi310Interface::disconnect()
{
	return cmdWLEAVE();
}


char* WizFi310Interface::getMACAddress()
{
    return _state.mac;
}

char* WizFi310Interface::getIPAddress()
{
    return _state.ip;
}

char* WizFi310Interface::getGateway()
{
    return _state.gateway;
}

int WizFi310Interface::setAntMode(AntennaMode mode)
{
	return cmdWANT(mode);
}
//int WizFi310Interface::test()
//{
//	return cmdWSTATUS();
//}


int WizFi310Interface::test_ThingSpeak(int data)
{    //Timer timer;
   //  timer.start();
	TCPSocketConnection();
  
    char http_cmd[1000] = "";
   char buffer[2048] = "";
    int i = 0;
    //int PIR_sensor;
 //   int CDS_data = 0;
    //double CDS_vol = 0; 
    
	TCPSocketConnection TCPconnection;


   char *p="api.thingspeak.com";
   int a=TCPconnection.connect(p,80);
  while(1){
        if(a!=0) {
            printf("\r\n could not connect to socket : error = %d\r\n", p);
            
            a = TCPconnection.connect(p, 80);
        } else {
            printf("socket connected\r\n");
                        break;
        }
     }  
     
  printf("\r\n Now Reading the LDR sensor values\n\r");
  printf("===========================================\n\r");
      
      /*while (i < 5) {*/
        	        	
     //   CDS_data = CDS.read()*1000;
        //CDS_vol = CDS.read()*3.3;
        
        //CDS Seneor ADC Low Data
        printf("CDS Data : %3d\r\n",data);
        
        printf("===========================================\n\r");
        wait(2);
            sprintf((char *)http_cmd,"GET http://api.thingspeak.com/update?api_key=N22Y0CKYMCI0SDGD&field2=%d\r\n",data);               
     
     	// sprintf((char *)http_cmd,"GET https://api.thingspeak.com/update?api_key=H1S5TNVE9QZ4V86Q&field1=%d\r\n",CDS_data); 
     	
	if(TCPconnection.send_all(http_cmd, sizeof(http_cmd))!=-1)
            {
                printf("The sent URL is: %s\r\n",http_cmd);
              //  printf("The sent Tweet is: %s",message);
                printf("\r\nMessage sent successfully\r\n\r\n");
            }
            else
            {
                                printf("\r\n Message sending failed\r\n\r\n");
            }
	
	//printf("now Read the PIR sensor values\n\r");
	TCPconnection.send_all(http_cmd, sizeof(http_cmd));
    TCPconnection.receive_all(buffer, sizeof(buffer));
    
	 
	 
	 
	 return 0;
	}
	
	
	
	
	
/*        if(CDS_data < 600){
            myled = 1;
        }
        Status is dark.
       else {
          myled = 0;
      }
        	        	
          PIR_sensor = PIR;
         printf("PIR Value : %d\r\n",PIR_sensor);
       myled =! PIR_sensor;
        wait(0.2f);      
      sprintf((char *)http_cmd,"GET https://api.thingspeak.com/update?api_key=H1S5TNVE9QZ4V86Q&field1=%d\r\n",CDS_data); */      
	
