#include "mbed.h"
#include "EthernetInterface.h"
#include "Adafruit_SSD1306.h"



#if defined(TARGET_WIZWIKI_W7500)||defined(TARGET_WIZWIKI_W7500P)
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x53, 0xAE, 0x90};
#endif
// W7500 onboard LED & Init
DigitalOut rled(LED1,1);
DigitalOut gled(LED2,0);
DigitalOut bled(LED3,1);

// I2C Class
I2C i2c(PA_10,PA_9);

// OLED Class   
Adafruit_SSD1306_I2c gOled(i2c,NC,0x78,64,128);


EthernetInterface eth;

// Declare TCP Connection Class
TCPSocketConnection sock;

DigitalOut myled(D1);



int main() {
   

   
   int phy_link;
    printf("Wait a second...\r\n");

   eth.init(mac_addr);     //Use DHCP

printf("Check Ethernet Link\r\n");
    /*while(1) //Wait link up
    {
        if(eth.link() == true) 
            break;
    }*/
    printf("Link up\r\n");

    eth.connect();
    
      printf("IP Address is %s\r\n\r\n", eth.getIPAddress());
        printf("MASK Address is %s\r\n\r\n", eth.getNetworkMask());
        printf("GATEWAY Address is %s\r\n\r\n", eth.getGateway());
        printf("MAC Address is %s\r\n\r\n", eth.getMACAddress());
        while(1){
        // TCP socket connect to openweather server 
        //TCPSocketConnection sock;
        sock.connect("api.openweathermap.org", 80);
        
        
        // GET method, to request weather forecast  
        char http_cmd[] = "GET /data/2.5/weather?q=Seoul,kr&appid=a0ca47dd7f6066404629b3e1ad728981 HTTP/1.0\n\n";
        
           
        sock.send_all(http_cmd, sizeof(http_cmd)-1);
        
        // get data into buffer
        char buffer[2048];
        int ret;
        while (true) {
            ret = sock.receive(buffer, sizeof(buffer)-1);
            if (ret <= 0)
                break;
            buffer[ret] = '\0';
            printf("Received %d chars from server: %s\n", ret, buffer);     
        }
        printf("\r\n\r\n");
        
        // parsing current date, weather, city, tempurature 
        char *date;
        char *weather;
        char *city;
        char *temper;
        
        char cur_date[17] = {0};
        char weather_con[15] = {0};
        char city_name[10] = {0};
        char temper_data[3] = {0};
    
        int temp;
        int num100, num10, num1;
        
        //parding date
        date = strstr(buffer, "Date");
        for(int x=0;x<17;x++){
            cur_date[x] = date[x+6];
        }
            
        // parsing weather condition
        weather = strstr(buffer, "main");
        for(int i=0; i<15;i++){
            weather_con[i] = weather[i+7];
            if(weather_con[i] == 34){
                weather_con[i] = 0;
                break;
            }
        }
       
       
        
        // parsing city name
        city = strstr(buffer, "name");
        for(int j=0; j<10;j++){
            city_name[j] = city[j+7];
            if(city_name[j] == 34){
                city_name[j] = 0;
                break;
            }
        }
     
        //parsing current tempurature
        temper = strstr(buffer, "temp");
        for(int k=0; k<3;k++){
            temper_data[k] = temper[k+6];
        }
           
        //kelvin to celius converter
        num100 = temper_data[0]- 48;
        num10 = temper_data[1] - 48;
        num1 = temper_data[2]- 48;
        temp = (num100*100 + num10*10 + num1) - 273;
        
        // Debug message
        printf("city name   :  %s\r\n",  city_name);
        printf("weather     :  %s\r\n",  weather_con);
        printf("temperature :  %d\r\n\r\n",  temp);
       
        
        }
        
        
   
}
