#include "mbed.h"
#include "EthernetInterface.h"
#include "Adafruit_SSD1306.h"
#include "HTTPClient.h"


#if defined(TARGET_WIZWIKI_W7500)||defined(TARGET_WIZWIKI_W7500P)
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x53, 0xAE, 0x90};
#endif
// W7500 onboard LED & Init
DigitalOut rled(LED1,1);
DigitalOut gled(LED2,0);
DigitalOut bled(LED3,1);
AnalogIn Sensor(A0);
// I2C Class
I2C i2c(PA_10,PA_9);

// OLED Class   
Adafruit_SSD1306_I2c gOled(i2c,NC,0x78,64,128);
Serial pc(USBTX, USBRX);

EthernetInterface eth;

// Declare TCP Connection Class
TCPSocketConnection sock;

DigitalOut myled(D1);



int main() {
   

   
   int phy_link;
    printf("Wait a second...\r\n");

   eth.init(mac_addr);     //Use DHCP

printf("Check Ethernet Link\r\n");
    /*while(1) //Wait link up
    {
        if(eth.link() == true) 
            break;
    }*/
    printf("Link up\r\n");

    eth.connect();
    
      printf("IP Address is %s\r\n\r\n", eth.getIPAddress());
        printf("MASK Address is %s\r\n\r\n", eth.getNetworkMask());
        printf("GATEWAY Address is %s\r\n\r\n", eth.getGateway());
        printf("MAC Address is %s\r\n\r\n", eth.getMACAddress());
        while(1){
        // TCP socket connect to openweather server 
        //TCPSocketConnection sock;
        char send_data[1024];
        int CDS_data=3000;
        sock.connect("api.thingspeak.com", 80);
        
         sprintf(send_data, "GET http://api.thingspeak.com/update?key=0Q8S3KCULT7GUDVR&field1=%d HTTP/1.0\n\n",CDS_data);
        // GET method, to request weather forecast  
       // char http_cmd[] = "GET /update?api_key=0Q8S3KCULT7GUDVR&field1=2000 HTTP/1.0\n\n";
        
           
        sock.send_all(send_data, sizeof(send_data)-1);
        
        // get data into buffer
        char buffer[2048];
        int ret;
        while (true) {
            ret = sock.receive(buffer, sizeof(buffer)-1);
            if (ret <= 0)
                break;
            buffer[ret] = '\0';
            printf("Received %d chars from server: %s\n", ret, buffer);     
        }
        printf("\r\n\r\n");
      }
}
