#include "mbed.h"
#include "EthernetInterface.h"
#include "FsHandler.h"
#include "HTTPServer.h"
#include "SDFileSystem.h"

#if defined(TARGET_WIZWIKI_W7500)||defined(TARGET_WIZWIKI_W7500P)
    //Choose one of file system.
    SDFileSystem local(SD_MOSI, SD_MISO, SD_CLK, SD_SEL, "local");//PB_3, PB_2, PB_1, PB_0
    //LocalFileSystem local("local");
#endif

#if defined(TARGET_WIZWIKI_W7500)||defined(TARGET_WIZWIKI_W7500P)
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x53, 0xAE, 0x90};
#endif

EthernetInterface eth;

// Declare HTTP Server Class
HTTPServer  svr;

DigitalOut myled(D1);

// Set Server Network
char ip_addr[] = "172.16.73.112";
char subnet_mask[] = "255.255.255.0";
char gateway_addr[] = "172.16.73.254";

int main() {
   
   //   HTTPFsRequestHandler::mount_eth(&eth);
    HTTPFsRequestHandler::mount("/local/", "/");
    svr.addHandler<HTTPFsRequestHandler>("/");
   
   #if defined(TARGET_WIZWIKI_W7500)||defined(TARGET_WIZWIKI_W7500P)
    
    #ifdef DHCP
        eth.init(mac_addr); //Use DHCP
    #else
        eth.init(mac_addr, ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
    #endif
    
#else

    #ifdef DHCP
        eth.init(); //Use DHCP
    #else
        eth.init(ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
    #endif

#endif

printf("Check Ethernet Link\r\n");
    /*while(1) //Wait link up
    {
        if(eth.link() == true) 
            break;
    }*/
    printf("Link up\r\n");

    eth.connect();
    printf("Server IP Address is %s\r\n", eth.getIPAddress());
      if (!svr.start(80, &eth)) {

        error("Server not starting !");
        exit(0);
    }

    while(1) {
        svr.poll();
    }
}
