//Test of cheap 13.56 Mhz RFID-RC522 module from eBay
//This code is based on Martin Olejar's MFRC522 library. Minimal changes
//Adapted for Nucleo STM32 F401RE. Should work on other Nucleos too

//----------------------------------------

#include "mbed.h"
#include "DHT.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include <sstream>
#include <string>
#define ECHO_SERVER_PORT   7

Serial out(USBTX,USBRX);
int arrivedcount = 0;

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
}

void baud(int baudrate)
{
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}


    char* store_buf;
    unsigned long lastConnectionTime = 0; 
  const unsigned long postingInterval = 20L * 1000L;
  
  
int main(void)
{
    DHT sensor(D4, DHT11);
    printf("starting...\n");

    MQTTEthernet ipstack = MQTTEthernet();
  //printf("setting up mqtt ethernet");

    while (true) {
              if(store_buf[0]=='\0') {
            MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);

            char* hostname = "mqtt.thingspeak.com";
            int port = 1883;
            
            
  
            int rc = ipstack.connect(hostname, port);

            out.printf("rc from TCP connect is %d\n", rc);

            if (rc != 0)
                out.printf("rc from TCP connect is %d\n", rc);

            char MQTTClientID[30];

            MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
            data.MQTTVersion = 3;
            sprintf(MQTTClientID,"WIZwikiW7500mqttclient%d",rand()%1000);
            data.clientID.cstring = MQTTClientID;
             data.username.cstring = "tsmqtttuser";
            data.password.cstring = "tsmqtttpasswrd"; 
            
            data.writeapikey.cstring = "tsmqtttpasswrd"; 
            data.channelid.cstring = "tsmqtttpasswrd"; 



            if ((rc = client.connect(data)) != 0)
                printf("rc from MQTT connect is %d\n", rc);

            MQTT::Message message;

    char buf[100];
    int error = 0;
    float hum = 0.0f, temp = 0.0f;
    char i = 0;
    while (true)
    {
        if(i > 100) i = 0;
        error = sensor.readData();
        if (0 == error) {
            hum = sensor.ReadHumidity();
            temp = sensor.ReadTemperature(CELCIUS);
                         }
        message.qos = MQTT::QOS0;
        message.retained = false;
        message.dup = false;
        
 f (millis() - lastConnectionTime > postingInterval) 
  {
        
        
        
        sprintf(buf, "%3.1f", hum);
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("/wiznet/humidity17",message);
        printf("publish humidity data %s\r\n",(char*)message.payload);
        
        sprintf(buf, "%3.1f", temp);
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("/wiznet/temperature17", message);
        printf("publish temperature data %s\r\n",(char*)message.payload);
        
        
  lastConnectionTime = millis();    
               /* 
if (millis() - lastConnectionTime > postingInterval) 
  {
   
  // do publish operation
 
  
   Use this function  to publish to a single field directly.  
   
  void mqttpublish() {
  
  float t = dht.readTemperature(true); // Read temperature from DHT sensor.

  String data = String(t, DEC);
  int length = data.length();
  char msgBuffer[length];
  data.toCharArray(msgBuffer,length+1);
  printf(msgBuffer);
  
  // Create a topic string and publish data to ThingSpeak channel feed. 
  String topicString ="channels/" + String( channelID ) + "/publish/"+String(writeAPIKey);
  length=topicString.length();
  char topicBuffer[length];
  topicString.toCharArray(topicBuffer,length+1);
 
  mqttClient.publish( topicBuffer, msgBuffer );

  lastConnectionTime = millis();
}
  
  }
  
  */
                                 
                wait_ms(3000);
                          
       }
            }

    }
}