#include "mbed.h"
#include "Matrix.h"


#define DEBUG__NO_DRIFT_CORRECTION true

//Change this parameter if you wanna use another gyroscope. 
//by default it is ITG3200 gain.
#define GYRO_SCALED_RAD(x) (x * TO_RAD(GYRO_GAIN)) // Calculate the scaled gyro readings in radians per second
#define GYRO_GAIN (0.06956521739130434782608695652174)

// DCM parameters
#define Kp_ROLLPITCH 0.02f
#define Ki_ROLLPITCH 0.00002f
#define Kp_YAW 1.2f
#define Ki_YAW 0.00002f

#define GRAVITY 256.0f // "1G reference" used for DCM filter and accelerometer calibration
#define TO_RAD(x) (x * 0.01745329252)  // *pi/180
#define TO_DEG(x) (x * 57.2957795131)  // *180/pi

#define MAGN_X_MAX 465
#define MAGN_Y_MAX 475
#define MAGN_Z_MAX 600

#define MAGN_X_MIN -561
#define MAGN_Y_MIN -547
#define MAGN_Z_MIN -379

#define MAGN_X_OFFSET ((MAGN_X_MIN + MAGN_X_MAX) / 2.0f)
#define MAGN_Y_OFFSET ((MAGN_Y_MIN + MAGN_Y_MAX) / 2.0f)
#define MAGN_Z_OFFSET ((MAGN_Z_MIN + MAGN_Z_MAX) / 2.0f)

#define MAGN_X_SCALE (100.0f / (MAGN_X_MAX - MAGN_X_OFFSET))
#define MAGN_Y_SCALE (100.0f / (MAGN_Y_MAX - MAGN_Y_OFFSET))
#define MAGN_Z_SCALE (100.0f / (MAGN_Z_MAX - MAGN_Z_OFFSET))

#define ACCEL_X_MIN ((float) -4096)
#define ACCEL_X_MAX ((float) 4096)

#define ACCEL_Y_MIN ((float) -4096)//267
#define ACCEL_Y_MAX ((float) 4096)

#define ACCEL_Z_MIN ((float) -4096)
#define ACCEL_Z_MAX ((float) 4096)

#define GYRO_BIAS_X 9.65       
#define GYRO_BIAS_Y -5.05
#define GYRO_BIAS_Z -8.37


#define ACCEL_X_OFFSET ((ACCEL_X_MIN + ACCEL_X_MAX) / 2.0f)
#define ACCEL_Y_OFFSET ((ACCEL_Y_MIN + ACCEL_Y_MAX) / 2.0f)
#define ACCEL_Z_OFFSET ((ACCEL_Z_MIN + ACCEL_Z_MAX) / 2.0f)
#define ACCEL_X_SCALE (GRAVITY / (ACCEL_X_MAX - ACCEL_X_OFFSET))
#define ACCEL_Y_SCALE (GRAVITY / (ACCEL_Y_MAX - ACCEL_Y_OFFSET))
#define ACCEL_Z_SCALE (GRAVITY / (ACCEL_Z_MAX - ACCEL_Z_OFFSET))

class DCM
{
public:
    DCM(float dt);    
    void UpdateFilter();    
    void FilterInit(int rawAccX, int rawAccY, int rawAccZ, int rawGyroX, int rawGyroY, int rawGyroZ, int rawMagX, int rawMagY, int rawMagZ); 
    float getYaw();
    float getPitch();
    float getRoll();
    void setAccelRawX(int accelRawX);
    void setAccelRawY(int accelRawY);
    void setAccelRawZ(int accelRawZ);
    void setGyroRawX(int gyroRawX);
    void setGyroRawY(int gyroRawY);
    void setGyroRawZ(int gyroRawZ);
    void setMagnetRawX(int magnetRawX);
    void setMagnetRawY(int magnetRawY);
    void setMagnetRawZ(int magnetRawZ);
    float getTestVariable();
      
private:

    void reset_sensor_fusion();
    void init_rotation_matrix(float m[3][3], float yaw, float pitch, float roll);
    void ReadMagnetometer();
    void ReadAccelerometer();
    void ReadGyroscope();    
    float constrain(float in, float min, float max);
    void Compass_Heading();
    void Normalize(void);
    void Drift_correction(void);
    void Matrix_update(void);
    void Euler_angles(void);
    void Sensors();   
    

    // Sensor variables
    float accel[3];  // Actually stores the NEGATED acceleration (equals gravity, if board not moving).
    int accelRaw[3];

    float magnet[3];
    int magnetRaw[3];

    int gyro[3];
    int gyroRaw[3];

    int gyro_num_samples;

    // DCM variables
    float MAG_Heading;
    float Accel_Vector[3];//= {0, 0, 0}; // Store the acceleration in a vector
    float Gyro_Vector[3];//= {0, 0, 0}; // Store the gyros turn rate in a vector
    float Omega_Vector[3];//= {0, 0, 0}; // Corrected Gyro_Vector data
    float Omega_P[3];//= {0, 0, 0}; // Omega Proportional correction
    float Omega_I[3];//= {0, 0, 0}; // Omega Integrator
    float Omega[3];//= {0, 0, 0};
    float errorRollPitch[3];// = {0, 0, 0};
    float errorYaw[3];// = {0, 0, 0};
    float DCM_Matrix[3][3];// = {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}};
    float Update_Matrix[3][3];// = {{0, 1, 2}, {3, 4, 5}, {6, 7, 8}};
    float Temporary_Matrix[3][3];// = {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}};

    // Euler angles
    float yaw;
    float pitch;
    float roll;

    float G_Dt; // Integration time for DCM algorithm

    int rawMagnet[3];
    int gyroBias[3];
};
