#ifndef WO_H
#define WO_H
 
#include "mbed.h"
 
/** wo class.
 *  Collection of functions to control the leds on your board.
 *
 *  To use the library, its header file needs to be included and an object of the wo class created.
 *
 *  Example:
 *  @code
 *  #include "mbed.h"
 *  #include "wo.h"
 *
 *  wo app;
 *  ...
 *  @endcode
 */
 
class wo
{
    public:
    /// Defult consturctor which is automatically called when an object is declared. 
    wo();
    ///turns on led 0.
    void led0_on();
    ///turns off led 0.
    void led0_off();
    ///toggle(invert) the state of led 0.
    void led0_toggle();
    /** blink led 0 once
         *
         *
         * @param sec the time(in seconds) the led should be turnd on.
         */
    void led0_blink(float sec);
    ///turns on led 1.
    void led1_on();
     ///turns off led 1.
    void led1_off();
     ///toggle(invert) the state of led 1
    void led1_toggle();
    /** blink led 0 once
         *
         *
         * @param sec the time(in seconds) the led should be turnd on.
         */
    void led1_blink(float sec);
    
    private:
    DigitalOut led0;
    DigitalOut led1;
    
};
 
 
 
#endif