/**
 *     ____             _________                __                _
 *    / __ \___  ____ _/ /_  __(_)___ ___  ___  / /   ____  ____ _(_)____
 *   / /_/ / _ \/ __ `/ / / / / / __ `__ \/ _ \/ /   / __ \/ __ `/ / ___/
 *  / _, _/  __/ /_/ / / / / / / / / / / /  __/ /___/ /_/ / /_/ / / /__
 * /_/ |_|\___/\__,_/_/ /_/ /_/_/ /_/ /_/\___/_____/\____/\__, /_/\___/
 *                                                       /____/
 *
 *                 SharkSSL Embedded SSL/TLS Stack
 ****************************************************************************
 *   PROGRAM MODULE
 *
 *   $Id$
 *
 *   COPYRIGHT:  Real Time Logic LLC, 2016
 *
 *   This software is copyrighted by and is the sole property of Real
 *   Time Logic LLC.  All rights, title, ownership, or other interests in
 *   the software remain the property of Real Time Logic LLC.  This
 *   software may only be used in accordance with the terms and
 *   conditions stipulated in the corresponding license agreement under
 *   which the software has been supplied.  Any unauthorized use,
 *   duplication, transmission, distribution, or disclosure of this
 *   software is expressly forbidden.
 *
 *   This Copyright notice may not be removed or modified without prior
 *   written consent of Real Time Logic LLC.
 *
 *   Real Time Logic LLC. reserves the right to modify this software
 *   without notice.
 *
 *               http://www.realtimelogic.com
 *               http://www.sharkssl.com
 ****************************************************************************
 *
 */
#ifndef _SharkSsl_TargConfig_h
#define _SharkSsl_TargConfig_h

#include <cmsis_os.h>
#include <time.h>


#ifndef NDEBUG
#define baAssert(x)        ((x) ? 0 : sharkAssert(__FILE__, __LINE__))
#else
#define baAssert(x)
#endif

#ifdef __cplusplus
extern "C" {
#endif
int sharkAssert(const char* file, int line);
#ifdef __cplusplus
}
#endif

#ifdef _SHARKSSL_C_
const char* assert_file;
int assert_line;
int sharkAssert(const char* file, int line)
{
   assert_file = file;
   assert_line = line;
   for(;;);
}
#endif



/* The following is not required by SharkSSL, but is used by some of
   the examples.
*/

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/**
 *  baMalloc  should return 32-bit aligned addresses when succesful,
 *                          (void*)0 when not succesful.
 *  baRealloc should return 32-bit aligned addresses when succesful,
 *                          (void*)0 when not succesful or NOT available.
 */

#ifdef UMM_MALLOC
#include "../../../examples/malloc/umm_malloc.h"
#define baMalloc(s)        umm_malloc(s)
#define baRealloc(m, s)    umm_realloc(m, s)
#define baFree(m)          umm_free(m)
#else
#include <stdlib.h>
#define baMalloc(s)        malloc(s) /* should return 32-bit aligned address */
#define baRealloc(m, s)    realloc(m, s)  /* as above */
#define baFree(m)          free(m)
#endif

/* Some mbed releases use conflicting types. Undo the two macro
   definitions commented out below if you get 'undefined' compile
   errors.
*/
/* #ifndef __MBED__ */

#ifndef INTEGRAL_TYPES
#define INTEGRAL_TYPES
#if (__STDC_VERSION__ >= 199901L) || defined( __GNUC__)
#include <stdint.h>
typedef uint8_t            U8;
typedef int8_t             S8;
typedef uint16_t           U16;
typedef int16_t            S16;
typedef uint32_t           U32;
typedef int32_t            S32;
typedef uint64_t           U64;
typedef int64_t            S64;
#else
typedef unsigned char      U8;
typedef signed   char      S8;
typedef unsigned short     U16;
typedef signed   short     S16;
typedef unsigned int       U32;
typedef signed   int       S32;
typedef unsigned long long U64;
typedef signed   long long S64;
#endif
#endif

/* #endif */ /* __MBED__ */

typedef U8 BaBool;

#ifdef EXT_SHARK_LIB
U32 baGetUnixTime(void);
char *sharkStrchr(const char *s, int c);
char *sharkStrstr(const char *haystack, const char *needle);
#else
#define baGetUnixTime()    time(0)
#endif

typedef struct ThreadMutexBase
{
   osMutexId sharkMutex;
} ThreadMutexBase;

void ThreadMutex_destructor(ThreadMutexBase* o);
void ThreadMutex_set(ThreadMutexBase* o);
void ThreadMutex_release(ThreadMutexBase* o);
void ThreadMutex_constructor(ThreadMutexBase* o);

#ifdef _SHARKSSL_C_
osMutexDef(sharkMutexDef);
void ThreadMutex_destructor(ThreadMutexBase* o)
{
   osMutexDelete(o->sharkMutex);
}
void ThreadMutex_set(ThreadMutexBase* o)
{
   osMutexWait(o->sharkMutex, osWaitForever);
}
void ThreadMutex_release(ThreadMutexBase* o)
{
   osMutexRelease(o->sharkMutex);
}
void ThreadMutex_constructor(ThreadMutexBase* o)
{
   o->sharkMutex=osMutexCreate(osMutex(sharkMutexDef));
}
#endif


#endif  /* _SharkSsl_TargConfig_h */
