/*
 *     ____             _________                __                _
 *    / __ \___  ____ _/ /_  __(_)___ ___  ___  / /   ____  ____ _(_)____
 *   / /_/ / _ \/ __ `/ / / / / / __ `__ \/ _ \/ /   / __ \/ __ `/ / ___/
 *  / _, _/  __/ /_/ / / / / / / / / / / /  __/ /___/ /_/ / /_/ / / /__
 * /_/ |_|\___/\__,_/_/ /_/ /_/_/ /_/ /_/\___/_____/\____/\__, /_/\___/
 *                                                       /____/
 *
 *                 SharkSSL Embedded SSL/TLS Stack
 ****************************************************************************
 *   PROGRAM MODULE
 *
 *   $Id: SharkSslEx.h 3670 2015-03-28 21:25:15Z gianluca $
 *
 *   COPYRIGHT:  Real Time Logic LLC, 2013
 *
 *   This software is copyrighted by and is the sole property of Real
 *   Time Logic LLC.  All rights, title, ownership, or other interests in
 *   the software remain the property of Real Time Logic LLC.  This
 *   software may only be used in accordance with the terms and
 *   conditions stipulated in the corresponding license agreement under
 *   which the software has been supplied.  Any unauthorized use,
 *   duplication, transmission, distribution, or disclosure of this
 *   software is expressly forbidden.
 *
 *   This Copyright notice may not be removed or modified without prior
 *   written consent of Real Time Logic LLC.
 *
 *   Real Time Logic LLC. reserves the right to modify this software
 *   without notice.
 *
 *               http://www.realtimelogic.com
 *               http://www.sharkssl.com
 ****************************************************************************
 *
 */
#ifndef _SharkSslEx_h
#define _SharkSslEx_h

#include "SharkSSL.h"


/** Case insensitive string compare.
 */
int sharkStrCaseCmp(const char *a, const char *b, int len);

/** @addtogroup SharkSslInfoAndCodes
@{
*/

/** #SharkSslCon_trusted return values */ 
typedef enum
{
   /** Not a secure connection (SSL handshake not completed).
    */
   SharkSslConTrust_NotSSL=10,

   /** The SSL certificate is not trusted and the subject's common
       name does not matches the host name of the URL.
   */
   SharkSslConTrust_None,

   /** Domain mismatch: The SSL certificate is trusted but the
       subject's common name does not matches the host name of the URL.
   */
   SharkSslConTrust_Cert,

   /** The subject's common name matches the host name of the URL, but
       the certificate is not trusted. This is typical for expired
       certificates.
   */
   SharkSslConTrust_Cn,

   /** The peer's SSL certificate is trusted and the
       subject's common name matches the host name of the URL.
   */
   SharkSslConTrust_CertCn
} SharkSslConTrust;

/** @} */ /* end group SharkSslInfoAndCodes */ 

/** @addtogroup SharkSslApi
@{
*/

/** Returns the peer's "trust" status and certificate.

    \param o the SharkSslCon object

    \param name is the domain name (common name)

    \param cPtr is an optional pointer that will be set to the
    connections's SharkSslCertInfo object, if provided.

    \returns SharkSslConTrust

    \sa SharkSslConTrust and SharkSslCon_trustedCA
*/
SHARKSSL_API SharkSslConTrust SharkSslCon_trusted(
   SharkSslCon* o, const char* name, SharkSslCertInfo** cPtr);

/** @} */ /* end group SharkSslApi */ 

#endif
