/* Starburst - display driver for 14 segment starburst display
 *
 * Copyright (c) 2011 Wim Huiskamp
 *
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * version 0.2 Initial Release
*/
#ifndef _STARBURST_H
#define _STARBURST_H

//Useful stuff to simplify porting of some third party software
 #include <stdarg.h>
//#include <string.h>


/*****************************************************************************/
/*********************  DEFINITIONS FOR STARBURST  ***************************/
/*****************************************************************************/

// Definitions
#define STAR_NR_DIGITS 4  
#define STAR_CHR_MIN     32 
#define STAR_CHR_MAX    127 
#define STAR_NR_CHARS  (STAR_CHR_MAX - STAR_CHR_MIN + 1)

// Masks
//#define CHR_MSK   0x3F 
#define SYM_MSK   0xC0 

#define D3_MSK    0x80  
#define D3_ON     0x80  
#define D3_OFF    0x00  
#define D3_IDX       0  

#define DP_MSK    0x40  
#define DP_ON     0x40  
#define DP_OFF    0x00  
#define DP_IDX       1  

#define D1_MSK    0xC0  
#define D1_RED    0x80  
#define D1_GRN    0x40  
#define D1_YEL    0xC0  
#define D1_OFF    0x00  
#define D1_IDX       2 

// Enums
enum BiLED {BI_OFF, BI_RED, BI_GRN, BI_YEL};   // Bicolour LED states


/** Create a starburst object connected to the proper SPI pins
 *
 * @param  Pinname mosi, miso, sck, ce to connect to 
 * @brief 
*/
class Starburst {

public:
  Starburst(SPI &spi, PinName CE, PinName nOE);
  void set_dp(bool dp);    
  void set_led(bool led);
  void set_bi_led(BiLED bi_led);
  void putc(int location, char byte);
  void putc(char disp_char);
  void printf (char * format, ...);
  void scroll_printf (char * format, ...);
   
  void locate(uint8_t column);
  void cls(void);
//  void set_char_flash_state(bool flash_state, uint8_t char_pos);
//  void set_all_flash_states(uint8_t flash_bits);
//  void set_brightness(uint8_t brightness);  
  void set_blink_mode(bool enable);  
//  void set_flash_mode(bool enable);          
  void set_scroll_mode(bool enable);  

          
protected:
  SPI &_spi;
  DigitalOut _ShiftLatch;
  DigitalOut _nOE;
    
  Ticker _mpx, _blnk, _scrl;
//    int _row;
  int _column; 
  char _digit_segments[STAR_NR_DIGITS][2];    

  char _scroll_display_string[64];
  int  _scroll_string_len;  
  int  _scroll_ptr;  
  bool _scroll;      

  bool _blink, _blinkstate;  
//  bool _flash;        
  
  void _init();
  void _mpx_digits();
  void _mpx_start();
  void _blink_tick();   
  void _blink_start();   
  void _scroll_tick();       
  void _scroll_start();         
};


#endif
/*****************************************************************************/
/******************************  END OF FILE  ********************************/
/*****************************************************************************/
