#include "mbed.h"
#include "starburst.h"

#define MOSI p5
#define MISO p6
#define SCK  p7
#define CE   p8
#define nOE  p21

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut heartbeatLED(LED4);

SPI spi(MOSI, MISO, SCK);           // mosi, miso, sclk
Starburst starburst(spi, CE, nOE);  // Multiplexed Starburst Display, SPI controlled

Serial pc(USBTX, USBRX); // tx, rx

// Variables for Heartbeat and Status monitoring
Ticker heartbeat;
bool heartbeatflag=false;

void show_menu() {
    pc.printf("0: Exit\n\r");
    pc.printf("1: Show Menu\n\r");    
    pc.printf("2: Send TEST\n\r"); 
    pc.printf("3: Send 1234\n\r");                
    pc.printf("4: Blink On\n\r");    
    pc.printf("5: Blink Off\n\r");        
    pc.printf("6: Scroll On\n\r");                    
    pc.printf("7: Scroll Off\n\r");                        
//    pc.printf("A: sendMessage\n\r");                
//    pc.printf("B: parseLFRNG\n\r");                    
//    pc.printf("P: parseMessage\n\r");                        
    pc.printf("\n\r");                
}




void show_LEDS () {
  static int state = 0;
 
  switch (state) {
   case 0: 
        myled1 = 1;
        myled2 = 0;
        myled3 = 0;
        state = 1;
        break;
   case 1: 
        myled1 = 0;
        myled2 = 1;
        myled3 = 0;
        state = 2;
        break;
   case 2:     
        myled1 = 0;
        myled2 = 0;
        myled3 = 1;
        state = 0;
        break;
   }
}




// Heartbeat monitor
void pulse() {
  heartbeatLED = !heartbeatLED;
  
  starburst.set_led(heartbeatLED); 

  if (heartbeatLED)
    starburst.set_bi_led(BI_RED);
  else
    starburst.set_bi_led(BI_GRN);
//    starburst.set_bi_led(BI_YEL);

}

void heartbeat_start() {
  heartbeat.attach(&pulse, 0.5);
  heartbeatflag = true;
}

void heartbeat_stop() {
  heartbeat.detach();
  heartbeatflag = false;
}



int main() {
  bool running=true;
  char command;
  int count = 0;
  
    pc.printf("Hello World!\n\r");

    heartbeat_start();

    show_LEDS();

    show_menu();
    
  
    starburst.locate(0);                                                                               
    starburst.printf("BILL"); 
    
//    starburst.scroll_printf ("Hello World. The correct answer is %d ", 123456);       
    starburst.scroll_printf ("Hello World ");       
             
    while(running) {
          
      // pc.printf("_str_len = %d, _scroll_ptr= %d \n\r", starburst._scroll_string_len, starburst._scroll_ptr);           
    
       if(pc.readable()) {
         command = pc.getc();       
         pc.printf("command= %c \n\r", command);         
         show_LEDS();         

         switch (command) {
          case '0' :
                     pc.printf("Done\n\r");                    
                     running = false;  
                     break;
          
          case '1' :
                     show_menu();
                     break;
                    
          case '2' :
                     pc.printf("TEST\n\r");          
                     
                     starburst.locate(0);                                                                               
                     starburst.printf("TEST");                                                                               
                     break;
          
          case '3' :
                     pc.printf("1234\n\r");          

                     starburst.locate(0);                                                                                                                                                                      
                     starburst.printf("%4d", 1234);                                              
                     break;
          
          case '4' :
                     pc.printf("Blink On\n\r");                    

                     starburst.set_blink_mode(true);          
                     break;

          case '5' :
                     pc.printf("Blink Off\n\r");                    

                     starburst.set_blink_mode(false);                    
                     break;

          case '6' :
                     pc.printf("Scroll On\n\r");                    

                     starburst.set_scroll_mode(true);                      
                     break;

          case '7' :
                     pc.printf("Scroll Off\n\r");                    

                     starburst.set_scroll_mode(false);                       
                     break;


          case 'A' :
                     break;

          case 'B' :
                   
                     break;

          case 'P' :
          
                    break;
                              
        } //switch
      }//if
    }//while

    pc.printf("Bye World!\n\r");                       
}//main
