/* mbed Seeed 128x64 OLED Test
 * http://www.seeedstudio.com/depot/grove-oled-display-12864-p-781.html?cPath=163_167
 *
 * Copyright (c) 2012 Wim Huiskamp
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * version 0.2 Initial Release
 * version 0.3 2017 Fixed non-copyable issue (Thx kenjiArai) 
 */
#include "mbed.h"
#include "mbed_logo.h"
#include "SSD1308.h"

#if defined(TARGET_LPC1768)
//Pin Defines for I2C Bus
//#define D_SDA                  p9
//#define D_SCL                  p10
#define D_SDA                  p28
#define D_SCL                  p27
#endif

#if defined(TARGET_NUCLEO_F401RE)
#define D_SDA                  PB_9
#define D_SCL                  PB_8
#endif

#if defined(TARGET_KL25Z)
// I2C for KL25Z
#define D_SCL                  PTE1
#define D_SDA                  PTE0
#endif

I2C i2c(D_SDA, D_SCL);

//Host PC Baudrate (Virtual Com Port on USB)
#define D_BAUDRATE            9600
//#define D_BAUDRATE            57600

// mbed Interface Hardware definitions
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut heartbeatLED(LED4);

// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx

// Instantiate OLED
SSD1308 oled = SSD1308(&i2c, SSD1308_SA0);

void show_menu() {
    pc.printf("0: Exit\r");
    pc.printf("1: Show Menu\r");    
    pc.printf("2: Send Message\r"); 
    pc.printf("3: Fill Display\r");
    pc.printf("4: Display cleared\r");        
    pc.printf("5: Display off\r");            
    pc.printf("6: Display on\r");                
    pc.printf("7: Display Invert\r");                    
    pc.printf("8: Display Normal\r");                
    pc.printf("9: Display Bitmap\r");                    
    pc.printf("A: Brightness Ramp\r");                    
    pc.printf("B: Send Inverted Message\r");  
    pc.printf("C: Flip and Mirror\r");                      
    pc.printf("D: Blink\r");   
    pc.printf("E: Big Chars\r");                       
    pc.printf("F: Progress Scale\r");    
    pc.printf("G: Scroll\r");        
    pc.printf("H: Hor Scroll\r");    
    pc.printf("V: Ver and Hor Scroll\r");    
//    pc.printf("\n\r");                
     
}


void oled_Test() {
  pc.printf("OLED test start\r"); 

#if defined(TARGET_LPC1768)
  pc.printf("\r\nHello World from LPC1768\r\n");
#endif  
#if defined(TARGET_KL25Z)
  pc.printf("\r\nHello World from KL25Z\r\n");
#endif  
#if defined(TARGET_LPC812)
  pc.printf("\r\nHello World from LPC812\r\n");
#endif
#if defined(TARGET_LPC1549)
  pc.printf("Hello World from LPC1549\n\r");    
#endif  
#if defined(TARGET_NUCLEO_F401RE)
  pc.printf("Hello World from ST32F401RE\n\r");    
#endif  
#if defined(TARGET_NUCLEO_F103RB)
  pc.printf("Hello World from ST32F103RB\n\r");    
#endif  
 
  
//  oled.writeString(0, 0, 13, "Hello World !");
  oled.writeString(0, 0, "Hello World !");  
  pc.printf("Printed something\r");    
  wait(3);
    
//  oled.writeString(1, 0, 8, "baz quux");
  oled.writeString(1, 0, "baz quux");  
  pc.printf("Printed something\r");  
  wait(3);
    
//  oled.writeString(4, 0, 272, "a long, rather lengthy, extended string passage thing, eh, that just goes on, and on, and on, and on, and on, and on, and on, yes, further, continuing, extending, expanding beyond all reason or sanity!!!!! and yet, there's more!  so much more!  for ever and ever, oh yeah");
//  pc.printf("Printed something\r");
//  wait(3);

  oled.fillDisplay(0xAA);
  pc.printf("Display filled\r");      
  wait(3);

  oled.setDisplayOff();
  pc.printf("Display off\r");          
  wait(0.5);

  oled.setDisplayOn();
  pc.printf("Display on\r");          
  wait(0.5);  

  oled.clearDisplay();
  pc.printf("Display cleared\r");        
  wait(0.5);

//  oled.writeString(0, 0, 11, "Bye World !");
  oled.writeString(0, 0, "Bye World !");  
  pc.printf("Printed something\r");    
  wait(3);

  pc.printf("OLED test done\r");  
}

// Variables for Heartbeat and Status monitoring
Ticker heartbeat;
bool heartbeatflag=false;

// Local functions
void clear_screen() {
//ANSI Terminal Commands
    pc.printf("\x1B[2J");
    pc.printf("\x1B[H");
}


void init_interfaces() {
    // Init Host PC communication, default is 9600
    pc.baud(D_BAUDRATE);
      
    // Init I/F hardware
//    i2c.frequency(100000);
    i2c.frequency(400000); // according to the spec the max bitrate for the SSD1308 is 400 kbit/s
}
      

// Heartbeat monitor
void pulse() {
  heartbeatLED = !heartbeatLED;
}

void heartbeat_start() {
  heartbeat.attach(&pulse, 0.5);
}

void heartbeat_stop() {
  heartbeat.detach();
}


int main() {
    bool running=true;
    bool left = true;
    bool down = true;
   
    char command;

    init_interfaces();
    
    heartbeat_start();
          
    clear_screen(); 
  
    pc.printf("Hello World!\r");

#if(0)
// Quick test
    oled_Test(); 
    
    while(1) {
        myled1 = 1;
        wait(0.2);       
         
        myled1 = 0;
        wait(0.2);     
        pc.printf("*");
    }
#else    
// Interactive Test
    show_menu();
      
    while(running) {
          
       if(pc.readable()) {
         command = pc.getc();       
         //pc.printf("command= %c \n\r", command);         
         pc.printf("\r");         
         
         switch (command) {
          case '0' :
                     pc.printf("Done\r");                    
                     running = false;  
                     break;
          
          case '1' :
                     show_menu();
                     break;
                    
          case '2' :
                     pc.printf("Hello World!\r");  
                     oled.writeString(0, 0, "Hello World !");   
                     break;
          
          case '3' :
                     pc.printf("Fill part of Display 0xA5\r");            
//                     oled.fillDisplay(0xA5);
                     
                     oled.fillDisplay(0xA5, 2, 5, 0, 63);                     
                     break;

          case '4' :
                     pc.printf("Display cleared\r");                  
                     oled.clearDisplay();
                     break;

          case '5' :
                     pc.printf("Display off\r");                
                     oled.setDisplayOff();                  
                     break;
          case '6' :
                     pc.printf("Display on\r");          
                     oled.setDisplayOn();                     
                     break;

          case '7' :
                     pc.printf("Display Invert\r");          
                     oled.setDisplayInverse();
                     break;

          case '8' :
                     pc.printf("Display Normal\r");
                     oled.setDisplayNormal();                                         
                     break;

          case '9' :
                     pc.printf("Display bitmap\r");          
                     oled.writeBitmap((uint8_t*) mbed_logo);
                                        
                     break;

          case 'A' :
                     pc.printf("Brightness Ramp Down\r");          
                     for (int contrast=0x7F; contrast >= 0x10; contrast--) { 
                        oled.setContrastControl(contrast);
                        wait(0.05);
                     }                   
                     
                     wait(1);

                     pc.printf("Brightness Ramp Up\r");          
                     for (int contrast=0x10; contrast <= 0x7F; contrast++) { 
                        oled.setContrastControl(contrast);
                        wait(0.05);
                     }                   

                     pc.printf("Brightness Ramp Done\r");                              
                     
                     break;

          case 'B' :
                     pc.printf("Send Inverted Message\r");
                     oled.setInverted(true);                     
//                     oled.writeString(0, 0, 13, "Hello World !");                                                 
                     oled.writeString(0, 0, "Hello World !");                                                                      
                     oled.setInverted(false);                                          

                     oled.printf(" Result is %d", 12345);                                                 

                     break;
                     
          case 'C' :
                     pc.printf("Flip and Mirror (Rewrite display to show horizontal effect)\r");
                     left = !left;
                     down = !down;
                     oled.setDisplayFlip(left, down);                     
                     break;
          
          case 'D' :                     
                     pc.printf("D: Blink and Fade (not supported)\r");

//                     oled.setDisplayBlink(true);
//                     wait(4);
//                     oled.setDisplayBlink(false);

                     oled.setDisplayFade(true);
                     wait(4);
                     oled.setDisplayFade(false);
                     
                     pc.printf("D: Blink done\r");
                     break;                       
                     
          case 'E' :                     
                     pc.printf("E: Big Chars\r");
                     
                     oled.writeBigChar(0,  0, '+');
                     oled.writeBigChar(0, 16, '7');
                     oled.writeBigChar(0, 32, '8');
                     oled.writeBigChar(0, 48, '9');                                          
                     
                     pc.printf("E: Big Chars done\r");
                     break;   
                     
          case 'F' :                     
                     pc.printf("F: Progress Scale\r");

                     for (int percentage=0; percentage <= 100; percentage++) { 
                       oled.writeProgressBar(2, 0, percentage); 
                       oled.printf(" %3d%%", percentage);                                           
                       
                       oled.writeProgressBar(4, 0, 100 - percentage);                        
                       oled.printf(" %3d%%", 100 - percentage);                                                                  

                       oled.writeLevelBar(6, 0, percentage);                        
                       oled.printf(" %3dmV", percentage);                                                                  
                       
                       wait(0.05);
                     }                   
                    
                     pc.printf("F: Progress Scale done\r");                   
                     break;   
                     
          case 'G' :                     
                     pc.printf("G: Scroll\r");

                     for (int line=0; line < ROWS; line++) { 
                       oled.setDisplayStartLine(line);                        
                       wait(0.05);
                     }                   
                       
                     oled.setDisplayStartLine(0);                                            
                     
                     pc.printf("G: Scroll done\r");                   
                     break;   
                     

          case 'H' :                     
//                     pc.printf("H: Hor Scroll\r");
                     pc.printf("H: Hor Scroll (Page 0-3)\r");
//                     oled.setContinuousHorizontalScroll(true, PAGE0, PAGE7, SCROLL_INTERVAL_25_FRAMES);                     
                     oled.setContinuousHorizontalScroll(true, PAGE0, PAGE3, SCROLL_INTERVAL_25_FRAMES);                                          
                     oled.setDisplayScroll(true);
                       
                     wait(5);                     
                     
                     oled.setDisplayScroll(false);
                     
                     pc.printf("H: Hor Scroll done\r");                   
                     break;   


          case 'V' :                     
                     pc.printf("V: Ver and Hor Scroll (Page 0-7)\r");


                     oled.setContinuousVerticalAndHorizontalScroll(true, PAGE0, PAGE7, 0x01, SCROLL_INTERVAL_25_FRAMES);
                     oled.setVerticalScrollArea(20, 20); 

                     oled.setDisplayScroll(true);

                       
                     wait(5);                     
                     
                     oled.setDisplayScroll(false);
                     
                     pc.printf("V: Ver and Hor Scroll done\r");                   
                     break;   

                                                                                                         
        } //switch
      }//if
    }//while
#endif

    pc.printf("Bye World!\n\r");                       
}//main    

