/* mbed Test program for debug and monitoring of ST nucleo boards with SWO.
 * Copyright (c) 2015, v01: WH, Initial version
 *               2016, v02: WH, Stream support, Added F446
 *               2017, v03: WH,PS. Added Stream claim for stdout, proposed by Pavel Sorejs 
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "mbed.h"
#include "flip.h"
#include "SWO.h"

//Single Wire Output(SWO) Test
//Hook up to Host PC software ST-LINK Utility or Segger J-Link SWO viewer
//
#define D_SWO    1  //Enable SWO output

//Stream implementation

DigitalOut myled(LED1); //PA_1

//Note:
// SWO is on pin PB_3
// SWDIO is on pin PA_13
// SWCLK is on pin PA_14
//
//I2C i2c(PB_9, PB_8); //I2C, OK
//DigitalIn in(PB_3);  //SWO, using pin breaks SWO viewer
//DigitalIn in(PA_10); //RX UART1, OK
//DigitalIn in(PA_13); //SWDIO, using pin breaks SWO viewer
//DigitalIn in(PA_14); //SWCLK, using pin breaks SWO viewer

Serial pc(SERIAL_TX, SERIAL_RX);

SWO_Channel swo("channel");

int i;

int main() {
#if defined(TARGET_NUCLEO_F103RB)
  pc.printf("Hello World from ST32F103RB\n\r");    
#endif  
#if defined(TARGET_NUCLEO_F401RE)
  pc.printf("Hello World from ST32F401RE\n\r");    
#endif  
#if defined(TARGET_NUCLEO_F446RE)
  pc.printf("Hello World from ST32F446RE\n\r");    
#endif  
//  pc.printf("\r\nMy Program - build " MBED_BUILD_TIMESTAMP "\r\n");
  pc.printf("\r\nMy Program - (partial) build " __DATE__ " " __TIME__ "\r\n");
  pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);  

#if (D_SWO == 1)
  swo.printf("\r\nHello World from SWO\r\n");
  swo.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock); 

  printf("Message on stdout\r\n");
    
  if (swo.claim() == true) {
    pc.printf("SWO has claimed stdout\r\n");
    printf("Message on stdout redirected to SWO\r\n");
  }
  else {
    pc.printf("SWO failed to claim stdout\r\n");
  }
#endif

  while(1) {
    myled = 1; // LED is ON
    wait(0.2); // 200 ms
    myled = 0; // LED is OFF
    wait(1.0); // 1 sec

    pc.putc('*');

#if (D_SWO == 1)
    swo.putc('#');
    flip(i);
    i = (i+1) & 0xFF;
#endif  
  }
}

