/* mbed Test program for debug and monitoring of ST nucleo boards with STM Studio.
 * Copyright (c) 2016, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"

//#define D_DEBUG 0  //disable debug with STMstudio
#define D_DEBUG 1  //enable debug with STMstudio

#if defined(TARGET_LPC1768)
// SPI for LPC1768
#define D_MOSI                 p5
#define D_MISO                 p6
#define D_SCLK                 p7
#define D_CS                   p8

//I2C for LPC1768
#define D_SCL                  p10
#define D_SDA                  p9

// Serial for LPC1768
#define D_TX                   USBTX
#define D_RX                   USBRX

// LEDs for LPC1768
#define D_LED_ON               1
#define D_LED_OFF              0

#define D_LED1                 LED1
#define D_LED2                 LED2
#define D_LED3                 LED3
#define D_LED4                 LED4

#define D_BTN1                 p20
#endif

#if defined(TARGET_NUCLEO_F103RB)
// Serial for ST32F103
#define D_TX                   SERIAL_TX
#define D_RX                   SERIAL_RX

// SPI for ST32F103
#define D_MOSI                 PA_7
#define D_MISO                 PA_6
#define D_SCLK                 PA_5 /*LED1 Green*/
#define D_CS                   PB_6

//I2C for ST32F103
#define D_SCL                  PB_8
#define D_SDA                  PB_9

//LEDs
#define D_LED_ON               1
#define D_LED_OFF              0
 
#define D_LED1                 LED1 /*PA_5 Green*/
#define D_LED2                 LED2
#define D_LED3                 LED3
#define D_LED4                 LED3

#define D_BTN1                 PC_13
#endif

//SPI Bus
//SPI spi(D_MOSI, D_MISO, D_SCLK); //MOSI, MISO, SCK

//I2C Bus
//I2C i2c(D_SDA, D_SCL);       //SDA, SCL

//Serial Bus
Serial pc(D_TX,D_RX);

//DigitalOut
DigitalOut myled1(D_LED1); /*Blue*/
//DigitalOut myled2(D_LED2);  /*Green*/
//DigitalOut myled3(D_LED3);  /*Red*/
//DigitalOut myled3(D_LED4);  /*Red*/

DigitalIn myBtn1(D_BTN1);

int i;
char c;
float s;
bool b1;
volatile int b2 = 1;
float wt = 0.7f;
int main() {

#if defined(TARGET_LPC1768)
  pc.printf("\r\nHello World from LPC1768\r\n");
#endif  
#if defined(TARGET_KL25Z)
  pc.printf("\r\nHello World from KL25Z\r\n");
#endif  
#if defined(TARGET_LPC812)
  pc.printf("\r\nHello World from LPC812\r\n");
#endif
#if defined(TARGET_LPC1549)
  pc.printf("Hello World from LPC1549\n\r");    
#endif  
#if defined(TARGET_NUCLEO_F401RE)
  pc.printf("Hello World from ST32F401RE\n\r");    
#endif  
#if defined(TARGET_NUCLEO_F103RB)
  pc.printf("Hello World from ST32F103RB\n\r");    
#endif  
    
#if(D_DEBUG == 1) 
  pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);      

//The STM Studio tool can import .elf or .axf files which contain a memory map of all variables used in your code.
//However, the mbed online compiler does not generate these files, so instead use the following printf to
//figure out where the vars that you want to monitor (or manipulate) are located and manually paste their addresses into STMstudio
  pc.printf("i is at 0x%08X\r\n", &i);
  pc.printf("c is at 0x%08X\r\n", &c);
  pc.printf("s is at 0x%08X\r\n", &s);
  pc.printf("b1 is at 0x%08X\r\n", &b1);
  pc.printf("b2 is at 0x%08X\r\n", &b2);
#endif
             
  while(1) {
    myled1 = D_LED_ON;  // LED is ON
    wait(0.1);          // 100 ms
    myled1 = D_LED_OFF; // LED is OFF
    wait(0.1);          // 100 ms        
    myled1 = D_LED_ON;  // LED is ON
    wait(0.1);          // 100 ms
    myled1 = D_LED_OFF; // LED is OFF        
//    wait(0.7);          // 700 ms
    wait(wt);          // variable ms
        
    i++;
    c++;
    s = 100.0f * sin((float)c * 3.1415f / 128.0f);
    b1 = myBtn1;
    if (b1 && (b2 == 1)) {
      pc.putc('1');
      wt = 0.7f;
    }
    else {
      pc.putc('0');
      wt = 0.3f;      
    }
  }

  pc.printf("\nBye World!\n");
}
