#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx

// Variables for Heartbeat and Status
Ticker heartbeat;
bool heartbeatflag=false;

PwmOut K1(LED1);
PwmOut K2(LED2);
PwmOut K3(LED3);
PwmOut K4(LED4);

void show_menu() {
    pc.printf("0: Exit\n\r");
    pc.printf("1: Show Menu\n\r");    
    pc.printf("2: Start KITT\n\r"); 
    pc.printf("3: Stop KITT\n\r");     
    pc.printf("\n\r");                
}


#define KITT_PERIOD 0.010 
#define KITT_OFF    0.00
#define KITT_20     (KITT_PERIOD / 15.0)
#define KITT_50     (KITT_PERIOD /  5.0)
#define KITT_MAX    (KITT_PERIOD)

// Heartbeat monitor
void pulse() {
  static int kitt_state=0;
  
  if (!heartbeatflag) {
    K1.pulsewidth(KITT_OFF); // K1 Off
    K2.pulsewidth(KITT_OFF); // K2 Off
    K3.pulsewidth(KITT_OFF); // K3 Off
    K4.pulsewidth(KITT_OFF); // K4 Off         
  }
  else {             

    switch (kitt_state) {
      case 0: 
               //  1000
               K1.pulsewidth(KITT_MAX); // K1 On
               K2.pulsewidth(KITT_20);  // K2 Decay
               K3.pulsewidth(KITT_OFF); // K3 Off
               K4.pulsewidth(KITT_OFF); // K4 Off         
               
               kitt_state++;
               break;
      case 1:
               //  0100     
               K1.pulsewidth(KITT_50);  // K1 Decay
               K2.pulsewidth(KITT_MAX); // K2 On
               K3.pulsewidth(KITT_OFF); // K3 Off
               K4.pulsewidth(KITT_OFF); // K4 Off         
                           
               kitt_state++;
               break;            
      case 2:
               //  0010         
               K1.pulsewidth(KITT_20);  // K1 Decay
               K2.pulsewidth(KITT_50);  // K2 Decay
               K3.pulsewidth(KITT_MAX); // K3 On
               K4.pulsewidth(KITT_OFF); // K4 Off         
                           
               kitt_state++;
               break;                          
      case 3:
               //  0001             
               K1.pulsewidth(KITT_OFF); // K1 Off
               K2.pulsewidth(KITT_20);  // K2 Decay
               K3.pulsewidth(KITT_50);  // K3 Decay
               K4.pulsewidth(KITT_MAX); // K4 On         
                           
               kitt_state++;
               break;                         
      case 4:                 
               //  0001                          
               K1.pulsewidth(KITT_OFF); // K1 Off
               K2.pulsewidth(KITT_OFF); // K2 Off
               K3.pulsewidth(KITT_20);  // K3 Decay
               K4.pulsewidth(KITT_MAX); // K4 On         
                           
               kitt_state++;
               break;             
      case 5:
               //  0010
               K1.pulsewidth(KITT_OFF); // K1 Off
               K2.pulsewidth(KITT_OFF); // K2 Off
               K3.pulsewidth(KITT_MAX); // K3 On
               K4.pulsewidth(KITT_50);  // K4 Decay         
                           
               kitt_state++;
               break;             
      case 6:             
               //  0100
               K1.pulsewidth(KITT_OFF); // K1 Off
               K2.pulsewidth(KITT_MAX); // K2 On
               K3.pulsewidth(KITT_50);  // K3 Decay
               K4.pulsewidth(KITT_20);  // K4 Decay         
                           
               kitt_state++;
               break;             
      case 7:             
               //  1000             
               K1.pulsewidth(KITT_MAX); // K1 On
               K2.pulsewidth(KITT_50);  // K2 Decay
               K3.pulsewidth(KITT_20);  // K3 Decay
               K4.pulsewidth(KITT_OFF); // K4 Off         
                           
               kitt_state = 0;
               break;            

    } //switch
  } //if              
                                          
}


void heartbeat_start() {
  heartbeat.attach(&pulse, 0.1);
  
  K1.period(KITT_PERIOD);          // KITT LEDs period

  heartbeatflag = true;
}

void heartbeat_stop() {
  heartbeat.detach();
  heartbeatflag = false;
}


int main() {

  bool running=true;
  char command;
    pc.printf("Hello World!\n\r");

    heartbeat_start();

    show_menu();
               
    while(running) {
          
       if(pc.readable()) {
         command = pc.getc();       
         pc.printf("command= %c \n\r", command);         

         switch (command) {
          case '0' :
                     pc.printf("Done\n\r");                    
                     running = false;  
                     break;
          
          case '1' :
                     show_menu();
                     break;
                    
          case '2' :
                     pc.printf("Start\n\r");          
                     heartbeatflag = true;                     
                     break;

          case '3' :
                     pc.printf("Stop\n\r");          
                     heartbeatflag = false;                                          
                     
                     break;
                    
         } //switch
     } // if   
   } //while 

   pc.printf("Bye World!\n\r");                          
}
