/* MBED_ControlBus - Use the MBED Port pins for controlling the Bus
 * Copyright (c) 2011 Wim Huiskamp
 *
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * version 0.2 Initial Release
*/
#ifndef _MBED_CONTROLBUS_H
#define _MBED_CONTROLBUS_H

//Enums for Control Bus
#include "BusEnums.h"

/** Create an MBED_ControlBus object connected to the specified Pins
 *
 * @param PinName WR the Write pin 
 * @param PinName RD the Read pin 
 * @param PinName DTR the databuffer Transmit/Receive direction pin 
 * @param PinName CDBUF the databuffer enable pin
 * @param PinName CDINT the Keyboard interrupt pin 
*/
class MBED_ControlBus {
public:
    MBED_ControlBus(PinName WR, PinName RD, PinName DTR, PinName CDBUF, PinName CDINT);
    void WR (Bit_Level wr_level);
    void RD (Bit_Level rd_level);
    void busdir (Bus_Dir buf_dir);    
    void busctrl (Bus_Ena buf_ena, Bus_Dir buf_dir);   
    Bit_Level CDINT ();

protected:
    DigitalOut _WR;    // Write pin 
    DigitalOut _RD;    // Read pin 
    DigitalOut _DTR;   // Databuffer Transmit/Receive direction pin 
    DigitalOut _CDBUF; // Databuffer enable pin
    
//Plain digital input pin
    DigitalIn  _CDINT; // Keyboard interrupt pin
  
//Plain digital interrupt pin
//    InterruptIn  _CDINT; // Keyboard interrupt pin

//Debounced and Edge detected input pin (Andy Kirkmans's Lib)
//    PinDetect  _CDINT; // Keyboard interrupt pin    
       
    bool _CDINT_detected;

    void _init(); 
};

#endif