/**************************************************************
*  commands.c
*
* This Module contains the command handler and menus for the 
* Medical alert tone demo
*
*   Copyright(C) 2007, NXP Semiconductor
*   All rights reserved.     
*
*   Port to mbed 2012 (WH)
**************************************************************/

#include "mbed.h"
#include "commands.h"
#include "IEC60601-1-8.h"

//Externals from main
extern Serial pc;
extern bool running;
extern IEC60601 IEC_Alarm;

enum State_Type {MAIN_STATE, HI_PRI_STATE, MED_PRI_STATE, LO_PRI_STATE, TST_STATE};
State_Type cmd_state;

unsigned char proc_cmd;

// Menus
void MainMenu(void) {
        pc.printf ("Main Commands:\n\r");
        pc.printf ("Press '0' to Exit\n\r");            
        pc.printf ("Press '1' for High Priority Alarm Menu\n\r");
        pc.printf ("Press '2' for Medium Priority Alarm Menu\n\r");
        pc.printf ("Press '3' for Low Priority Alarm Menu\n\r");
        pc.printf ("Press '4' for Test Menu\n\r");
        pc.printf ("Enter Command Number: ");        
}

void HPMenu(void) {
        pc.printf ("High Priority Commands:\n\r");
        pc.printf (" 0 - Exit High Priority Commands\n\r");        
        pc.printf (" 1 - High Priority General Alarm\n\r");
        pc.printf (" 2 - High Priority Cardiac Alarm\n\r");        
        pc.printf (" 3 - High Priority Artificial Perfusion Alarm\n\r");
        pc.printf (" 4 - High Priority Ventilation Alarm\n\r");
        pc.printf (" 5 - High Priority Temperature Alarm\n\r");
        pc.printf (" 6 - High Priority Oxygen Alarm\n\r");
        pc.printf (" 7 - High Priority Drug Delivery Alarm\n\r");
        pc.printf (" 8 - High Priority Equipment/Supply Failure Alarm\n\r");
        pc.printf ("Enter Command Number: ");
}

void MPMenu(void) {
        pc.printf ("Medium Priority Commands:\n\r");
        pc.printf (" 0 - Exit Medium Priority Commands\n\r");                        
        pc.printf (" 1 - Medium Priority General Alarm\n\r");
        pc.printf (" 2 - Medium Priority Cardiac Alarm\n\r");        
        pc.printf (" 3 - Medium Priority Artificial Perfusion Alarm\n\r");
        pc.printf (" 4 - Medium Priority Ventilation Alarm\n\r");
        pc.printf (" 5 - Medium Priority Temperature Alarm\n\r");
        pc.printf (" 6 - Medium Priority Oxygen Alarm\n\r");
        pc.printf (" 7 - Medium Priority Drug Delivery Alarm\n\r");
        pc.printf (" 8 - Medium Priority Equipment/Supply Failure Alarm\n\r");
        pc.printf ("Enter Command Number: ");
}

void LPMenu(void) {
        pc.printf ("Low Priority Commands:\n\r");
        pc.printf (" 0 - Exit Low Priority Commands\n\r");                
        pc.printf (" 1 - Low Priority General Alarm\n\r");
        pc.printf ("Enter Command Number: ");

}

void TSTMenu(void) {
        pc.printf ("Test Commands:\n\r");
        pc.printf (" 0 - Exit Test Commands\n\r");        
        pc.printf (" 1 - Sound Low Multi-Tone\n\r");
        pc.printf (" 2 - Sound High Multi-Tone\n\r");
        pc.printf (" 3 - Sound Low Single Tone\n\r");
        pc.printf (" 4 - Sound High Single Tone\n\r");
        pc.printf (" 5 - Reset Test Settings\n\r");
        pc.printf ("Enter Command Number: ");

}

void ShowMenu() {

  switch (cmd_state) {
    case MAIN_STATE:
        MainMenu();
        break;
    case HI_PRI_STATE:
        HPMenu();           
        break;
    case MED_PRI_STATE:
        MPMenu();
        break;
    case LO_PRI_STATE:
        LPMenu();           
        break;
    case TST_STATE:
        TSTMenu();           
        break;
    default:
        break;
  }
}



//Commands
void MainCommnds(char command) {
       switch (command) {
         case '0':
            pc.printf("Done\n\r");                    
            running = false;        
            break;

         case '1':
            cmd_state = HI_PRI_STATE;
            break;

         case '2':
            cmd_state = MED_PRI_STATE;         
            break;

         case '3':
            cmd_state = LO_PRI_STATE;         
            break;
            
         case '4':
            cmd_state = TST_STATE;         
            break;
         default:
            break;          
        }
}


void HPCommnds(char command) {

    switch (command)
    {
       case '0':
         cmd_state = MAIN_STATE;                  
         break;       
       case '1':          
         pc.printf ("High Priority General Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(HIGH, GENERAL);
         break;
       case '2':          
         pc.printf ("High Priority Cardiac Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(HIGH, CARDIOVASCULAR);         
         break;
       case '3':           
         pc.printf ("High Priority Artificial Perfusion Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(HIGH, PERFUSION);                  
         break;
       case '4':          
         pc.printf ("High Priority Ventilation Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(HIGH, VENTILATION);
         break;
       case '5':          
         pc.printf ("High Priority Temperature Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(HIGH, TEMPERATURE);
         break;
       case '6':           
         pc.printf ("High Priority Oxygen Alarm\n\r"); 
         IEC_Alarm.TurnOnAlarm(HIGH, OXYGEN);
         break;
       case '7':         
         pc.printf ("High Priority Drug Delivery Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(HIGH, DRUG_DELIVERY);
         break;
       case '8':    
         pc.printf ("High Priority Equipment/Supply Failure Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(HIGH, POWER_FAIL);
         break;      
       default:
         pc.printf ("Command not supported\n\r");
         break;     
       }
}

void MPCommnds(char command) {
    
    switch (command)
    {
       case '0':
         cmd_state = MAIN_STATE;         
         break;         
       case '1':          
         pc.printf ("Medium Priority General Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(MEDIUM, GENERAL);
         break;
       case '2':          
         pc.printf ("Medium Priority Cardiac Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(MEDIUM, CARDIOVASCULAR);
         break;
       case '3':           
         pc.printf ("Medium Priority Artificial Perfusion Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(MEDIUM, PERFUSION);
         break;
       case '4':          
         pc.printf ("Medium Priority Ventilation Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(MEDIUM, VENTILATION);
         break;
       case '5':          
         pc.printf ("Medium Priority Temperature Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(MEDIUM, TEMPERATURE);
         break;
       case '6':           
         pc.printf ("Medium Priority Oxygen Alarm\n\r"); 
         IEC_Alarm.TurnOnAlarm(MEDIUM, OXYGEN);
         break;
       case '7':           
         pc.printf ("Medium Priority Drug Delivery Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(MEDIUM, DRUG_DELIVERY);
         break;
       case '8':    
         pc.printf ("Medium Priority Equipment/Supply Failure Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(MEDIUM, POWER_FAIL);
         break;      
       default:
         pc.printf ("Command not supported\n\r");
         break;     
       }
}

void LPCommnds(char command)
{
    switch (command) {
       case '0':
         cmd_state = MAIN_STATE;
         break;       
       case '1':          
         pc.printf ("Low Priority Alarm\n\r");
         IEC_Alarm.TurnOnAlarm(LOW, LOW_ALARM);
         break;
 
       default:
         pc.printf ("Command not supported\n\r");
         break;     
       }
}

void TestCommnds(char command) {

    switch (command) {
       case '0':
         cmd_state = MAIN_STATE;
         IEC_Alarm.TestAlarm(C4, 255, 255, 255, 255, 255);       // make sure weightfactors are reset                    
         break;           
       case '1':          
         pc.printf ("Sound Low Multi Tone\n\r");
         IEC_Alarm.TestAlarm(C4, 255, 255, 255, 255, 255);         
         break;
       case '2':          
         pc.printf ("Sound High Multi Tone\n\r");
         IEC_Alarm.TestAlarm(C5, 255, 255, 255, 255, 255);                  
         break;
       case '3':           
         pc.printf ("Sound Low Single Tone\n\r");
         IEC_Alarm.TestAlarm(C4, 255, 0, 0, 0, 0);                           
         break;
       case '4':          
         pc.printf ("Sound High Single Tone\n\r");
         IEC_Alarm.TestAlarm(C5, 0, 0, 0, 0, 255);                                    
         break;
       case '5':           
         pc.printf ("Reset Test Settings\n\r");
         IEC_Alarm.TestAlarm(C4, 255, 255, 255, 255, 255);                  
         break;
       default:
         pc.printf ("Command not supported\n\r");
         break;     
       }
}

void InitCommand(void) {
  
    cmd_state = MAIN_STATE;  
}



void DecodeCommand(char command) {

  switch (cmd_state) {
    case MAIN_STATE:
//        pc.printf ("Main Commands:\n\r");
        MainCommnds(command);
        break;
  
    case HI_PRI_STATE:
//        pc.printf ("High Priority Commands:\n\r");
        HPCommnds(command);
        break;
  
    case MED_PRI_STATE:
//        pc.printf ("Medium Priority Commands:\n\r");
        MPCommnds(command);
        break;

    case LO_PRI_STATE:
//        pc.printf ("Low Priority Commands:\n\r");
        LPCommnds(command);
        break;

    case TST_STATE:
//        pc.printf ("Test Commands:\n\r");
        TestCommnds(command);
        break;

    default:
        break;
  }
}






