/****************************************************************
 *  IEC601601-1-8 
 *
 *   This modules provides the IEC Medical Alert tones.
 *
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *   Port to mbed 2012 (WH)
 ****************************************************************/
 
#ifndef _IEC60601_1_8_H
#define _IEC60601_1_8_H

enum Note_Type  {C4=0,D4=1,E4=2,F4=3,Fsharp4=4,G4=5,A4=6,B4=7,C5=8};      // Can address array rows with notes

enum Alarm_Type {GENERAL=0, CARDIOVASCULAR=1, PERFUSION=2, VENTILATION=3,  
                 TEMPERATURE=4, OXYGEN=5, DRUG_DELIVERY=6, POWER_FAIL=7, LOW_ALARM=8}; // Can tone_seq array rows with alarms

enum Prio_Type  {HIGH, MEDIUM, LOW, TEST};

struct wave  {                  // struct for Sine Wave Generator Signal   
  short coef;                      // IIR filter coefficient                
  long y1;                         // y[-1] value                            
  long y2;                         // y[-2] value      
};  


class IEC60601 {

public:
  IEC60601();
  void TurnOnAlarm(Prio_Type priority, Alarm_Type alarm_type);
  void TurnOffAlarm(void); 
  void TestAlarm(Note_Type active_note, int w0, int w1, int w2, int w3, int w4);           

private:  
  void _InitSequencer(void);
  void _InitDAC(void);   
  void _InitToneCoefArray(void);
  void _TimerInteruptHandler (void);      

  void _GenerateMultiTone (struct wave *t);
//  void _OutputTones(Note_Type note, unsigned char level);
  void _TurnOnNote(void);
  void _TurnOffNote(void);
  void _EnvelopeControl(void);    
  void _HighPriSequence (void);
  void _MedPriSequence (void);
  void _LowPriSequence (void);
  void _TestSequence (void);
    
  Alarm_Type _alarm_type;
  Prio_Type _priority;
  unsigned int _sequence;
  unsigned int _mscount;
  
  int _envelope;
  Note_Type _active_note;
  bool _note_on;
  int _note_level;  
  bool _envelope_on;    
  bool _envelope_off;
  
  Ticker _ticker;
  
};
#endif
