/******************************************************************************
*   Tones_demo:                         
*
*      This module contains the "main" function for the IEC60601-1-8 alarm tone                                                                      
*      synthesizer. The main function initializes peripherals and variables and                                                           
*      provides for a command test in the main loop to handle incoming commands.
*  
*   Copyright(C) 2007, NXP Semiconductor
*   All rights reserved. 
*
*   Port to mbed 2012 (WH)
******************************************************************************/

#include "mbed.h"
#include "commands.h"
#include "IEC60601-1-8.h"

IEC60601 IEC_Alarm;

Serial pc(USBTX, USBRX); // tx, rx

// Variables to control Audio generator
bool running=true;
char command;

// Variables for Heartbeat and Status
Ticker heartbeat;
bool heartbeatflag=false;

DigitalOut MyLed1(LED1);
DigitalOut MyLed2(LED2);
DigitalOut MyLed3(LED3);
DigitalOut MyLed4(LED4);


// Heartbeat monitor
void pulse() {
  MyLed4 = !MyLed4;                                          
}


void heartbeat_start() {
  heartbeat.attach(&pulse, 0.5);
  
  heartbeatflag = true;
}

void heartbeat_stop() {
  heartbeat.detach();
  heartbeatflag = false;
}


int main() {

    pc.printf("Hello World!\n\r");

    heartbeat_start();
                         
    InitCommand();

    ShowMenu();
    while(running) {
       if(pc.readable()) {        // poll for command          
         command = pc.getc();       
//         pc.printf("Command= %c \n\r", command);         
         DecodeCommand(command);
         ShowMenu();
       } // if   
    } //while 

   pc.printf("Bye World!\n\r");                          
}
