/* mbed TM1651 Test program, for TM1651 LED controller
 * Copyright (c) 2017, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "TM1651.h"

#if (OPENSMART_TEST == 1)
// OPENSMART TM1651 battery level display test

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);  //NOTE: On F401 LED1 is Pin D13, which is SCK!

// DisplayData_t size is 4 bytes (4 Grids @ 7 Segments) 
TM1651::DisplayData_t all_str   = {0x7F, 0x7F, 0x7F, 0x7F};  
TM1651::DisplayData_t cls_str   = {0x00, 0x00, 0x00, 0x00};  

// KeyData_t size is 1 bytes  
TM1651::KeyData_t keydata; 

//TM1651_OPENSMART declaration
TM1651_OPENSMART OPENSMART(p6, p7);       //LPC1768
//TM1651_OPENSMART OPENSMART(D9, D10);      //F401

void show_menu() {
//    pc.printf("0:   Exit\n\r");
    pc.printf("1:   All\n\r");    
    pc.printf("2:   Show all segs\r\n");
    pc.printf("3:   Show all leds\n\r");
    pc.printf("4:   Show all levels\n\r");    
    pc.printf("5:   Kitt\n\r");
    pc.printf("6:   Cls\n\r");    
    pc.printf("k:   Key\n\r");
}


char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    OPENSMART.cls(); 
    OPENSMART.writeData(all_str);
    wait(2);
    OPENSMART.setBrightness(TM1651_BRT3);    
    wait(1);
    OPENSMART.setBrightness(TM1651_BRT0);        
    wait(1);
    OPENSMART.setBrightness(TM1651_BRT4);            

    wait(1);
    OPENSMART.cls(); 
    
    char cmd2 = '0';
    while (1) {
      
      show_menu();
      cmd2 = pc.getc();

      switch (cmd2) {
        case '1' : {
                      pc.printf("all\r\n");
                      OPENSMART.cls(); 
                      OPENSMART.writeData(all_str);
                      break;
        }

        case '2' : {
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          OPENSMART.cls(); 
         
          for (int i=0; i<TM1651_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              OPENSMART.cls(); 

              bits = 0x01 << bit;              
              OPENSMART.writeData(bits, i);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all segs done\r\n");                    
#endif 
          break;          
        }

        case '3':  { 
#if(1)
//test to show all LEDs
          pc.printf("Show all Leds\r\n");
          OPENSMART.cls();
          
          float delay=0.1;
          // Leds on
          OPENSMART.setIcon(TM1651_OPENSMART::LD12); wait(delay);
          OPENSMART.setIcon(TM1651_OPENSMART::LD3);  wait(delay);
          OPENSMART.setIcon(TM1651_OPENSMART::LD4);  wait(delay);
          OPENSMART.setIcon(TM1651_OPENSMART::LD5);  wait(delay);
          OPENSMART.setIcon(TM1651_OPENSMART::LD67); wait(delay);
          OPENSMART.setIcon(TM1651_OPENSMART::LD89); wait(delay);
          OPENSMART.setIcon(TM1651_OPENSMART::LD10); wait(delay);

          wait(delay);
 
          // Leds off
          OPENSMART.clrIcon(TM1651_OPENSMART::LD10); wait(delay);
          OPENSMART.clrIcon(TM1651_OPENSMART::LD89); wait(delay);
          OPENSMART.clrIcon(TM1651_OPENSMART::LD67); wait(delay);
          OPENSMART.clrIcon(TM1651_OPENSMART::LD5);  wait(delay);
          OPENSMART.clrIcon(TM1651_OPENSMART::LD4);  wait(delay);
          OPENSMART.clrIcon(TM1651_OPENSMART::LD3);  wait(delay);
          OPENSMART.clrIcon(TM1651_OPENSMART::LD12); wait(delay);

//          wait(1);
          pc.printf("Show all Leds done\r\n");                    
#endif           
          break;
        }                          

        case '4':  { 
#if(1)
//test to show all Levels
          pc.printf("Show all Levels\r\n");
          OPENSMART.cls();
          
          float delay=0.1;
          // Levels
          OPENSMART.setLevel(TM1651_OPENSMART::LVL_0); wait(delay);
          OPENSMART.setLevel(TM1651_OPENSMART::LVL_1); wait(delay);
          OPENSMART.setLevel(TM1651_OPENSMART::LVL_2); wait(delay);
          OPENSMART.setLevel(TM1651_OPENSMART::LVL_3); wait(delay);
          OPENSMART.setLevel(TM1651_OPENSMART::LVL_4); wait(delay);
          OPENSMART.setLevel(TM1651_OPENSMART::LVL_5); wait(delay);
          OPENSMART.setLevel(TM1651_OPENSMART::LVL_6); wait(delay);

          wait(delay);
 
          // Levels off
          OPENSMART.setLevel(TM1651_OPENSMART::LVL_5); wait(delay);
          OPENSMART.setLevel(TM1651_OPENSMART::LVL_4); wait(delay);
          OPENSMART.setLevel(TM1651_OPENSMART::LVL_3); wait(delay);
//          OPENSMART.setLevel(TM1651_OPENSMART::LVL_2); wait(delay);
//          OPENSMART.setLevel(TM1651_OPENSMART::LVL_1); wait(delay);
//          OPENSMART.setLevel(TM1651_OPENSMART::LVL_0); wait(delay);

//          wait(1);
          pc.printf("Show all Levels done\r\n");
#endif           
          break;
        }                          

        case '5': {

#if(0)
//test to show KITT
          pc.printf("Show KITT scanner\r\n");
          OPENSMART.cls(); // clear all

          float delay=0.1;
          while (!pc.readable()) { // wait for key
            // Levels
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_0); wait(delay);
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_1); wait(delay);
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_2); wait(delay);
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_3); wait(delay);
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_4); wait(delay);
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_5); wait(delay);
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_6); wait(delay);
            // Levels off
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_5); wait(delay);
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_4); wait(delay);
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_3); wait(delay);
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_2); wait(delay);
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_1); wait(delay);
            OPENSMART.setLevel(TM1651_OPENSMART::LVL_0); wait(delay);
            OPENSMART.cls(); ; wait(delay) // clear all            
          }
          cmd = pc.getc(); // read key           
          pc.printf("Show KITT done\r\n");
#endif

#if(1)
//test to show KITT
          pc.printf("Show KITT scanner\r\n");
          OPENSMART.cls(); // clear all

          float delay=0.05;
          while (!pc.readable()) { // wait for key
            // Leds
            OPENSMART.setIcon(TM1651_OPENSMART::LD12); wait(delay);
            OPENSMART.setIcon(TM1651_OPENSMART::LD3); wait(delay);
            
            OPENSMART.setIcon(TM1651_OPENSMART::LD4); wait(delay);
            OPENSMART.clrIcon(TM1651_OPENSMART::LD12); wait(delay);
                        
            OPENSMART.setIcon(TM1651_OPENSMART::LD5); wait(delay);
            OPENSMART.clrIcon(TM1651_OPENSMART::LD3); wait(delay);

            OPENSMART.setIcon(TM1651_OPENSMART::LD67); wait(delay);
            OPENSMART.clrIcon(TM1651_OPENSMART::LD4); wait(delay);
            
            OPENSMART.setIcon(TM1651_OPENSMART::LD89); wait(delay);
            OPENSMART.clrIcon(TM1651_OPENSMART::LD5); wait(delay);
                        
            OPENSMART.setIcon(TM1651_OPENSMART::LD10); wait(delay);
            OPENSMART.clrIcon(TM1651_OPENSMART::LD67); wait(delay);
            
            OPENSMART.clrIcon(TM1651_OPENSMART::LD89); wait(delay);

            OPENSMART.clrIcon(TM1651_OPENSMART::LD10); wait(delay);
            
            OPENSMART.setIcon(TM1651_OPENSMART::LD10); wait(delay);
            OPENSMART.setIcon(TM1651_OPENSMART::LD89); wait(delay);

            OPENSMART.setIcon(TM1651_OPENSMART::LD67); wait(delay);
            OPENSMART.clrIcon(TM1651_OPENSMART::LD10); wait(delay);

            OPENSMART.setIcon(TM1651_OPENSMART::LD5); wait(delay);
            OPENSMART.clrIcon(TM1651_OPENSMART::LD89); wait(delay);

            OPENSMART.setIcon(TM1651_OPENSMART::LD4); wait(delay);
            OPENSMART.clrIcon(TM1651_OPENSMART::LD67); wait(delay);

            OPENSMART.setIcon(TM1651_OPENSMART::LD3); wait(delay);
            OPENSMART.clrIcon(TM1651_OPENSMART::LD5); wait(delay);

            OPENSMART.setIcon(TM1651_OPENSMART::LD12); wait(delay);
            OPENSMART.clrIcon(TM1651_OPENSMART::LD4); wait(delay);

            OPENSMART.clrIcon(TM1651_OPENSMART::LD3); wait(delay);
            
            OPENSMART.clrIcon(TM1651_OPENSMART::LD12); wait(delay);
          }
          cmd = pc.getc(); // read key           
          pc.printf("Show KITT done\r\n");          
#endif
          break;
        }  

        case '6': {
          OPENSMART.cls(); // clear all
          break;
        }  

        case 'k': {
          if (OPENSMART.getKeys(&keydata)) {
            pc.printf("Keydata = 0x%02x\r\n", keydata);
          } 
          break;
        }
          
        default : {
          break;
        }         
     
      } //switch cmd

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif


#if (TM1651_TEST == 1)
// Direct TM1651 Test

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 4 bytes (4 Grids @ 7 Segments) 
TM1651::DisplayData_t all_str   = {0x7F, 0x7F, 0x7F, 0x7F};  
TM1651::DisplayData_t cls_str   = {0x00, 0x00, 0x00, 0x00};  

// KeyData_t size is 1 bytes  
TM1651::KeyData_t keydata; 

// TM1651 declaration
TM1651 TM1651(p6,p7);     //LPC1768

void show_menu() {
//    pc.printf("0:   Exit\n\r");
    pc.printf("1:   All\n\r");    
    pc.printf("2:   Cls\n\r");        
    pc.printf("3:   Show all segs\r\n");
}


char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    TM1651.cls(); 
    TM1651.writeData(all_str);
    wait(2);
    TM1651.setBrightness(TM1651_BRT3);    
    wait(1);
    TM1651.setBrightness(TM1651_BRT0);        
    wait(1);
    TM1651.setBrightness(TM1651_BRT4);            
    
    while (1) {
     
      cmd = pc.getc();

      switch (cmd) {
        case '1' : 
          TM1651.cls(); 
          TM1651.writeData(all_str);
         break;    
               
        case '2' :       
          TM1651.cls(); 
          TM1651.writeData(cls_str);
         break;    
               
        case '3' :

#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          TM1651.cls(); 
         
          for (int i=0; i<TM1651_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              TM1651.cls(); 

              bits = 0x01 << bit;              
              TM1651.writeData(bits, i);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
         break;    
                       
        default : 
          break;          
     
      } //switch cmd

      // Check and read keydata
      if (TM1651.getKeys(&keydata)) {
        pc.printf("Keydata = 0x%02x\r\n", keydata);
      } // Check keydata

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif
