/* mbed TM1650 Test program, for TM1650 LED controller
 * Copyright (c) 2017, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "TM1650.h"

#if (MEIBAI_TEST == 1)
// MEIBAI TM1650 4 Digit display test
#include "Font_7Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);  //NOTE: On F401 LED1 is Pin D13, which is SCK!

// DisplayData_t size is 4 bytes (4 Grids @ 8 Segments) 
TM1650::DisplayData_t all_str   = {0xFF, 0xFF, 0xFF, 0xFF};  
TM1650::DisplayData_t cls_str   = {0x00, 0x00, 0x00, 0x00};  
TM1650::DisplayData_t hello_str = {C7_H, C7_I, 0x00, 0x00};
TM1650::DisplayData_t bye_str   = {C7_B, C7_Y, C7_E, 0x00};

// KeyData_t size is 1 bytes  
TM1650::KeyData_t keydata; 

//TM1650_MEIBAI declaration
TM1650_MEIBAI MEIBAI(p6, p7);       //LPC1768
//TM1650_MEIBAI MEIBAI(D9, D10);      //F401

void show_menu() {
//    pc.printf("0:   Exit\n\r");
    pc.printf("1:   All\n\r");    
    pc.printf("2:   Show all segs\r\n");
    pc.printf("3:   Show all chars\n\r");
    pc.printf("4:   Show all digits\n\r");
    pc.printf("5:   Show all icons\n\r");
    pc.printf("6:   Counter\n\r");
    pc.printf("7:   Floats\n\r");
    pc.printf("8:   Kitt\n\r");
    pc.printf("9:   Cls\n\r");    
    pc.printf("A:   Bye\n\r");    
    pc.printf("k:   Key\n\r");
    pc.printf("u:   UDC\n\r");    
}


char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    MEIBAI.cls(); 
    MEIBAI.writeData(all_str);
    wait(2);
    MEIBAI.setBrightness(TM1650_BRT3);    
    wait(1);
    MEIBAI.setBrightness(TM1650_BRT0);        
    wait(1);
    MEIBAI.setBrightness(TM1650_BRT4);            

    wait(1);
    MEIBAI.cls(true); 
    MEIBAI.writeData(hello_str); 
    
    MEIBAI.setUDC(0, S7_A | S7_B | S7_F | S7_G);  // Degree symbol
    
    char cmd2 = '0';
    while (1) {
      
      show_menu();
      cmd2 = pc.getc();

      switch (cmd2) {
        case '1' : {
                      pc.printf("all\r\n");
                      MEIBAI.cls(); 
                      MEIBAI.writeData(all_str);
                      break;
        }

        case '2' : {
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          MEIBAI.cls(); 
         
          for (int i=0; i<TM1650_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              MEIBAI.cls(); 

              bits = 0x01 << bit;              
              MEIBAI.writeData(bits, i);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all segs done\r\n");                    
#endif 
          break;          
        }

        case '3' : {

#if(1)
//test to show all chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          MEIBAI.cls(); 
         
          for (int i=0; i<26; i++) {
            MEIBAI.printf("%c", char(i + 'A'));
//            MEIBAI.printf("%c", char(i + 'a'));            
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            

#if(0)
//test to show all chars
          pc.printf("Show all chars\r\n");
          wait(1);          
          MEIBAI.cls(); 

          for (int i=FONT_7S_START; i<FONT_7S_END; i++) {
            MEIBAI.printf("%c", char(i));
//            wait(0.25);
            cmd = pc.getc(); // wait for key            
          }
          pc.printf("Show all chars done\r\n");                    
#endif            
          break;          
        }
        case '4': {
#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          MEIBAI.cls(); 

          for (int i=0; i<MEIBAI_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              MEIBAI.locate(i);
              MEIBAI.printf("%0d", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          MEIBAI.cls(); 

          MEIBAI.printf("%04x", 0x01AB);
          cmd = pc.getc(); // wait for key                                     
          MEIBAI.printf("%04x", 0x0);
                    
          for (int i=0; i<MEIBAI_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              MEIBAI.locate(i);
              MEIBAI.printf("%0x", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif                
          break;          
        }
        case '5':  { 
#if(1)
//test to show all icons
          pc.printf("Show all icons\r\n");
          MEIBAI.cls(true); // Also clear all Icons
          
          float delay=0.1;
          // Icons on, Note that some versions do not have decimal points, but a
          // a double colon on the second digit to show hours:min
          MEIBAI.setIcon(TM1650_MEIBAI::DP1); wait(delay);
          MEIBAI.setIcon(TM1650_MEIBAI::DP2); wait(delay);
          MEIBAI.setIcon(TM1650_MEIBAI::DP3); wait(delay);
          MEIBAI.setIcon(TM1650_MEIBAI::DP4); wait(delay);

          wait(delay);
 
          // Icons off
          MEIBAI.clrIcon(TM1650_MEIBAI::DP4); wait(delay);
          MEIBAI.clrIcon(TM1650_MEIBAI::DP3); wait(delay);
          MEIBAI.clrIcon(TM1650_MEIBAI::DP2); wait(delay);
          MEIBAI.clrIcon(TM1650_MEIBAI::DP1); wait(delay);

//          wait(1);
//          MEIBAI.cls(); // clear all, preserve Icons
          pc.printf("Show all icons done\r\n");                    
#endif           
          break;
        }                          

        case '6': {
          MEIBAI.cls(); // clear all, preserve Icons

#if(1)
          MEIBAI.locate(0);
         
          for (int cnt=0; cnt<=0xFF; cnt++) {
            MEIBAI.locate(2);
            MEIBAI.printf("%02x", cnt);           
            wait(0.2);
          }  
#endif

//          MEIBAI.writeData(hello_str);
//          MEIBAI.printf("hello");                  

          break;          
        }
        case '7': {
          MEIBAI.cls(); // clear all, preserve Icons
          MEIBAI.printf("%1.2f", -0.12);  // test decimal point display                    
          wait(0.5);
          MEIBAI.cls(); // clear all, preserve Icons          
          MEIBAI.printf("%1.3f", 1.234);  // test decimal point display
          break;          
        }

        case '8': {

#if(1)
//test to show KITT
          pc.printf("Show KITT scanner\r\n");

          
//                          0123
const char KITT[][5]   = {{"8   "},
                          {"38  "},
                          {" 38 "},
                          {"  38"},
                          {"   3"},
                          {"    "},
                          {"   8"},
                          {"  8E"},
                          {" 8E "},
                          {"8E  "},
                          {"E   "},
                          {"    "}
                        };     
         
          MEIBAI.cls(); // clear all, preserve Icons
          
          while (!pc.readable()) { // wait for key            
            for (int i=0; i < (sizeof(KITT) / 5) ; i++) {
              MEIBAI.locate(0);
              MEIBAI.printf("%s", KITT[i]);
              wait(0.05);
            }
          }
          cmd = pc.getc(); // read key           
          pc.printf("Show KITT done\r\n");
#endif
          break;
        }  

        case '9': {
//          MEIBAI.cls(); // clear all, preserve Icons
          MEIBAI.cls(true); // clear all, including Icons                
          break;
        }  

        case 'A': {

          MEIBAI.cls(); // clear all, preserve Icons
//          MEIBAI.writeData(bye_str);
          MEIBAI.printf("Bye");          
       
          break;
        }  

        case 'k': {
          if (MEIBAI.getKeys(&keydata)) {
            pc.printf("Keydata = 0x%02x\r\n", keydata);
          } 
          break;
        }

        case 'u': {
          pc.printf("Show UDC\r\n");
          MEIBAI.cls(); // clear all, preserve Icons
          MEIBAI.putc(0); MEIBAI.putc(0); MEIBAI.putc(0); MEIBAI.putc(0);
          break;
        }  
          
        default : {
          break;
        }         
     
      } //switch cmd

#if(1)
      // Check and read keydata
      if (MEIBAI.getKeys(&keydata)) {
        pc.printf("Keydata = 0x%02x\r\n", keydata);

        MEIBAI.cls(); 
        switch (keydata) {
          case TM1650_SW1_BIT : { //sw1, 0x44
                                  MEIBAI.printf("--01");
                                  break;
                                }

          case TM1650_SW5_BIT:  { //sw5, 0x4C
                                  MEIBAI.printf("--02");
                                  break;
                                }

          case TM1650_SW9_BIT:  { //sw9, 0x5C
                                  MEIBAI.printf("--03");
                                  break;
                                }

          default :             {
                                  MEIBAI.printf("----");
                                  break;
                                }         
        }  

      } // Check keydata
#endif

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif


#if (TM1650_TEST == 1)
// Direct TM1650 Test

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 4 bytes (4 Grids @ 8 Segments) 
TM1650::DisplayData_t all_str   = {0xFF, 0xFF, 0xFF, 0xFF};  
TM1650::DisplayData_t cls_str   = {0x00, 0x00, 0x00, 0x00};  

// KeyData_t size is 1 bytes  
TM1650::KeyData_t keydata; 

// TM1650 declaration
TM1650 TM1650(p6,p7);     //LPC1768

void show_menu() {
//    pc.printf("0:   Exit\n\r");
    pc.printf("1:   All\n\r");    
    pc.printf("2:   Cls\n\r");        
    pc.printf("3:   Show all segs\r\n");
}


char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    TM1650.cls(); 
    TM1650.writeData(all_str);
    wait(1);
    TM1650.setBrightness(TM1650_BRT3);
    wait(1);
    TM1650.setBrightness(TM1650_BRT0);
    wait(1);
    TM1650.setBrightness(TM1650_BRT3);
    
    while (1) {
      show_menu();     
      cmd = pc.getc();

      switch (cmd) {
        case '1' : 
          TM1650.cls(); 
          TM1650.writeData(all_str);
         break;    
               
        case '2' :       
          TM1650.cls(); 
          TM1650.writeData(cls_str);
         break;    
               
        case '3' :

#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          TM1650.cls(); 
         
          for (int i=0; i<TM1650_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              TM1650.cls(); 

              bits = 0x01 << bit;              
              TM1650.writeData(bits, i);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
         break;    
                       
        default : 
          break;          
     
      } //switch cmd

      // Check and read keydata
      if (TM1650.getKeys(&keydata)) {
        pc.printf("Keydata = 0x%02x\r\n", keydata);
 
        if (keydata == TM1650_SW9_BIT) { //sw9  
          TM1650.cls(); 
          TM1650.writeData(0xFF, 1);
          TM1650.writeData(0xFF, 2);          
        }  
      } // Check keydata

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif
