/* mbed TM1640 Test program, for TM1640 LED controller
 * Copyright (c) 2016, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "TM1640.h"

#if (LM1640_TEST == 1)
// LM1640 TM1640 Test
#include "Font_7Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 16 bytes (16 Grids @ 8 Segments) 
TM1640::DisplayData_t all_str   = {0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF};  
TM1640::DisplayData_t cls_str   = {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  
TM1640::DisplayData_t hello_str = {C7_H,C7_E, C7_L,C7_L, C7_O,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};
TM1640::DisplayData_t bye_str   = {C7_B,C7_Y, C7_E,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};

//TM1640_LM1640 declaration
TM1640_LM1640 LM1640(p5,p7);


void show_menu() {
//    pc.printf("0:   Exit\n\r");
    pc.printf("1:   All\n\r");    
    pc.printf("2:   Show all segs\r\n"); 
    pc.printf("3:   Show all chars\n\r");    
    pc.printf("4:   Show all digits\n\r"); 
    pc.printf("5:   Show all icons\n\r");            
    pc.printf("6:   Counter\n\r");                
    pc.printf("7:   Bye\n\r");                    
    pc.printf("8:   Floats\n\r");                    
}


char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    LM1640.cls(); 
    LM1640.writeData(all_str);
    wait(2);
    LM1640.setBrightness(TM1640_BRT3);    
    wait(1);
    LM1640.setBrightness(TM1640_BRT0);        
    wait(1);
    LM1640.setBrightness(TM1640_BRT4);            

    wait(1);
    LM1640.cls(true); 
    LM1640.writeData(hello_str); 
    
    char cmd2 = '0';
    while (1) {
      
      show_menu();
      cmd2 = pc.getc();

      switch (cmd2) {
        case '1' : {
                      pc.printf("all\r\n");
                      LM1640.cls(); 
                      LM1640.writeData(all_str);
                      break;
        }

        case '2' : {
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          LM1640.cls(); 
         
          for (int i=0; i<TM1640_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              LM1640.cls(); 

              bits = 0x01 << bit;              
              LM1640.writeData(bits, i);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all segs done\r\n");                    
#endif 
          break;          
        }

        case '3' : {

#if(1)
//test to show all chars
          pc.printf("Show all NATO Alpha chars\r\n");

//                          01234567
const char NATO[][9]  = { {"Alpha   "},
                          {"Bravo   "},
                          {"Charlie "},
                          {"Delta   "},
                          {"Echo    "},
                          {"Foxtrot "},
                          {"Golf    "},
                          {"Hotel   "},
                          {"India   "},
                          {"Juliet  "},
                          {"Kilo    "},
                          {"Lima    "},
                          {"Mike    "},
                          {"November"},
                          {"Oscar   "},
                          {"Papa    "},
                          {"Quebec  "},
                          {"Romeo   "},
                          {"Sierra  "},
                          {"Tango   "},
                          {"Uniform "},
                          {"Victor  "},
                          {"Whiskey "},
                          {"X-ray   "},
                          {"Yankee  "},
                          {"Zulu    "}
                        };     

          LM1640.cls(); // clear all, preserve Icons
          for (int i=0; i<26; i++) {
            LM1640.locate(0);
            LM1640.printf("%s", NATO[i]);
            wait(0.5);
          }  
          pc.printf("Show all NATO Alpha chars done\r\n");
#endif

#if(0)
//test to show all chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          LM1640.cls(); 
         
          for (int i=0; i<26; i++) {
            LM1640.printf("%c", char(i + 'A'));
//            LM1640.printf("%c", char(i + 'a'));            
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            

#if(0)
//test to show all chars
          pc.printf("Show all chars\r\n");
          wait(1);          
          LM1640.cls(); 

          for (int i=FONT_7S_START; i<FONT_7S_END; i++) {
            LM1640.printf("%c", char(i));
//            wait(0.25);
            cmd = pc.getc(); // wait for key            
          }
          pc.printf("Show all chars done\r\n");                    
#endif            
          break;          
        }
        case '4': {
#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          LM1640.cls(); 

          for (int i=0; i<LM1640_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              LM1640.locate(i);
              LM1640.printf("%0d", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          LM1640.cls(); 

          LM1640.printf("%08x", 0x01234567);
          LM1640.printf("%08x", 0x89ABCDEF);          
          cmd = pc.getc(); // wait for key                                     
          LM1640.printf("%016x", 0x0);
                    
          for (int i=0; i<LM1640_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              LM1640.locate(i);
              LM1640.printf("%0x", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif                
          break;          
        }
        case '5':  { 
#if(1)
//test to show all icons
          pc.printf("Show all icons\r\n");
          LM1640.cls(true); // Also clear all Icons
          
          float delay=0.1;
          // Icons on             
          LM1640.setIcon(TM1640_LM1640::DP1); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP2); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP3); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP4); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP5); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP6); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP7); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP8); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP9); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP10); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP11); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP12); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP13); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP14); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP15); wait(delay);
          LM1640.setIcon(TM1640_LM1640::DP16); wait(delay);

          wait(delay);
 
          // Icons off      
          LM1640.clrIcon(TM1640_LM1640::DP1); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP2); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP3); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP4); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP5); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP6); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP7); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP8); wait(delay);                
          LM1640.clrIcon(TM1640_LM1640::DP9); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP10); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP11); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP12); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP13); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP14); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP15); wait(delay);
          LM1640.clrIcon(TM1640_LM1640::DP16); wait(delay);
//          wait(1);          
//          LM1640.cls(); // clear all, preserve Icons
          pc.printf("Show all icons done\r\n");                    
#endif           
          break;
        }                          

        case '6': {
          LM1640.cls(); // clear all, preserve Icons

#if(1)
          LM1640.locate(0);
          LM1640.printf("Counters ");                            
          
          for (int cnt=0; cnt<=0xFF; cnt++) {
            LM1640.locate(10);
            LM1640.printf("%02x", cnt);
            LM1640.locate(14);
            LM1640.printf("%02x", 0xFF - cnt);
            
            wait(0.2);
          }  
#endif

//          LM1640.writeData(hello_str);
//          LM1640.printf("hello");                  

          break;          
        }
        case '7': {

          LM1640.cls(); // clear all, preserve Icons
//          LM1640.writeData(bye_str);
          LM1640.printf("Bye");          
       
          break;
        }  

        case '8': {
          LM1640.cls(); // clear all, preserve Icons
          LM1640.printf("%2.3f", -0.1234);  // test decimal point display                    
          wait(0.5);
          LM1640.cls(); // clear all, preserve Icons          
          LM1640.printf("%2.3f", -012.345);  // test decimal point display
          break;          
        }

        default : {
          break;
        }         
     
      } //switch cmd

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif



#if (TM1640_TEST == 1)
// Direct TM1640 Test

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 16 bytes (16 Grids @ 8 Segments) 
TM1640::DisplayData_t all_str   = {0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF};  
TM1640::DisplayData_t cls_str   = {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  

TM1640 TM1640(p5,p7);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    TM1640.cls(); 
    TM1640.writeData(all_str);
    wait(2);
    TM1640.setBrightness(TM1640_BRT3);    
    wait(1);
    TM1640.setBrightness(TM1640_BRT0);        
    wait(1);
    TM1640.setBrightness(TM1640_BRT4);            
    
    while (1) {
     
      cmd = pc.getc();

      switch cmd {
        case '1' : 
          TM1640.cls(); 
          TM1640.writeData(all_str);
         break;    
               
        case '2' :       
          TM1640.cls(); 
          TM1640.writeData(cls_str);
         break;    
               
        case '3' :

#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          TM1640.cls(); 
         
          for (int i=0; i<TM1640_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              TM1640.cls(); 

              bits = 0x01 << bit;              
              TM1640.writeData(bits, i);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
         break;    
               
        case '4' :
          TM1640.cls(); 
//          TM1640.writeData(hello_str);
         break;    
         
        default : 
          break;          
     
      } //switch cmd

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif
