/* mbed TM1638 Test program, for TM1638 LED controller
 * Copyright (c) 2015, v01: WH, Initial version
 *               2016, v02: WH, Added ASCII alphabet test 
 *               2016, v03: WH, Added QYF-TM1638 and LKM1638, refactoring of writeData() 
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "TM1638.h"

//                          01234567
const char NATO[][9]  = { {"Alpha   "},
                          {"Bravo   "},
                          {"Charlie "},
                          {"Delta   "},
                          {"Echo    "},
                          {"Foxtrot "},
                          {"Golf    "},
                          {"Hotel   "},
                          {"India   "},
                          {"Juliet  "},
                          {"Kilo    "},
                          {"Lima    "},
                          {"Mike    "},
                          {"November"},
                          {"Oscar   "},
                          {"Papa    "},
                          {"Quebec  "},
                          {"Romeo   "},
                          {"Sierra  "},
                          {"Tango   "},
                          {"Uniform "},
                          {"Victor  "},
                          {"Whiskey "},
                          {"X-ray   "},
                          {"Yankee  "},
                          {"Zulu    "}
                        };     


#if (LEDKEY8_TEST == 1)
// LEDKEY8 TM1638 Test
#include "Font_7Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 16 bytes (8 Grids @ 10 Segments) 
TM1638::DisplayData_t all_str   = {0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03};  
TM1638::DisplayData_t cls_str   = {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  
TM1638::DisplayData_t hello_str = {C7_H,0x00, C7_E,0x00, C7_L,0x00, C7_L,0x00, C7_O,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};
TM1638::DisplayData_t bye_str   = {C7_B,0x00, C7_Y,0x00, C7_E,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};

TM1638::DisplayData_t animate[] = {
                                    {S7_A,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, S7_A,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, S7_A,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_A,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_A,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_A,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_A,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_A,0x00},
                                                                                                            
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_B,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_C,0x00},

                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, S7_D,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, S7_D,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {S7_D,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},

                                    {S7_E,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {S7_F,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                  };  
// KeyData_t size is 4 bytes  
TM1638::KeyData_t keydata; 

//TM1638_LEDKEY8 declaration
TM1638_LEDKEY8 LEDKEY8(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    LEDKEY8.cls(); 
    LEDKEY8.writeData(all_str);
    wait(2);
    LEDKEY8.setBrightness(TM1638_BRT3);    
    wait(1);
    LEDKEY8.setBrightness(TM1638_BRT0);        
    wait(1);
    LEDKEY8.setBrightness(TM1638_BRT4);            

    wait(1);
    LEDKEY8.cls(true); 
    LEDKEY8.writeData(hello_str); 
    
    while (1) {
     
      // Check and read keydata
      if (LEDKEY8.getKeys(&keydata)) {
        pc.printf("Keydata 0..3 = 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3]);

        if (keydata[LEDKEY8_SW1_IDX] == LEDKEY8_SW1_BIT) { //sw1  
          LEDKEY8.cls(); 
          LEDKEY8.writeData(all_str);

          wait(0.5);          
          for (int i=0; i<20; i++) {            
            LEDKEY8.writeData(animate[i]);
            wait(0.05);
          }  
        }  

        if (keydata[LEDKEY8_SW2_IDX] == LEDKEY8_SW2_BIT) { //sw2  
          LEDKEY8.cls(); 
//          LEDKEY8.writeData(hello_str);
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          LEDKEY8.cls(); 
         
          for (int i=0; i<TM1638_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              LEDKEY8.cls(); 

              bits = 0x01 << bit;              
              LEDKEY8.writeData(bits, i);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all segs done\r\n");                    
#endif 
          
        }  

        if (keydata[LEDKEY8_SW3_IDX] == LEDKEY8_SW3_BIT) { //sw3  
//          LEDKEY8.cls(); 
//          LEDKEY8.writeData(mbed_str);


#if(1)
//test to show all chars
          pc.printf("Show all NATO Alpha chars\r\n");

          LEDKEY8.cls(); // clear all, preserve Icons
          for (int i=0; i<26; i++) {
            LEDKEY8.locate(0);
            LEDKEY8.printf("%s", NATO[i]);
            wait(0.5);
          }  
          pc.printf("Show all NATO Alpha chars done\r\n");
#endif

#if(0)
//test to show all chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          LEDKEY8.cls(); 
         
          for (int i=0; i<26; i++) {
            LEDKEY8.printf("%c", char(i + 'A'));
//            LEDKEY8.printf("%c", char(i + 'a'));            
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            

#if(0)
//test to show all chars
          pc.printf("Show all chars\r\n");
          wait(1);          
          LEDKEY8.cls(); 

          for (int i=FONT_7S_START; i<FONT_7S_END; i++) {
            LEDKEY8.printf("%c", char(i));
//            wait(0.25);
            cmd = pc.getc(); // wait for key            
          }
          pc.printf("Show all chars done\r\n");                    
#endif            


#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          LEDKEY8.cls(); 

          for (int i=0; i<LEDKEY8_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              LEDKEY8.locate(i);
              LEDKEY8.printf("%0d", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          LEDKEY8.cls(); 

          LEDKEY8.printf("%08x", 0x012345AB);
          cmd = pc.getc(); // wait for key                                     
          LEDKEY8.printf("%08x", 0x00);
                    
          for (int i=0; i<LEDKEY8_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              LEDKEY8.locate(i);
              LEDKEY8.printf("%0x", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  

          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif                
        }

        if (keydata[LEDKEY8_SW4_IDX] == LEDKEY8_SW4_BIT) { //sw4          
//          LEDKEY8.cls(); 
//          LEDKEY8.writeData(mbed_str); 
#if(1)
//test to show all icons
          pc.printf("Show all icons\r\n");
          LEDKEY8.cls(true); // Also clear all Icons
          
          float delay=0.1;
          // Icons on             
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD1); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD2); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD3); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD4); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD5); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD6); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD7); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD8); wait(delay);

          wait(delay);
 
          // Icons off      
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD1); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD2); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD3); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD4); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD5); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD6); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD7); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD8); wait(delay);
                 
//          wait(1);          
//          LEDKEY8.cls(); // clear all, preserve Icons
          pc.printf("Show all icons done\r\n");                    
#endif           
        }       

        if (keydata[LEDKEY8_SW5_IDX] == LEDKEY8_SW5_BIT) { //sw5  
          LEDKEY8.cls(); // clear all, preserve Icons

#if(0)
          LEDKEY8.printf("Count");                            
          for (int cnt=0; cnt<=0xFF; cnt++) {
            LEDKEY8.locate(6);
            LEDKEY8.printf("%02x", cnt);
            wait(0.2);
          }  
#endif


//          LEDKEY8.writeData(hello_str);
          LEDKEY8.printf("hello");                  
        }

        if (keydata[LEDKEY8_SW6_IDX] == LEDKEY8_SW6_BIT) { //sw6  
          LEDKEY8.cls(); // clear all, preserve Icons
//          LEDKEY8.writeData(bye_str);
          LEDKEY8.printf("Bye");          
        }
        
        if (keydata[LEDKEY8_SW7_IDX] == LEDKEY8_SW7_BIT) { //sw7  
          LEDKEY8.cls(); // clear all, preserve Icons
          LEDKEY8.printf("%2.3f", -0.1234);  // test decimal point display                    
          wait(0.5);
          LEDKEY8.cls(); // clear all, preserve Icons          
          LEDKEY8.printf("%2.3f", -012.345);  // test decimal point display
        }
        
        if (keydata[LEDKEY8_SW8_IDX] == LEDKEY8_SW8_BIT) { //sw8  
          float delay=0.1;
          // Icons on             
          LEDKEY8.setIcon(TM1638_LEDKEY8::DP1); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::DP2); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::DP3); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::DP4); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::DP5); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::DP6); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::DP7); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::DP8); wait(delay);

          wait(delay);
 
          // Icons off      
          LEDKEY8.clrIcon(TM1638_LEDKEY8::DP8); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::DP7); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::DP6); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::DP5); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::DP4); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::DP3); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::DP2); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::DP1); wait(delay);          
        }
     
      } //if Key

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif


#if (QYF_TEST == 1)
// QYF TM1638 Test
#include "Font_7Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 16 bytes (8 Grids @ 10 Segments) 
TM1638::DisplayData_t all_str   = {0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03};  
TM1638::DisplayData_t cls_str   = {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  
TM1638::DisplayData_t animate[] = {
                                    {S7_A1,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {S7_A2,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {S7_A3,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {S7_A4,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {S7_A5,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {S7_A6,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {S7_A7,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {S7_A8,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    
                                    {0x00,0x00, S7_B8,0x00,  0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00,  0x00,0x00, S7_C8,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},

                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D8,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D7,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D6,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D5,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D4,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D3,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D2,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D1,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},

                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_E1,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00,  0x00,0x00, S7_F1,0x00, 0x00,0x00, 0x00,0x00},
                                  };  
// KeyData_t size is 4 bytes  
TM1638::KeyData_t keydata; 

//TM1638_QFY declaration
TM1638_QYF QYF(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    QYF.cls(); 
    QYF.writeData(all_str);
    wait(2);
    QYF.setBrightness(TM1638_BRT3);    
    wait(1);
    QYF.setBrightness(TM1638_BRT0);        
    wait(1);
    QYF.setBrightness(TM1638_BRT4);            

    wait(1);
    QYF.cls(true); 
    QYF.printf("Hello"); 
    
    while (1) {
     
      // Check and read keydata
      if (QYF.getKeys(&keydata)) {
        pc.printf("Keydata 0..3 = 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3]);

        if (keydata[QYF_SW1_IDX] == QYF_SW1_BIT) { //sw1  
          QYF.cls(); 
          QYF.writeData(all_str);

          wait(0.5);          
          for (int i=0; i<20; i++) {            
            QYF.writeData(animate[i]);
            wait(0.05);
          }  
        }  

        if (keydata[QYF_SW2_IDX] == QYF_SW2_BIT) { //sw2  
          QYF.cls(); 
//          QYF.writeData(hello_str);
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          QYF.cls(); 
         
          for (int i=0; i<TM1638_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              QYF.cls(); 

              bits = 0x01 << bit;              
              QYF.writeData(bits, i);
              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all segs done\r\n");                    
#endif 
          
        }  

        if (keydata[QYF_SW3_IDX] == QYF_SW3_BIT) { //sw3  
//          QYF.cls(); 

#if(1)
//test to show all NATO alpha chars
          pc.printf("Show all NATO Alpha chars\r\n");

          QYF.cls(); // clear all, preserve Icons
          for (int i=0; i<26; i++) {
            QYF.locate(0);
            QYF.printf("%s", NATO[i]);
            wait(0.5);
          }  
          pc.printf("Show all NATO Alpha chars done\r\n");
#endif

#if(0)
//test to show all alpha chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          QYF.cls(); 
         
          for (int i=0; i<26; i++) {
            QYF.printf("%c", char(i + 'A'));
//            QYF.printf("%c", char(i + 'a'));            
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            

#if(0)
//test to show all chars
          pc.printf("Show all chars\r\n");
          wait(1);          
          QYF.cls(); 

          for (int i=FONT_7S_START; i<FONT_7S_END; i++) {
            QYF.printf("%c", char(i));
//            wait(0.25);
            cmd = pc.getc(); // wait for key            
          }
          pc.printf("Show all chars done\r\n");                    
#endif            


        }

        if (keydata[QYF_SW4_IDX] == QYF_SW4_BIT) { //sw4          

#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          QYF.cls(); 

          for (int i=0; i<QYF_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              QYF.locate(i);
              QYF.printf("%0d", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          QYF.cls(); 

          QYF.printf("%08x", 0x012345AB);
          cmd = pc.getc(); // wait for key                                     
          QYF.printf("%08x", 0x0);          

          for (int i=0; i<QYF_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              QYF.locate(i);
              QYF.printf("%0x", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
           
          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif                          
        }       

        if (keydata[QYF_SW5_IDX] == QYF_SW5_BIT) { //sw5  
          QYF.cls(); // clear all, preserve Icons

#if(1)
          QYF.printf("Count");                            
          for (int cnt=0; cnt<=0xFF; cnt++) {
            QYF.locate(6);
            QYF.printf("%02x", cnt);
            wait(0.2);
          }  
#endif
        }

        if (keydata[QYF_SW6_IDX] == QYF_SW6_BIT) { //sw6  
          QYF.cls(); // clear all, preserve Icons
          QYF.printf("%2.3f", -0.1234);  // test decimal point display                    
          wait(0.5);
          QYF.cls(); // clear all, preserve Icons          
          QYF.printf("%2.3f", -012.345);  // test decimal point display
        }
        
        if (keydata[QYF_SW7_IDX] == QYF_SW7_BIT) { //sw7  
          float delay=0.1;
          // Icons on             
          QYF.setIcon(TM1638_QYF::DP1); wait(delay);
          QYF.setIcon(TM1638_QYF::DP2); wait(delay);
          QYF.setIcon(TM1638_QYF::DP3); wait(delay);
          QYF.setIcon(TM1638_QYF::DP4); wait(delay);
          QYF.setIcon(TM1638_QYF::DP5); wait(delay);
          QYF.setIcon(TM1638_QYF::DP6); wait(delay);
          QYF.setIcon(TM1638_QYF::DP7); wait(delay);
          QYF.setIcon(TM1638_QYF::DP8); wait(delay);

          wait(delay);
 
          // Icons off      
          QYF.clrIcon(TM1638_QYF::DP8); wait(delay);
          QYF.clrIcon(TM1638_QYF::DP7); wait(delay);
          QYF.clrIcon(TM1638_QYF::DP6); wait(delay);
          QYF.clrIcon(TM1638_QYF::DP5); wait(delay);
          QYF.clrIcon(TM1638_QYF::DP4); wait(delay);
          QYF.clrIcon(TM1638_QYF::DP3); wait(delay);
          QYF.clrIcon(TM1638_QYF::DP2); wait(delay);
          QYF.clrIcon(TM1638_QYF::DP1); wait(delay);          
        }

        if (keydata[QYF_SW8_IDX] == QYF_SW8_BIT) { //sw8  
          QYF.cls(); 
          QYF.printf("Hello");                
        }
        
        if (keydata[QYF_SW9_IDX] == QYF_SW9_BIT) { //sw9  
          QYF.cls(); // clear all, preserve Icons
          QYF.printf("Bye");          
        }
     
      } //if Key

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif


#if (LKM1638_TEST == 1)
// LKM1638 TM1638 Test
#include "Font_7Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 16 bytes (8 Grids @ 10 Segments) 
TM1638::DisplayData_t all_str   = {0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03};  
TM1638::DisplayData_t cls_str   = {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  
TM1638::DisplayData_t hello_str = {C7_H,0x00, C7_E,0x00, C7_L,0x00, C7_L,0x00, C7_O,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};
TM1638::DisplayData_t bye_str   = {C7_B,0x00, C7_Y,0x00, C7_E,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};

TM1638::DisplayData_t animate[] = {
                                    {S7_A,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, S7_A,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, S7_A,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_A,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_A,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_A,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_A,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_A,0x00},
                                                                                                            
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_B,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_C,0x00},

                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, 0x00,0x00, S7_D,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, 0x00,0x00, S7_D,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {0x00,0x00, S7_D,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {S7_D,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},

                                    {S7_E,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                    {S7_F,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00},
                                  };  
// KeyData_t size is 4 bytes  
TM1638::KeyData_t keydata; 

//TM1638_LKM1638 declaration
TM1638_LKM1638 LKM1638(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    LKM1638.cls(); 
    LKM1638.writeData(all_str);
    wait(2);
    LKM1638.setBrightness(TM1638_BRT3);    
    wait(1);
    LKM1638.setBrightness(TM1638_BRT0);        
    wait(1);
    LKM1638.setBrightness(TM1638_BRT4);            

    wait(1);
    LKM1638.cls(true); 
    LKM1638.writeData(hello_str); 
   
    while (1) {
     
      // Check and read keydata
      if (LKM1638.getKeys(&keydata)) {
        pc.printf("Keydata 0..3 = 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3]);
        
        if (keydata[LKM1638_SW1_IDX] == LKM1638_SW1_BIT) { //sw1  
          LKM1638.cls(); 
          LKM1638.writeData(all_str);

          wait(0.5);          
          for (int i=0; i<20; i++) {            
            LKM1638.writeData(animate[i]);
            wait(0.05);
          }  
        }  

        if (keydata[LKM1638_SW2_IDX] == LKM1638_SW2_BIT) { //sw2  
          LKM1638.cls(); 
//          LKM1638.writeData(hello_str);
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          LKM1638.cls(); 
         
          for (int i=0; i<TM1638_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              LKM1638.cls(); 

              bits = 0x01 << bit;              
              LKM1638.writeData(bits, i);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all segs done\r\n");                    
#endif 
          
        }  

        if (keydata[LKM1638_SW3_IDX] == LKM1638_SW3_BIT) { //sw3  
//          LKM1638.cls(); 
//          LKM1638.writeData(mbed_str);


#if(1)
//test to show all chars
          pc.printf("Show all NATO Alpha chars\r\n");

          LKM1638.cls(); // clear all, preserve Icons
          for (int i=0; i<26; i++) {
            LKM1638.locate(0);
            LKM1638.printf("%s", NATO[i]);
            wait(0.5);
          }  
          pc.printf("Show all NATO Alpha chars done\r\n");
#endif

#if(0)
//test to show all chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          LKM1638.cls(); 
         
          for (int i=0; i<26; i++) {
            LKM1638.printf("%c", char(i + 'A'));
//            LKM1638.printf("%c", char(i + 'a'));            
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            

#if(0)
//test to show all chars
          pc.printf("Show all chars\r\n");
          wait(1);          
          LKM1638.cls(); 

          for (int i=FONT_7S_START; i<FONT_7S_END; i++) {
            LKM1638.printf("%c", char(i));
//            wait(0.25);
            cmd = pc.getc(); // wait for key            
          }
          pc.printf("Show all chars done\r\n");                    
#endif            


#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          LKM1638.cls(); 

          for (int i=0; i<LKM1638_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              LKM1638.locate(i);
              LKM1638.printf("%0d", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          LKM1638.cls(); 

          LKM1638.printf("%08x", 0x012345AB);
          cmd = pc.getc(); // wait for key                                     
          LKM1638.printf("%08x", 0x00);
                    
          for (int i=0; i<LKM1638_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              LKM1638.locate(i);
              LKM1638.printf("%0x", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  

          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif                
        }

        if (keydata[LKM1638_SW4_IDX] == LKM1638_SW4_BIT) { //sw4          
//          LKM1638.cls(); 
//          LKM1638.writeData(mbed_str); 
#if(1)
//test to show all icons
          pc.printf("Show all icons\r\n");
          LKM1638.cls(true); // Also clear all Icons
          
          float delay=0.1;
          // Icons on             
          LKM1638.setIcon(TM1638_LKM1638::RD1); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::RD2); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::RD3); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::RD4); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::RD5); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::RD6); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::RD7); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::RD8); wait(delay);

          wait(delay);
 
          // Icons off      
          LKM1638.clrIcon(TM1638_LKM1638::RD1); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::RD2); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::RD3); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::RD4); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::RD5); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::RD6); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::RD7); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::RD8); wait(delay);
                 
          wait(delay);
          
          // Icons on             
          LKM1638.setIcon(TM1638_LKM1638::GR1); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::GR2); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::GR3); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::GR4); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::GR5); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::GR6); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::GR7); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::GR8); wait(delay);

          wait(delay);
 
          // Icons off      
          LKM1638.clrIcon(TM1638_LKM1638::GR1); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::GR2); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::GR3); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::GR4); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::GR5); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::GR6); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::GR7); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::GR8); wait(delay);

          wait(delay);
          
          // Icons on             
          LKM1638.setIcon(TM1638_LKM1638::YL1); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::YL2); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::YL3); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::YL4); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::YL5); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::YL6); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::YL7); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::YL8); wait(delay);

          wait(delay);
 
          // Icons off 
          // Note: Yellow is hardly recognisable. Red LED is much brighter than Green
          LKM1638.clrIcon(TM1638_LKM1638::YL1); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::YL2); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::YL3); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::YL4); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::YL5); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::YL6); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::YL7); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::YL8); wait(delay);

//          wait(1);          
//          LKM1638.cls(); // clear all, preserve Icons
          pc.printf("Show all icons done\r\n");                    
#endif           
        }       

        if (keydata[LKM1638_SW5_IDX] == LKM1638_SW5_BIT) { //sw5  
          LKM1638.cls(); // clear all, preserve Icons

#if(0)
          LKM1638.printf("Count");                            
          for (int cnt=0; cnt<=0xFF; cnt++) {
            LKM1638.locate(6);
            LKM1638.printf("%02x", cnt);
            wait(0.2);
          }  
#endif


//          LKM1638.writeData(hello_str);
          LKM1638.printf("hello");                  
        }

        if (keydata[LKM1638_SW6_IDX] == LKM1638_SW6_BIT) { //sw6  
          LKM1638.cls(); // clear all, preserve Icons
//          LKM1638.writeData(bye_str);
          LKM1638.printf("Bye");          
        }
        
        if (keydata[LKM1638_SW7_IDX] == LKM1638_SW7_BIT) { //sw7  
          LKM1638.cls(); // clear all, preserve Icons
          LKM1638.printf("%2.3f", -0.1234);  // test decimal point display                    
          wait(0.5);
          LKM1638.cls(); // clear all, preserve Icons          
          LKM1638.printf("%2.3f", -012.345);  // test decimal point display
        }
        
        if (keydata[LKM1638_SW8_IDX] == LKM1638_SW8_BIT) { //sw8  
          float delay=0.1;
          // Icons on             
          LKM1638.setIcon(TM1638_LKM1638::DP1); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::DP2); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::DP3); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::DP4); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::DP5); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::DP6); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::DP7); wait(delay);
          LKM1638.setIcon(TM1638_LKM1638::DP8); wait(delay);

          wait(delay);
 
          // Icons off      
          LKM1638.clrIcon(TM1638_LKM1638::DP8); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::DP7); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::DP6); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::DP5); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::DP4); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::DP3); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::DP2); wait(delay);
          LKM1638.clrIcon(TM1638_LKM1638::DP1); wait(delay);          
        }
     
      } //if Key

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif



#if (TM1638_TEST == 1)
// Direct TM1638 Test

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 16 bytes (8 Grids @ 10 Segments) 
TM1638::DisplayData_t all_str   = {0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03};  
TM1638::DisplayData_t cls_str   = {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  

// KeyData_t size is 4 bytes  
TM1638::KeyData_t keydata; 

TM1638 TM1638(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    TM1638.cls(); 
    TM1638.writeData(all_str);
    wait(2);
    TM1638.setBrightness(TM1638_BRT3);    
    wait(1);
    TM1638.setBrightness(TM1638_BRT0);        
    wait(1);
    TM1638.setBrightness(TM1638_BRT4);            
    
    while (1) {
     
      // Check and read keydata
      if (TM1638.getKeys(&keydata)) {
        pc.printf("Keydata 0..3 = 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3]);

        if (keydata[0] == 0x01) { //sw1
          TM1638.cls(); 
          TM1638.writeData(all_str);
        }  

        if (keydata[1] == 0x01) { //sw2   
          TM1638.cls(); 
          TM1638.writeData(cls_str);
        }  


        if (keydata[2] == 0x01) { //sw3   
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          TM1638.cls(); 
         
          for (int i=0; i<TM1638_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              TM1638.cls(); 

              bits = 0x01 << bit;              
              TM1638.writeData(bits, i);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
        }            

        if (keydata[3] == 0x01) { //sw4
          TM1638.cls(); 
//          TM1638.writeData(hello_str);
        }  

       
      } //if Key

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif
