/* mbed TM1638 Test program, for TM1628 LED controller
 * Copyright (c) 2015, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "TM1638.h"

#if (LEDKEY8_TEST == 1)
// LEDKEY8 TM1638 Test
#include "Font_7Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 16 bytes (8 Grids @ 10 Segments) 
TM1638::DisplayData_t all_str   = {0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03};  
TM1638::DisplayData_t cls_str   = {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  
TM1638::DisplayData_t hello_str = {C7_H,0x00, C7_E,0x00, C7_L,0x00, C7_L,0x00, C7_O,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};

// KeyData_t size is 3 bytes  
TM1638::KeyData_t keydata; 

// Switchdata is 1 byte  
char switchdata; 

//TM1638_LEDKEY8 declaration
TM1638_LEDKEY8 LEDKEY8(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    LEDKEY8.cls(); 
    LEDKEY8.writeData(all_str);
    wait(2);
    LEDKEY8.setBrightness(TM1638_BRT3);    
    wait(1);
    LEDKEY8.setBrightness(TM1638_BRT0);        
    wait(1);
    LEDKEY8.setBrightness(TM1638_BRT4);            

    wait(1);
    LEDKEY8.cls(true); 
    LEDKEY8.writeData(hello_str); 
    
    while (1) {
     
      // Check and read keydata
      if (LEDKEY8.getKeys(&keydata)) {
        pc.printf("Keydata 0..3 = 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3]);

        if (keydata[0] == 0x01) { //sw1  
          LEDKEY8.cls(); 
          LEDKEY8.writeData(all_str);
        }  

        if (keydata[1] == 0x01) { //sw2  
          LEDKEY8.cls(); 
//          LEDKEY8.writeData(hello_str);
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          LEDKEY8.cls(); 
         
          for (int i=0; i<TM1638_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              LEDKEY8.cls(); 

              bits = 0x01 << bit;              
              LEDKEY8.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
          
        }  


        if (keydata[2] == 0x01) { //sw3   
//          LEDKEY8.cls(); 
//          LEDKEY8.writeData(mbed_str);

#if(0)
//test to show all chars
          pc.printf("Show all chars\r\n");
          wait(1);          
          LEDKEY8.cls(); 
         
          for (int i=0; i<26; i++) {
            LEDKEY8.writeData(0, FONT_16S[i][0]);
            LEDKEY8.writeData(1, FONT_16S[i][1]);
            wait(1);                      
          }
          pc.printf("Show all chars done\r\n");                    
#endif            


#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          LEDKEY8.cls(); 

          int val = 1; 
          for (int i=0; i<LEDKEY8_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              LEDKEY8.locate(0);
              LEDKEY8.printf("%07d", (val * cnt));

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 10;
          }
          pc.printf("Show all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          LEDKEY8.cls(); 

          LEDKEY8.printf("%08x", 0x012345AB);
          cmd = pc.getc(); // wait for key                                     
          
          int val = 1; 
          for (int i=0; i<LEDKEY8_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              LEDKEY8.locate(0);
              LEDKEY8.printf("%08x", (val * cnt));

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 0x10;
          }
          pc.printf("Show all hex digits done\r\n");          
#endif                
        }
        
        if (keydata[3] == 0x01) { //sw4   
//          LEDKEY8.cls(); 
//          LEDKEY8.writeData(mbed_str); 
#if(1)
//test to show all icons
          pc.printf("Show all icons\r\n");
          wait(1);          
          LEDKEY8.cls(true); // Also clear all Icons
          wait(1);          
          
          float delay=0.1;
          // Icons on             
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD1); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD2); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD3); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD4); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD5); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD6); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD7); wait(delay);
          LEDKEY8.setIcon(TM1638_LEDKEY8::LD8); wait(delay);

          wait(delay);
 
          // Icons off      
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD1); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD2); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD3); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD4); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD5); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD6); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD7); wait(delay);
          LEDKEY8.clrIcon(TM1638_LEDKEY8::LD8); wait(delay);
                 
//          wait(1);          
//          LEDKEY8.cls(); // clear all, preserve Icons         
          pc.printf("Show all icons done\r\n");                    
#endif           
        }       

        if (keydata[0] == 0x10) { //sw5   
        }

        if (keydata[1] == 0x10) { //sw6   
        }
        
        if (keydata[2] == 0x10) { //sw7   
        }
        
        if (keydata[3] == 0x10) { //sw8   
        }
     
      } //if Key

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif



#if (TM1638_TEST == 1)
// Direct TM1638 Test

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 16 bytes (8 Grids @ 10 Segments) 
TM1638::DisplayData_t all_str   = {0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03, 0xFF,0x03};  
TM1638::DisplayData_t cls_str   = {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  

// KeyData_t size is 4 bytes  
TM1638::KeyData_t keydata; 

TM1638 TM1638(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    TM1638.cls(); 
    TM1638.writeData(all_str);
    wait(2);
    TM1638.setBrightness(TM1638_BRT3);    
    wait(1);
    TM1638.setBrightness(TM1638_BRT0);        
    wait(1);
    TM1638.setBrightness(TM1638_BRT4);            
    
    while (1) {
     
      // Check and read keydata
      if (TM1638.getKeys(&keydata)) {
        pc.printf("Keydata 0..3 = 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3]);

        if (keydata[0] == 0x01) { //sw1
          TM1638.cls(); 
          TM1638.writeData(all_str);
        }  

        if (keydata[1] == 0x01) { //sw2   
          TM1638.cls(); 
          TM1638.writeData(cls_str);
        }  


        if (keydata[2] == 0x01) { //sw3   
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          TM1638.cls(); 
         
          for (int i=0; i<TM1638_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              TM1638.cls(); 

              bits = 0x01 << bit;              
              TM1638.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
        }            

        if (keydata[3] == 0x01) { //sw4
          TM1638.cls(); 
//          TM1638.writeData(hello_str);
        }  

       
      } //if Key

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif
