/* mbed STLED316S Test program, for STLED316S LED controller
 * Copyright (c) 2016, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "STLED316S.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// Select one of the testboards for STM STLED316S LED controller

#if (STLED316S_TEST == 1)
//High level Control STLED316S

STLED316S::DisplayData_t all_str  = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};  
STLED316S::DisplayData_t bye_str  = {LO(C7_B), LO(C7_Y), LO(C7_E), 0x00, 0x00, 0x00};
STLED316S::LedData_t all_led  = {0xFF};  

// KeyData_t size is 2 bytes  
STLED316S::KeyData_t keydata; 

// STLED316S declaration, Default setting 6 Grids @ 8 Segments
STLED316S STLED316S(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    STLED316S.cls(); 
    STLED316S.writeData(all_str);
    STLED316S.writeLedData(all_led);    
    wait(2);

#if(1)
    pc.printf("Test Global Brightness\r\n");
    STLED316S.setBrightMode(STLED316S::GlobalBright);
        
    STLED316S.setBrightness(STLED316S_BRT3);    
    wait(1);
    STLED316S.setBrightness(STLED316S_BRT0);        
    wait(1);
    STLED316S.setBrightness(STLED316S_BRT3);            

    STLED316S.clrLed(STLED316S_LED_ALL);
    wait(1);
    STLED316S.setLed(STLED316S_LED_L1);
    wait(1);
    STLED316S.clrLed(STLED316S_LED_L1);

    STLED316S.setLed(STLED316S_LED_L2);
    wait(1);
    STLED316S.clrLed(STLED316S_LED_L2);

    STLED316S.setLed(STLED316S_LED_L3);
    wait(1);
    STLED316S.clrLed(STLED316S_LED_L3);

    wait(1);
    STLED316S.setLed(STLED316S_LED_L1 | STLED316S_LED_L2 | STLED316S_LED_L3);
#endif

    while (1) {     
      // Check and read keydata
      if (STLED316S.getKeys(&keydata)) {
        pc.printf("Keydata 0..1 = 0x%02X 0x%02X\r\n", keydata[0], keydata[1]);

        if (keydata[0] == 0x01) { // Key1&KS1  
            pc.printf("Test Individual Brightness\r\n");
            STLED316S.setBrightMode(STLED316S::IndivBright);    
    
            wait(1);
            STLED316S.setLedBrightness(STLED316S_LED_L1, STLED316S_BRT3); 
            wait(1);
            STLED316S.setLedBrightness(STLED316S_LED_L1, STLED316S_BRT0); 
            
            wait(1);
            STLED316S.setLedBrightness(STLED316S_LED_L2, STLED316S_BRT3); 
            wait(1);
            STLED316S.setLedBrightness(STLED316S_LED_L2, STLED316S_BRT0); 

            wait(1);
            STLED316S.setLedBrightness(STLED316S_LED_L3, STLED316S_BRT3); 
            wait(1);
            STLED316S.setLedBrightness(STLED316S_LED_L3, STLED316S_BRT0); 

            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D2, STLED316S_BRT3); 
            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D2, STLED316S_BRT0); 
            
            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D3, STLED316S_BRT3); 
            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D3, STLED316S_BRT0); 

            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D4, STLED316S_BRT3); 
            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D4, STLED316S_BRT0); 

            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D5, STLED316S_BRT3); 
            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D5, STLED316S_BRT0); 
            
            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D6, STLED316S_BRT3); 
            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D6, STLED316S_BRT0); 

            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D7, STLED316S_BRT3); 
            wait(1);
            STLED316S.setDigitBrightness(STLED316S_DIG_D7, STLED316S_BRT0); 

            wait(1);            
            STLED316S.setBrightMode(STLED316S::GlobalBright);            
        }       

        if (keydata[0] == 0x02) { // Key1&KS2  
          STLED316S.cls(); 
        }  

        if (keydata[0] == 0x04) { // Key1&KS3  
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          STLED316S.cls(); 
         
          for (int i=0; i<STLED316S_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              STLED316S.cls(); 

              bits = 0x01 << bit;              
              STLED316S.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");  
          wait(0.5);          
          STLED316S.writeData(all_str);                            
#endif         
        }       

        
      } //if

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif



#if (ST316BOARD_TEST == 1)
//High level Control STLED316S test display

STLED316S::DisplayData_t all_str  = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};  
STLED316S::DisplayData_t bye_str  = {LO(C7_B), LO(C7_Y), LO(C7_E), 0x00, 0x00, 0x00};
STLED316S::LedData_t all_led  = {0xFF};  

// KeyData_t size is 2 bytes  
STLED316S::KeyData_t keydata; 

// STLED316S test display declaration: 6 Grids @ 8 Segments, 3 LEDs, 3 Keys
STLED316S_BOARD STLED316S(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    STLED316S.cls(); 
    STLED316S.writeData(all_str);
    STLED316S.writeLedData(all_led);    
    wait(2);

#if(1)
    pc.printf("Test Global Brightness\r\n");
    STLED316S.setBrightMode(STLED316S::GlobalBright);
        
    STLED316S.setBrightness(STLED316S_BRT3);    
    wait(0.5);
    STLED316S.setBrightness(STLED316S_BRT0);        
    wait(0.5);
    STLED316S.setBrightness(STLED316S_BRT3);            

    STLED316S.clrLed(STLED316S_LED_ALL);
    wait(0.5);
    STLED316S.setLed(STLED316S_LED_L1);
    wait(0.5);
    STLED316S.clrLed(STLED316S_LED_L1);

    STLED316S.setLed(STLED316S_LED_L2);
    wait(0.5);
    STLED316S.clrLed(STLED316S_LED_L2);

    STLED316S.setLed(STLED316S_LED_L3);
    wait(0.5);
    STLED316S.clrLed(STLED316S_LED_L3);

    wait(0.5);
    STLED316S.setLed(STLED316S_LED_L1 | STLED316S_LED_L2 | STLED316S_LED_L3);
#endif

    while (1) {     
      // Check and read keydata
      if (STLED316S.getKeys(&keydata)) {
        pc.printf("Keydata 0..1 = 0x%02X 0x%02X\r\n", keydata[0], keydata[1]);

        if (keydata[0] == 0x01) { // Key1&KS1  
            pc.printf("Test Individual Brightness\r\n");
            STLED316S.setBrightMode(STLED316S::IndivBright);    
    
            wait(1);
            STLED316S.setLedBrightness(STLED316S_LED_L1, STLED316S_BRT3); 
            wait(0.5);
            STLED316S.setLedBrightness(STLED316S_LED_L1, STLED316S_BRT0); 
            
            wait(0.5);
            STLED316S.setLedBrightness(STLED316S_LED_L2, STLED316S_BRT3); 
            wait(0.5);
            STLED316S.setLedBrightness(STLED316S_LED_L2, STLED316S_BRT0); 

            wait(0.5);
            STLED316S.setLedBrightness(STLED316S_LED_L3, STLED316S_BRT3); 
            wait(0.5);
            STLED316S.setLedBrightness(STLED316S_LED_L3, STLED316S_BRT0); 

            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D2, STLED316S_BRT3); 
            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D2, STLED316S_BRT0); 
            
            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D3, STLED316S_BRT3); 
            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D3, STLED316S_BRT0); 

            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D4, STLED316S_BRT3); 
            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D4, STLED316S_BRT0); 

            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D5, STLED316S_BRT3); 
            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D5, STLED316S_BRT0); 
            
            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D6, STLED316S_BRT3); 
            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D6, STLED316S_BRT0); 

            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D7, STLED316S_BRT3); 
            wait(0.5);
            STLED316S.setDigitBrightness(STLED316S_DIG_D7, STLED316S_BRT0); 

            wait(0.5);            
            STLED316S.setBrightMode(STLED316S::GlobalBright);            
        }       

        if (keydata[0] == 0x02) { // Key1&KS2  
          STLED316S.cls();

          STLED316S.locate(0);
          STLED316S.printf("%06x", 0x012345);
          wait(1.0);
          STLED316S.locate(0);
          STLED316S.printf("%06x", 0x789ABC);
          wait(1.0);
          STLED316S.printf("%01.4f", -0.2345);

          wait(2.0);
          STLED316S.printf("Hello ");
        }  

        if (keydata[0] == 0x04) { // Key1&KS3  
#if(0)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          STLED316S.cls(); 
         
          for (int i=0; i<STLED316S_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              STLED316S.cls(); 

              bits = 0x01 << bit;              
              STLED316S.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");  
          wait(0.5);          
          STLED316S.writeData(all_str);                            
#else         
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          STLED316S.cls(); 

          STLED316S.printf("%06x", 0x01ABCD);
          cmd = pc.getc(); // wait for key                                     
          
          for (int i=0; i<ST316BOARD_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              STLED316S.locate(i);
              STLED316S.printf("%01x", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif 
        }       
        
      } //if

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif



