
#include "mbed.h"
#include "SDA5708.h"

// mbed Interface Hardware definitions
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut heartbeatLED(LED4);

// Host PC Communication channels
Serial pc(USBTX, USBRX);

// SPI Communication
SPI spi_led(p5, NC, p7); // MOSI, MISO, SCLK

//Display
SDA5708 led(&spi_led, p8, p9); // SPI bus, CS pin, RST pin

// Variables for Heartbeat and Status monitoring
Ticker heartbeat;
bool heartbeatflag=false;

// Heartbeat monitor
void pulse() {
  heartbeatLED = !heartbeatLED;
}

void heartbeat_start() {
  heartbeat.attach(&pulse, 0.5);
  heartbeatflag = true;
}

void heartbeat_stop() {
  heartbeat.detach();
  heartbeatflag = false;
}

int main() {
  int cnt;
  
  heartbeat_start();

  led.locate(0, 0);                               

//led.printf("*=%6d", 123456);
//            12345678 
  led.printf("Hi mbed ");  
  wait(2);

  led.setUDC(0, (char *) udc_0);
  led.setUDC(1, (char *) udc_1);
  led.setUDC(2, (char *) udc_2);
  led.setUDC(3, (char *) udc_3);
  led.setUDC(4, (char *) udc_Bat_Hi);
  led.setUDC(5, (char *) udc_Bat_Ha);
  led.setUDC(6, (char *) udc_Bat_Lo);
//  led.setUDC(7, (char *) udc_smiley);
  led.setUDC(7, (char *) udc_AC);  
  
  led.putc(0);
  led.putc(1);
  led.putc(2);
  led.putc(3);
  led.putc(4);
  led.putc(5);
  led.putc(6);
  led.putc(7);            
  wait(2);
                
//  while(1) {}
  
  cnt=0x20;  
  while(1) {
    wait(0.5);
                        
    led.putc(cnt);
    cnt++;
    if (cnt == 0x80) cnt=0x20;
  }
  
}
