/* mbed PT6961 Test program, for Princeton PT6961 LED controller
 * Copyright (c) 2015, v01: WH, Initial version PT6961 (HR734)
 *               2016, v02: WH, Added V56S, Added Stream support
 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "PT6961.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

#if(HR734_TEST == 1)
//Test on HR734 display

#include "Font_7Seg.h"
  
// DisplayData_t size is 14 bytes (7 grids @ 11 segments) 
PT6961::DisplayData_t mbed_str = {0xDA,0x00, 0x7C,0x00, 0x3C,0x01, 0xF6,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  
PT6961::DisplayData_t all_str  = {0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F};  
PT6961::DisplayData_t hello_str = {LO(C7_H),HI(C7_H), LO(C7_E),HI(C7_E), LO(C7_L),HI(C7_L), LO(C7_L),HI(C7_L), LO(C7_O),HI(C7_O), 0x00,0x00, 0x00,0x00};
PT6961::DisplayData_t bye_str   = {LO(C7_B),HI(C7_B), LO(C7_Y),HI(C7_Y), LO(C7_E),HI(C7_E), 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};
//PT6961::DisplayData_t tst_str;  

// KeyData_t size is 5 bytes  
PT6961::KeyData_t keydata; 

// PT6191_HR734 declaration, Setting 7 Grids @ 11 Segments
PT6961_HR734 pt6961_hr734(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    pt6961_hr734.cls(); 
    pt6961_hr734.writeData(all_str);
    wait(4);
    pt6961_hr734.setBrightness(PT6961_BRT3);    
    pt6961_hr734.writeData(mbed_str);    
    wait(1);
    pt6961_hr734.setBrightness(PT6961_BRT0);        
    wait(1);
    pt6961_hr734.setBrightness(PT6961_BRT3);            
    
    while (1) {
     
      // Check and read keydata
      if (pt6961_hr734.getKeys(&keydata)) {
        pc.printf("Keydata 0..4 = 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3], keydata[4]);

        if (keydata[0] == 0x10) { //sw2 FF
          pt6961_hr734.cls(); 
          pt6961_hr734.writeData(all_str);
        }  

        if (keydata[0] == 0x02) { //sw8 Play
          pt6961_hr734.cls(); 
          pt6961_hr734.writeData(hello_str);
//          pt6961_hr734.printf("Hello");
        }  

        if (keydata[0] == 0x20) { //sw6 Stop
          pt6961_hr734.cls(); 
          pt6961_hr734.writeData(mbed_str);
        }       

        if (keydata[1] == 0x02) { //sw4 Rew
          pt6961_hr734.cls(); 
          pt6961_hr734.writeData(bye_str);
//          pt6961_hr734.printf("Bye");
        }       

        if (keydata[0] == 0x04) { //sw11 Rec
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          pt6961_hr734.cls(); 
         
          for (int i=0; i<PT6961_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              pt6961_hr734.cls(); 

              bits = 0x01 << bit;              
              pt6961_hr734.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif         
        }       

        if (keydata[0] == 0x08) { //sw10   Ch-
#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          pt6961_hr734.cls(); 

          pt6961_hr734.printf("%05x", 0x012AB);
          cmd = pc.getc(); // wait for key                                     
          
          int val = 1; 
          for (int i=0; i<HR734_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              pt6961_hr734.locate(0);
              pt6961_hr734.printf("%05x", (val * cnt));

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 0x10;
          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif 
        }       

        if (keydata[1] == 0x01) { //sw9 Ch+
          float delay = 0.2;

          pt6961_hr734.cls(); 
          pt6961_hr734.setIcon(PT6961_HR734::RA); wait(delay);
          pt6961_hr734.setIcon(PT6961_HR734::M); wait(delay);
          pt6961_hr734.setIcon(PT6961_HR734::ARW); wait(delay);          
          pt6961_hr734.setIcon(PT6961_HR734::HDDDVD_HD); wait(delay);          
          pt6961_hr734.setIcon(PT6961_HR734::HDDDVD_D); wait(delay);          
          pt6961_hr734.setIcon(PT6961_HR734::HDDDVD_VD); wait(delay);          
          pt6961_hr734.setIcon(PT6961_HR734::DP2); wait(delay);
          pt6961_hr734.setIcon(PT6961_HR734::DP1); wait(delay);
          pt6961_hr734.setIcon(PT6961_HR734::R); wait(delay);
          pt6961_hr734.setIcon(PT6961_HR734::W); wait(delay);
          pt6961_hr734.setIcon(PT6961_HR734::SO); wait(delay);
          pt6961_hr734.setIcon(PT6961_HR734::P); wait(delay);
          pt6961_hr734.setIcon(PT6961_HR734::CLK); wait(delay);
          pt6961_hr734.setIcon(PT6961_HR734::BRK); wait(delay);
          pt6961_hr734.setIcon(PT6961_HR734::DP4); wait(delay);
          pt6961_hr734.setIcon(PT6961_HR734::DP3); wait(delay);
          wait(delay);                              
          pt6961_hr734.clrIcon(PT6961_HR734::RA); wait(delay);
          pt6961_hr734.clrIcon(PT6961_HR734::M); wait(delay);
          pt6961_hr734.clrIcon(PT6961_HR734::ARW); wait(delay);          
          pt6961_hr734.clrIcon(PT6961_HR734::HDDDVD_HD); wait(delay);          
          pt6961_hr734.clrIcon(PT6961_HR734::HDDDVD_D); wait(delay);          
          pt6961_hr734.clrIcon(PT6961_HR734::HDDDVD_VD); wait(delay);          
          pt6961_hr734.clrIcon(PT6961_HR734::DP2); wait(delay);
          pt6961_hr734.clrIcon(PT6961_HR734::DP1); wait(delay);
          pt6961_hr734.clrIcon(PT6961_HR734::R); wait(delay);
          pt6961_hr734.clrIcon(PT6961_HR734::W); wait(delay);
          pt6961_hr734.clrIcon(PT6961_HR734::SO); wait(delay);
          pt6961_hr734.clrIcon(PT6961_HR734::P); wait(delay);
          pt6961_hr734.clrIcon(PT6961_HR734::CLK); wait(delay);
          pt6961_hr734.clrIcon(PT6961_HR734::BRK); wait(delay);
          pt6961_hr734.clrIcon(PT6961_HR734::DP4); wait(delay);
          pt6961_hr734.clrIcon(PT6961_HR734::DP3); wait(delay);         
        }       

        if (keydata[0] == 0x01) { //sw7   
          pt6961_hr734.cls(); 
          
        }       

        if (keydata[1] == 0x04) { //sw12 HDD   
          pt6961_hr734.cls(); 
          pt6961_hr734.printf("%5d", -1234);          
        }       
        
        if (keydata[1] == 0x10) { //sw13 DVD   
          pt6961_hr734.cls(); 
          pt6961_hr734.printf("%05d", 1234);
        }       

        
      } //if

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif


#if(V56S_TEST == 1)
//Test on V56S display

#include "Font_7Seg.h"
  
// DisplayData_t size is 14 bytes (7 grids @ 11 segments) 
PT6961::DisplayData_t mbed_str = {0xDA,0x00, 0x7C,0x00, 0x3C,0x01, 0xF6,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  
PT6961::DisplayData_t all_str  = {0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F};  
PT6961::DisplayData_t hello_str = {LO(C7_H),HI(C7_H), LO(C7_E),HI(C7_E), LO(C7_L),HI(C7_L), LO(C7_L),HI(C7_L), LO(C7_O),HI(C7_O), 0x00,0x00, 0x00,0x00};
PT6961::DisplayData_t bye_str   = {LO(C7_B),HI(C7_B), LO(C7_Y),HI(C7_Y), LO(C7_E),HI(C7_E), 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};
//PT6961::DisplayData_t tst_str;  

// KeyData_t size is 5 bytes  
PT6961::KeyData_t keydata; 

// PT6191_V56S declaration, Setting 7 Grids @ 11 Segments
PT6961_V56S pt6961_v56s(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    pt6961_v56s.cls(); 
    pt6961_v56s.writeData(all_str);
    wait(4);
    pt6961_v56s.setBrightness(PT6961_BRT3);    
    pt6961_v56s.writeData(hello_str);    
    wait(1);
    pt6961_v56s.setBrightness(PT6961_BRT0);        
    wait(1);
    pt6961_v56s.setBrightness(PT6961_BRT3);            
    
    while (1) {
     
      // Check and read keydata
      if (pt6961_v56s.getKeys(&keydata)) {
        pc.printf("Keydata 0..4 = 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3], keydata[4]);

        if (keydata[0] == 0x01) { //sw5
          pt6961_v56s.cls(); 
          pt6961_v56s.writeData(all_str);
        }  

        if (keydata[0] == 0x02) { //sw1
          pt6961_v56s.cls(); 
          pt6961_v56s.writeData(hello_str);
//          pt6961_v56s.printf("Hello");
//          pt6961_v56s.writeData(mbed_str);
//          pt6961_v56s.writeData(bye_str);
        }  

        if (keydata[0] == 0x08) { //sw6
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          pt6961_v56s.cls(); 
         
          for (int i=0; i<PT6961_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              pt6961_v56s.cls(); 

              bits = 0x01 << bit;              
              pt6961_v56s.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif         
        }       

        if (keydata[0] == 0x10) { //sw2
#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          pt6961_v56s.cls(); 

          pt6961_v56s.printf("%05x", 0x012AB);
          cmd = pc.getc(); // wait for key                                     
          
          int val = 1; 
          for (int i=0; i<V56S_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              pt6961_v56s.locate(0);
              pt6961_v56s.printf("%05x", (val * cnt));

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 0x10;
          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif 
        }       

        if (keydata[1] == 0x02) { //sw3
          float delay = 0.2;

          pt6961_v56s.cls(); 
          pt6961_v56s.setIcon(PT6961_V56S::RED); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::GRN); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::YEL); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::DVD); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::COL1); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::DP3); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::PSE); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::MP3); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::PLY); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::CD); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::COL3); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::ARW); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::ANT); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::DTS); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::MHZ); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::DDD); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::KHZ); wait(delay);
          pt6961_v56s.setIcon(PT6961_V56S::RDS); wait(delay);
          wait(delay);                              
          pt6961_v56s.clrIcon(PT6961_V56S::RED); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::GRN); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::YEL); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::DVD); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::COL1); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::DP3); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::PSE); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::MP3); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::PLY); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::CD); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::COL3); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::ARW); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::ANT); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::DTS); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::MHZ); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::DDD); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::KHZ); wait(delay);
          pt6961_v56s.clrIcon(PT6961_V56S::RDS); wait(delay);
        }       

        if (keydata[1] == 0x10) { //sw4 - not mounted
          pt6961_v56s.cls(); 
          pt6961_v56s.printf("%5d", -1234);          
//          pt6961_v56s.printf("%05d", 1234);
        }       
        
      } //if

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif


#if(PT6961_TEST == 1)
//Raw test on HR734 display

#include "Font_7Seg.h"
  
// DisplayData_t size is 12 bytes (6 digits @ 12 segments) OR 14 bytes (7 digits @ 11 segments) 
PT6961::DisplayData_t mbed_str = {0xDA,0x00, 0x7C,0x00, 0x3C,0x01, 0xF6,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  
PT6961::DisplayData_t all_str  = {0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F, 0xFF,0x0F};  
PT6961::DisplayData_t bye_str = {0x7C,0x00, 0xEC,0x00, 0x3C,0x01, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  
PT6961::DisplayData_t hello_str = {0xDC,0x00, 0x3C,0x01, 0x38,0x00, 0x38,0x00, 0xF8,0x01, 0x00,0x00, 0x00,0x00};  
PT6961::DisplayData_t tst_str;  

// KeyData_t size is 5 bytes  
PT6961::KeyData_t keydata; 

// PT6191 declaration, Default setting 7 Digits @ 11 Segments
PT6961 pt6961(p5,p6,p7, p8);

int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    pt6961.cls(); 
    pt6961.writeData(all_str);
    wait(4);
    pt6961.setBrightness(PT6961_BRT3);    
    pt6961.writeData(mbed_str);    
    wait(1);
    pt6961.setBrightness(PT6961_BRT0);        
    wait(1);
    pt6961.setBrightness(PT6961_BRT3);            
    
    while (1) {
     
      // Check and read keydata
      if (pt6961.getKeys(&keydata)) {
        pc.printf("Keydata 0..4 = 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3], keydata[4]);

        if (keydata[0] == 0x10) { //sw2   
          pt6961.cls(); 
          pt6961.writeData(all_str);
        }  

        if (keydata[0] == 0x02) { //sw8   
          pt6961.cls(); 
          pt6961.writeData(hello_str);
        }  

        if (keydata[0] == 0x20) { //sw6   
          pt6961.cls(); 
          pt6961.writeData(mbed_str);
        }       

        if (keydata[1] == 0x02) { //sw4   
          pt6961.cls(); 
          pt6961.writeData(bye_str);
        }       

        if (keydata[0] == 0x04) { //sw11   
          pt6961.cls(); 
          
          for (int idx=0; idx < PT6961_DISPLAY_MEM;idx++){
            tst_str[idx]=0x00;
          }
          tst_str[0]=0x01; //RA
          tst_str[2]=0x01; //M          
          pt6961.writeData(tst_str);
        }       

        if (keydata[0] == 0x08) { //sw10   
          pt6961.cls(); 
          
          for (int idx=0; idx < PT6961_DISPLAY_MEM;idx++){
            tst_str[idx]=0x00;
          }
          tst_str[6]=0x01; //HD
          tst_str[8]=0x01; //D          
          pt6961.writeData(tst_str);
        }       

        if (keydata[1] == 0x01) { //sw9   
          pt6961.cls(); 
          
          for (int idx=0; idx < PT6961_DISPLAY_MEM;idx++){
            tst_str[idx]=0x00;
          }
          tst_str[8]=0x01;  //D
          tst_str[10]=0x01; //VD          
          pt6961.writeData(tst_str);
        }       

        if (keydata[0] == 0x01) { //sw7   
          pt6961.cls(); 
          
          for (int idx=0; idx < PT6961_DISPLAY_MEM;idx++){
            tst_str[idx]=0x00;
          }
          tst_str[12]=0x20; //clock
          pt6961.writeData(tst_str);
        }       
        
      } //if

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif


