/* mbed PT6318 Test program, for Princeton PT6318 VFD controller
 * Copyright (c) 2016, v01: WH, Initial version, KUH8300
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "PT6318.h"

// Select one of the testboards for Princeton PT6318 VFD controller

#if (KUH8300_TEST == 1) 
// KUH8300 PT6318 Test
#include "mbed.h"
#include "PT6318.h"
#include "Font_16Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 24 bytes (8 grids @ max 20 segments) ... 48 bytes (16 grids @ max 12 segments) 
// DisplayData_t size for KUH8300 is 24 bytes (8 Grids @ 20 Segments) 
PT6318::DisplayData_t all_str  = {0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, \
                                  0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F };

PT6318::DisplayData_t cls_str  = {0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00 };
                                  
// KeyData_t size is 6 bytes  
PT6318::KeyData_t keydata; 

//PT6318_KUH8300 declaration, Setting 8 Grids @ 20 Segments
PT6318_KUH8300 KUH8300(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    KUH8300.cls(); 
    KUH8300.writeData(all_str);
    wait(4);
    KUH8300.setBrightness(PT6318_BRT3);    
    wait(1);
    KUH8300.setBrightness(PT6318_BRT0);        
    wait(1);
    KUH8300.setBrightness(PT6318_BRT7);            
    
    while (1) {
     
      // Check and read keydata
      if (KUH8300.getKeys(&keydata)) {
        pc.printf("Keydata 0..5 = 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3], keydata[4], keydata[5]);

        if (keydata[0] == 0x01) { //up
          KUH8300.cls(); 
          KUH8300.writeData(all_str);
        }  

        if (keydata[0] == 0x02) { //pause   
          KUH8300.cls(); 
          KUH8300.writeData(cls_str);
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          KUH8300.cls(); 
         
          for (int i=0; i<PT6318_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              KUH8300.cls(); 

              bits = 0x01 << bit;              
              KUH8300.writeData(bits, i);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif           
        }  

        if (keydata[0] == 0x04) { //play   

#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          KUH8300.cls(); 

          for (int i=0; i<KUH8300_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              KUH8300.locate(i);
              KUH8300.printf("%0d", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all digits\r\n");
          wait(1);          

          KUH8300.cls(); 
          KUH8300.printf("%d", 0);
          cmd = pc.getc(); // wait for key

          KUH8300.cls();           
          KUH8300.printf("%3.4f", 12.3456);
          cmd = pc.getc(); // wait for key

          KUH8300.cls();           
          KUH8300.printf("%d", 123456);
          cmd = pc.getc(); // wait for key

          KUH8300.cls(); 
          KUH8300.printf("%08x", 0x0123ABCD);  //Note this value needs 64bits
          cmd = pc.getc(); // wait for key
          
          for (int i=0; i<KUH8300_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              KUH8300.locate(i);
              KUH8300.printf("%0x", cnt);
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all digits done\r\n");          
#endif                

        }

        if (keydata[0] == 0x08) { //open  

#if(1)
//test to show all alpha chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          KUH8300.cls(); 
         
          for (int i=0; i<26; i++) {
            KUH8300.printf("%c", char(i + 'A'));
//            KUH8300.printf("%c", char(i + 'a'));
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            

#if(0)
//test to show all chars
          pc.printf("Show all chars\r\n");
          wait(1);          
          KUH8300.cls(); 

          for (int i=FONT_16S_START; i<FONT_16S_END; i++) {
            KUH8300.printf("%c", char(i));
//            wait(0.25);
            cmd = pc.getc(); // wait for key            
          }
          pc.printf("Show all chars done\r\n");                    
#endif            
        }

        if (keydata[0] == 0x10) { //down           
#if(0)
          //wheel
          for(int cnt=0;cnt<10;cnt++) {
            for(int idx=0;idx<8;idx++) {         
              KUH8300.setUDC(0, WHEEL_ANI[idx]);
              KUH8300.locate(0);
              KUH8300.printf("%c%c%c%c%c%c%c%c",(char)0,(char)0, (char)0,(char)0, (char)0,(char)0, (char)0,(char)0);
                
              wait(0.1); 
            }  
          }
#endif       
        }
        
        if (keydata[0] == 0x20) { //title                  
          KUH8300.cls();   
//                         01234567                         
          KUH8300.printf("Hi mbed");
        }
         

        if (keydata[0] == 0x40) { //menu

#if(1)
//test to show all icons
          pc.printf("Show all icons\r\n");
          wait(1);          
          KUH8300.cls(true); // Also clear all Icons
          wait(1);          

          float delay=0.1;
          KUH8300.setIcon(PT6318_KUH8300::CAM); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::DIG); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::MONO); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::PRG); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::DTS); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::MEM); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::KHZ); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::STR); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::MHZ); wait(delay);

          KUH8300.setIcon(PT6318_KUH8300::KEY); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::ALL); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::DP6); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::COL6); wait(delay);
          
          KUH8300.setIcon(PT6318_KUH8300::ARW); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::A_); wait(delay);        
          KUH8300.setIcon(PT6318_KUH8300::B_); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::CD4A); wait(delay);

          KUH8300.setIcon(PT6318_KUH8300::CHP); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::N3); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::L3); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::HK3); wait(delay);

          KUH8300.setIcon(PT6318_KUH8300::TTL); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::JM1); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::HK2); wait(delay);

          KUH8300.setIcon(PT6318_KUH8300::PSE); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::PLY); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::PBC); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::DVD); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::CD); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::V); wait(delay);
          KUH8300.setIcon(PT6318_KUH8300::S); wait(delay);

          wait(delay);

          KUH8300.clrIcon(PT6318_KUH8300::CAM); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::DIG); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::MONO); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::PRG); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::DTS); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::MEM); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::KHZ); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::STR); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::MHZ); wait(delay);

          KUH8300.clrIcon(PT6318_KUH8300::KEY); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::ALL); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::DP6); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::COL6); wait(delay);
          
          KUH8300.clrIcon(PT6318_KUH8300::ARW); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::A_); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::B_); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::CD4A); wait(delay);

          KUH8300.clrIcon(PT6318_KUH8300::CHP); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::N3); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::L3); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::HK3); wait(delay);

          KUH8300.clrIcon(PT6318_KUH8300::TTL); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::JM1); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::HK2); wait(delay);

          KUH8300.clrIcon(PT6318_KUH8300::PSE); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::PLY); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::PBC); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::DVD); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::CD); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::V); wait(delay);
          KUH8300.clrIcon(PT6318_KUH8300::S); wait(delay);

          wait(1);          
          KUH8300.cls(); // clear all, preserve Icons         
          pc.printf("Show all icons done\r\n");                    
#endif           
        }       

        if (keydata[0] == 0x80) { //stop            
          //write LEDs off
//          KUH8300.setLED(0x07);         
          KUH8300.setLED(PT6318_LED1 | PT6318_LED2 | PT6318_LED3 | PT6318_LED4 | PT6318_LED5);
        }

        if (keydata[1] == 0x01) { //left  
          //write LEDs on 
          KUH8300.setLED(0x00);                 
        }

        if (keydata[1] == 0x02) { //pwr
        }

        if (keydata[1] == 0x04) { //next
        }
     
      } //if Key

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif


#if(PT6318_TEST == 1)
// Direct PT6318 Test
#include "mbed.h"
#include "PT6318.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 24 bytes (8 digits @ max 20 segments) ... 48 bytes (16 digits @ max 12 segments) 
// DisplayData_t size default is 48 bytes (16 Grids @ 12 Segments) 
PT6318::DisplayData_t all_str  = {0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, \
                                  0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, \
                                  0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, \
                                  0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F, 0xFF,0xFF,0x0F};  

PT6318::DisplayData_t cls_str  = {0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00};

// KeyData_t size is 6 bytes  
PT6318::KeyData_t keydata; 

// Switchdata is 1 byte  
char switchdata; 

PT6318 PT6318(p5,p6,p7, p8);
//PT6318 PT6318(p5,p6,p7, p8, PT6318::Grid16_Seg12);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    PT6318.cls(); 
    PT6318.writeData(all_str);
    wait(4);
    PT6318.setBrightness(PT6318_BRT3);    
    wait(1);
    PT6318.setBrightness(PT6318_BRT0);        
    wait(1);
    PT6318.setBrightness(PT6318_BRT7);            
    
    while (1) {
     
      // Check and read keydata
      if (PT6318.getKeys(&keydata)) {
        pc.printf("Keydata 0..5 = 0x%02x 0x%02x 0x%02x 0x%02x  0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3], keydata[4], keydata[4]);

        if (keydata[0] == 0x01) { //up   
          PT6318.cls(); 
          PT6318.writeData(all_str);
        }  

        if (keydata[0] == 0x02) { //pause   
          PT6318.cls(); 
          PT6318.writeData(cls_str);
        }  

        if (keydata[0] == 0x04) { //play   
          PT6318.cls(); 
          PT6318.writeData(all_str);  

#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          PT6318.cls(); 
         
          for (int i=0; i<PT6318_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              PT6318.cls(); 

              bits = 0x01 << bit;              
              PT6318.writeData(bits, i);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
          
        }       
       
      } //if Key

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif
