/* mbed PT6315 Test program, for Princeton PT6315 VFD controller
 * Copyright (c) 2016, v01: WH, Initial version, DVDR3510
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "PT6315.h"

// Select one of the testboards for Princeton PT6315 VFD controller

#if (DVDR3510_TEST == 1) 
// DVDR3510 PT6315 Test
#include "mbed.h"
#include "PT6315.h"
#include "Font_16Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 12 bytes (4 grids @ max 24 segments) ... 36 bytes (12 grids @ max 16 segments) 
// DisplayData_t size for DVDR3510 is 33 bytes (11 Grids @ 17 Segments) 
PT6315::DisplayData_t all_str  = {0xFF,0xFF,0x01, 0xFF,0xFF,0x01, 0xFF,0xFF,0x01, 0xFF,0xFF,0x01, \
                                  0xFF,0xFF,0x01, 0xFF,0xFF,0x01, 0xFF,0xFF,0x01, 0xFF,0xFF,0x01, \
                                  0xFF,0xFF,0x01, 0xFF,0xFF,0x01, 0xFF,0xFF,0x01};

PT6315::DisplayData_t cls_str  = {0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00}; 

PT6315::DisplayData_t bye_str  = {LO(C16_B),MD(C16_B),HI(C16_B), LO(C16_Y),MD(C16_Y),HI(C16_Y), LO(C16_E),MD(C16_E),HI(C16_E), 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00};

PT6315::DisplayData_t hello_str = {LO(C16_H),MD(C16_H),HI(C16_H), LO(C16_E),MD(C16_E),HI(C16_E), LO(C16_L),MD(C16_L),HI(C16_L), LO(C16_L),MD(C16_L),HI(C16_L), \
                                   LO(C16_O),MD(C16_O),HI(C16_O), 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                   0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00}; 

PT6315::DisplayData_t mbed_str  = {LO(C16_M),MD(C16_M),HI(C16_M), LO(C16_B),MD(C16_B),HI(C16_B), LO(C16_E),MD(C16_E),HI(C16_E), LO(C16_D),MD(C16_D),HI(C16_D), \
                                   0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                   0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00};
                                   
// KeyData_t size is 3 bytes  
PT6315::KeyData_t keydata; 

//PT6315_DVDR3510 declaration, Setting 12 Grids @ 16 Segments
PT6315_DVDR3510 DVDR3510(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    DVDR3510.cls(); 
    DVDR3510.writeData(all_str);
    wait(4);
    DVDR3510.setBrightness(PT6315_BRT3);    
    wait(1);
    DVDR3510.setBrightness(PT6315_BRT0);        
    wait(1);
    DVDR3510.setBrightness(PT6315_BRT7);            
    
    while (1) {
     
      // Check and read keydata
      if (DVDR3510.getKeys(&keydata)) {
        pc.printf("Keydata 0..3 = 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3]);

        if (keydata[1] == 0x20) { //dub
          DVDR3510.cls(); 
          DVDR3510.writeData(all_str);
        }  

        if (keydata[2] == 0x01) { //up   
          DVDR3510.cls(); 
          DVDR3510.writeData(cls_str);
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          DVDR3510.cls(); 
         
          for (int i=0; i<PT6315_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              DVDR3510.cls(); 

              bits = 0x01 << bit;              
              DVDR3510.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif           
        }  


        if (keydata[1] == 0x10) { //down   

#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          DVDR3510.cls(); 

          int val = 1; 
          for (int i=0; i<DVDR3510_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              DVDR3510.locate(0);
              DVDR3510.printf("%08d", (val * cnt));

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 10;
          }
          pc.printf("Show all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all digits\r\n");
          wait(1);          

          DVDR3510.cls(); 
          DVDR3510.printf("%d", 0);
          cmd = pc.getc(); // wait for key

          DVDR3510.cls();           
          DVDR3510.printf("%3.4f", 12.3456);
          cmd = pc.getc(); // wait for key

          DVDR3510.cls();           
          DVDR3510.printf("%d", 123456);
          cmd = pc.getc(); // wait for key

          DVDR3510.cls(); 
          DVDR3510.printf("%08x", 0x0123ABCD);  //Note this value needs 64bits
          cmd = pc.getc(); // wait for key
          
          int val = 1; 
          for (int i=0; i<DVDR3510_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              DVDR3510.locate(0);
              DVDR3510.printf("%08x", (val * cnt));
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 0x10;
          }
          pc.printf("Show all digits done\r\n");          
#endif                

        }

        if (keydata[1] == 0x04) { //vcr/dvd   

#if(1)
//test to show all alpha chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          DVDR3510.cls(); 
         
          for (int i=0; i<26; i++) {
            DVDR3510.printf("%c", char(i + 'A'));
//            DVDR3510.printf("%c", char(i + 'a'));
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            

#if(0)
//test to show all chars
          pc.printf("Show all chars\r\n");
          wait(1);          
          DVDR3510.cls(); 

          for (int i=FONT_16S_START; i<FONT_16S_END; i++) {
            DVDR3510.printf("%c", char(i));
//            wait(0.25);
            cmd = pc.getc(); // wait for key            
          }
          pc.printf("Show all chars done\r\n");                    
#endif            
        }

        if (keydata[3] == 0x08) { //eject           
#if(1)
          //wheel
          for(int cnt=0;cnt<10;cnt++) {
            for(int idx=0;idx<8;idx++) {         
              DVDR3510.setUDC(0, WHEEL_ANI[idx]);
              DVDR3510.locate(0);
              DVDR3510.printf("%c%c%c%c%c%c%c%c",(char)0,(char)0, (char)0,(char)0, (char)0,(char)0, (char)0,(char)0);
                
              wait(0.1); 
            }  
          }
#endif       
        }
        
        if (keydata[3] == 0x20) { //open/close                  
          DVDR3510.cls();   
//                         01234567                         
          DVDR3510.printf("Hi mbed");
        }
         

        if (keydata[2] == 0x20) { //rec

#if(1)
//test to show all icons
          pc.printf("Show all icons\r\n");
          wait(1);          
          DVDR3510.cls(true); // Also clear all Icons
          wait(1);          

          float delay=0.1;
          DVDR3510.setIcon(PT6315_DVDR3510::RCV); wait(delay);
          DVDR3510.setIcon(PT6315_DVDR3510::TV); wait(delay);          
          DVDR3510.setIcon(PT6315_DVDR3510::DRT); wait(delay);
          DVDR3510.setIcon(PT6315_DVDR3510::TMR); wait(delay);
          DVDR3510.setIcon(PT6315_DVDR3510::COL4); wait(delay);
          DVDR3510.setIcon(PT6315_DVDR3510::PRS); wait(delay);      
          DVDR3510.setIcon(PT6315_DVDR3510::COL6); wait(delay);          
          DVDR3510.setIcon(PT6315_DVDR3510::DP6); wait(delay);         
          DVDR3510.setIcon(PT6315_DVDR3510::SAT); wait(delay);
          wait(delay);
          DVDR3510.clrIcon(PT6315_DVDR3510::RCV); wait(delay);
          DVDR3510.clrIcon(PT6315_DVDR3510::TV); wait(delay);          
          DVDR3510.clrIcon(PT6315_DVDR3510::DRT); wait(delay);
          DVDR3510.clrIcon(PT6315_DVDR3510::TMR); wait(delay);
          DVDR3510.clrIcon(PT6315_DVDR3510::COL4); wait(delay);          
          DVDR3510.clrIcon(PT6315_DVDR3510::PRS); wait(delay);      
          DVDR3510.clrIcon(PT6315_DVDR3510::COL6); wait(delay);          
          DVDR3510.clrIcon(PT6315_DVDR3510::DP6); wait(delay);
          DVDR3510.clrIcon(PT6315_DVDR3510::SAT); wait(delay);
          wait(1);          
          DVDR3510.cls(); // clear all, preserve Icons         
          pc.printf("Show all icons done\r\n");                    
#endif           
        }       

        if (keydata[2] == 0x08) { //prev            
          //write LEDs off
          DVDR3510.setLED(0x07);
        }

        if (keydata[2] == 0x80) { //next  
          //write LEDs on 
          DVDR3510.setLED(0x00);                 
        }

        if (keydata[3] == 0x02) { //stop
        }

        if (keydata[3] == 0x80) { //play
        }
     
      } //if Key



      myled = !myled;
      wait(0.3);      
    } //while
}
#endif


#if(PT6315_TEST == 1)
// Direct PT6315 Test
#include "mbed.h"
#include "PT6315.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 24 bytes (8 digits @ max 20 segments) ... 48 bytes (16 digits @ max 12 segments) 
// DisplayData_t size default is 48 bytes (16 Grids @ 12 Segments) 
PT6315::DisplayData_t all_str  = {0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, \
                                  0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, \
                                  0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, \
                                  0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00};  

PT6315::DisplayData_t cls_str  = {0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00};

// KeyData_t size is 6 bytes  
PT6315::KeyData_t keydata; 

// Switchdata is 1 byte  
char switchdata; 

PT6315 PT6315(p5,p6,p7, p8);
//PT6315 PT6315(p5,p6,p7, p8, PT6315::Grid16_Seg12);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    PT6315.cls(); 
    PT6315.writeData(all_str);
    wait(4);
    PT6315.setBrightness(PT6315_BRT3);    
    wait(1);
    PT6315.setBrightness(PT6315_BRT0);        
    wait(1);
    PT6315.setBrightness(PT6315_BRT7);            
    
    while (1) {
     
      // Check and read keydata
      if (PT6315.getKeys(&keydata)) {
        pc.printf("Keydata 0..3 = 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3]);

        if (keydata[0] == 0x01) { //play   
          PT6315.cls(); 
          PT6315.writeData(all_str);
        }  

        if (keydata[0] == 0x02) { //stop   
          PT6315.cls(); 
          PT6315.writeData(cls_str);
        }  

        if (keydata[0] == 0x04) { //open/close   
          PT6315.cls(); 
          PT6315.writeData(all_str);  

#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          PT6315.cls(); 
         
          for (int i=0; i<PT6315_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              PT6315.cls(); 

              bits = 0x01 << bit;              
              PT6315.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
          
        }       
       
      } //if Key

      myled = !myled;
      wait(0.3);      
    } //while
}
#endif
