/* mbed PT6312 Test program, for Princeton PT6312 VFD controller
 * Copyright (c) 2015, v01: WH, Initial version
 *               2015, v02: WH, Test DVD462 and C2233
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "PT6312.h"


#if (DVP630_TEST == 1) 
// Philips DVP630 Display Test 

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// KeyData_t size is 3 bytes  
PT6312::KeyData_t keydata; 

// Switchdata is 1 byte  
char switchdata; 

// PT6312_DVP630 declaration. Setting 7 Grids @ 15 Segments)
PT6312_DVP630 DVP630(p5,p6,p7, p8);

int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    DVP630.cls(); 
//    DVP630.putc('A');
//    wait(1);
        
    DVP630.setUDC(0, UDC_SANDHR); //Set UDC
    DVP630.putc((char) 0);       
    wait(1);
    
    DVP630.setBrightness(PT6312_BRT7); 
    wait(1);
        
//wheel
    for(int cnt=0;cnt<10;cnt++) {
      for(int idx=0;idx<8;idx++) {         
        DVP630.setUDC(0, WHEEL_ANI[idx]);
        DVP630.locate(0);
        DVP630.printf("%c%c%c%c%c%c%c",(char)0,(char)0,(char)0,(char)0,(char)0,(char)0,(char)0);
                
        wait(0.1); 
      }  
    }
       
   
//test to show all chars
    wait(1);          
    DVP630.cls(); 
         
    for (int i=0x20; i<0x80; i++) {
//      DVP630.cls(); 
      DVP630.locate(0);       
      DVP630.printf("0x%2X=%c ", i, (char) i);
      wait(0.2);
//      pc.getc();      
    }

    while (1) {
     
      // Check and read keydata
      if (DVP630.getKeys(&keydata)) {
        pc.printf("Keydata 0..2 = 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2]);

        if (keydata[0] == 0x01) { //play   
          DVP630.cls(); 
          DVP630.printf("AAAAAAA");
          DVP630.setIcon(PT6312_DVP630::COL3);
          DVP630.setIcon(PT6312_DVP630::COL5);          
        }  

        if (keydata[0] == 0x02) { //stop   
          DVP630.cls(); 
          DVP630.printf("HELLO  ");
          DVP630.clrIcon(PT6312_DVP630::COL3);
          DVP630.clrIcon(PT6312_DVP630::COL5);                    
        }  

        if (keydata[0] == 0x04) { //open/close   
          DVP630.cls(); 
          DVP630.printf("MBED   ");       
        }       
       
      } //if Key


      // Check and read switch data
      switchdata = DVP630.getSwitches();
      
      if (switchdata != 0) {
        pc.printf("Switchdata = 0x%02x\r\n", switchdata);

        if (switchdata == PT6312_SW1) { //S1   
          DVP630.cls(); 
          DVP630.printf(" HELLO ");       
        }  

        if (switchdata == PT6312_SW2) { //S2   
          DVP630.cls(); 
          DVP630.printf("BYE    ");                 
        }  

        if (switchdata == PT6312_SW3) { //S3   
          DVP630.cls(); 
          DVP630.printf("HI MBED");                
        } 
        
        DVP630.setLED(switchdata); //write LEDs in same pattern
      } //if Switch

      myled = !myled;
      wait(0.3);      
    } //while
       
}
#endif


#if (DVD462_TEST == 1) 
// DVD462 PT6312 Test
#include "mbed.h"
#include "PT6312.h"
#include "Font_7Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 8 bytes (4 digits @ max 16 segments) ... 22 bytes (11 digits @ max 11 segments) 
// DisplayData_t size default is 22 bytes (11 digits @ max 11 segments)
PT6312::DisplayData_t all_str   = {0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF};  
PT6312::DisplayData_t bye_str   = {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, LO(C7_E),HI(C7_E), LO(C7_Y),HI(C7_Y), LO(C7_B),HI(C7_B)};  
PT6312::DisplayData_t hello_str = {0x00,0x00, 0x00,0x00, LO(C7_O),HI(C7_O), LO(C7_L),HI(C7_L), LO(C7_L),HI(C7_L), LO(C7_E),HI(C7_E), LO(C7_H), HI(C7_H)};  
PT6312::DisplayData_t mbed_str  = {LO(C7_D), HI(C7_D), LO(C7_E), HI(C7_E), LO(C7_B), HI(C7_B), LO(C7_M), HI(C7_M)};

// KeyData_t size is 3 bytes  
PT6312::KeyData_t keydata; 

// Switchdata is 1 byte  
char switchdata; 

//PT6312_DVD462 declaration, Setting 6 Grids @ 16 Segments
PT6312_DVD462 DVD462(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    DVD462.cls(); 
    DVD462.writeData(all_str);
    wait(4);
    DVD462.setBrightness(PT6312_BRT3);    
    wait(1);
    DVD462.setBrightness(PT6312_BRT0);        
    wait(1);
    DVD462.setBrightness(PT6312_BRT7);            
    
    while (1) {
     
      // Check and read keydata
      if (DVD462.getKeys(&keydata)) {
        pc.printf("Keydata 0..2 = 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2]);

        if (keydata[0] == 0x01) { //play   
          DVD462.cls(); 
          DVD462.writeData(all_str);
        }  

        if (keydata[0] == 0x02) { //pause   
          DVD462.cls(); 
//          DVD462.writeData(hello_str);
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          DVD462.cls(); 
         
          for (int i=0; i<PT6312_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              DVD462.cls(); 

              bits = 0x01 << bit;              
              DVD462.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
          
        }  


        if (keydata[0] == 0x04) { //stop   
//          DVD462.cls(); 
//          DVD462.writeData(mbed_str);

#if(0)
//test to show all chars
          pc.printf("Show all chars\r\n");
          wait(1);          
          DVD462.cls(); 
         
          for (int i=0; i<26; i++) {
            DVD462.writeData(0, FONT_16S[i][0]);
            DVD462.writeData(1, FONT_16S[i][1]);
            wait(1);                      
          }
          pc.printf("Show all chars done\r\n");                    
#endif            


#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          DVD462.cls(); 

          int val = 1; 
          for (int i=0; i<DVD462_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              DVD462.locate(0);
              DVD462.printf("%07d", (val * cnt));

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 10;
          }
          pc.printf("Show all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          DVD462.cls(); 

          DVD462.printf("%07x", 0x012ABCD);
          cmd = pc.getc(); // wait for key                                     
          
          int val = 1; 
          for (int i=0; i<DVD462_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              DVD462.locate(0);
              DVD462.printf("%07x", (val * cnt));

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 0x10;
          }
          pc.printf("Show all digits done\r\n");          
#endif                

        }
        
        if (keydata[0] == 0x10) { //open/close   
//          DVD462.cls(); 
//          DVD462.writeData(mbed_str); 
#if(1)
//test to show all icons
          pc.printf("Show all icons\r\n");
          wait(1);          
          DVD462.cls(true); // Also clear all Icons
          wait(1);          
         
          DVD462.setIcon(PT6312_DVD462::MP3);
          DVD462.setIcon(PT6312_DVD462::CD);
          DVD462.setIcon(PT6312_DVD462::V);
          DVD462.setIcon(PT6312_DVD462::S);
          DVD462.setIcon(PT6312_DVD462::DVD);

          DVD462.setIcon(PT6312_DVD462::DDD);
          DVD462.setIcon(PT6312_DVD462::DTS);          

          DVD462.setIcon(PT6312_DVD462::COL5);
          DVD462.setIcon(PT6312_DVD462::COL3);      

          DVD462.setIcon(PT6312_DVD462::ARW);
          DVD462.setIcon(PT6312_DVD462::ALL);
          DVD462.setIcon(PT6312_DVD462::PSE);
          DVD462.setIcon(PT6312_DVD462::PLY);
          DVD462.setIcon(PT6312_DVD462::PBC);

          DVD462.setIcon(PT6312_DVD462::P1);
          DVD462.setIcon(PT6312_DVD462::P2);
          DVD462.setIcon(PT6312_DVD462::P3);
          DVD462.setIcon(PT6312_DVD462::P4);
          DVD462.setIcon(PT6312_DVD462::P5);
          DVD462.setIcon(PT6312_DVD462::P6);
          DVD462.setIcon(PT6312_DVD462::P7);
          DVD462.setIcon(PT6312_DVD462::P8);                                                                      
          DVD462.setIcon(PT6312_DVD462::P9);
          DVD462.setIcon(PT6312_DVD462::P10);
          DVD462.setIcon(PT6312_DVD462::P11);
          DVD462.setIcon(PT6312_DVD462::P12);
          DVD462.setIcon(PT6312_DVD462::P13); 
          
          wait(1);          
          DVD462.cls(); // clear all, preserve Icons         
          pc.printf("Show all icons done\r\n");                    
#endif           
        }       

        if (keydata[0] == 0x20) { //fr   
//          DVD462.cls(); 
//          DVD462.writeData(mbed_str);
          
          //write LEDs off
          DVD462.setLED(0x01);
        }

        if (keydata[0] == 0x40) { //ff   
//          DVD462.cls(); 
//          DVD462.writeData(mbed_str);

          //write LEDs on 
          DVD462.setLED(0x00);
                  
        }

        if (keydata[0] == 0x80) { //pwr   
          DVD462.cls(true); 
//          DVD462.writeData(mbed_str);
//          DVD462.writeData(mbed_str);  
          
          float delay=0.1;
          // Piechart Icons on          
          DVD462.setIcon(PT6312_DVD462::P13); wait(delay);
          DVD462.setIcon(PT6312_DVD462::P12); wait(delay);
          DVD462.setIcon(PT6312_DVD462::P11); wait(delay);
          DVD462.setIcon(PT6312_DVD462::P10); wait(delay);
          DVD462.setIcon(PT6312_DVD462::P9); wait(delay);
          DVD462.setIcon(PT6312_DVD462::P8); wait(delay);
          DVD462.setIcon(PT6312_DVD462::P7); wait(delay);
          DVD462.setIcon(PT6312_DVD462::P6); wait(delay);                                                                      
          DVD462.setIcon(PT6312_DVD462::P5); wait(delay);
          DVD462.setIcon(PT6312_DVD462::P4); wait(delay);
          DVD462.setIcon(PT6312_DVD462::P3); wait(delay);
          DVD462.setIcon(PT6312_DVD462::P2); wait(delay);
          DVD462.setIcon(PT6312_DVD462::P1); wait(delay);

          wait(delay);
 
          // Piechart Icons off          
          DVD462.clrIcon(PT6312_DVD462::P13); wait(delay);
          DVD462.clrIcon(PT6312_DVD462::P12); wait(delay);
          DVD462.clrIcon(PT6312_DVD462::P11); wait(delay);
          DVD462.clrIcon(PT6312_DVD462::P10); wait(delay);
          DVD462.clrIcon(PT6312_DVD462::P9); wait(delay);
          DVD462.clrIcon(PT6312_DVD462::P8); wait(delay);
          DVD462.clrIcon(PT6312_DVD462::P7); wait(delay);
          DVD462.clrIcon(PT6312_DVD462::P6); wait(delay);           
          DVD462.clrIcon(PT6312_DVD462::P5); wait(delay);                                                                      
          DVD462.clrIcon(PT6312_DVD462::P4); wait(delay);
          DVD462.clrIcon(PT6312_DVD462::P3); wait(delay);
          DVD462.clrIcon(PT6312_DVD462::P2); wait(delay);
          DVD462.clrIcon(PT6312_DVD462::P1); wait(delay);          
        }
      
      } //if Key


      // Check and read switch data
      switchdata = DVD462.getSwitches();
      
      if (switchdata != 0) {
        pc.printf("Switchdata = 0x%02x\r\n", switchdata);

        if (switchdata == PT6312_SW1) { //S1   
          DVD462.cls(); 
          DVD462.writeData(hello_str);
        }  

        if (switchdata == PT6312_SW2) { //S2   
          DVD462.cls(); 
          DVD462.writeData(bye_str);
        }  

        if (switchdata == PT6312_SW3) { //S3   
          DVD462.cls(); 
          DVD462.writeData(mbed_str);
        } 
        
        DVD462.setLED(switchdata); //write LEDs in same pattern
      } //if Switch


      myled = !myled;
      wait(0.3);      
    } //while
}
#endif


#if (C2233_TEST == 1) 
// C2233 PT6312 Test
#include "mbed.h"
#include "PT6312.h"
#include "Font_7Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 8 bytes (4 digits @ max 16 segments) ... 22 bytes (11 digits @ max 11 segments) 
// DisplayData_t size default is 22 bytes (11 digits @ max 11 segments)
PT6312::DisplayData_t all_str   = {0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF, 0xFF,0xFF};  
//PT6312::DisplayData_t bye_str   = {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, LO(C7_E),HI(C7_E), LO(C7_Y),HI(C7_Y), LO(C7_B),HI(C7_B)};  
PT6312::DisplayData_t hello_str = {0x00,0x00, (C7_O | ((C7_L & 0x01) << 7)),(C7_L >> 1), C7_L,C7_E, C7_H,0x00, 0x00,0x00, 0x00,0x00};  
//PT6312::DisplayData_t mbed_str  = {LO(C7_D), HI(C7_D), LO(C7_E), HI(C7_E), LO(C7_B), HI(C7_B), LO(C7_M), HI(C7_M)};

// KeyData_t size is 3 bytes  
PT6312::KeyData_t keydata; 

// Switchdata is 1 byte  
char switchdata; 

//PT6312_C2233 declaration, Setting 6 Grids @ 16 Segments
PT6312_C2233 C2233(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    C2233.cls(); 
    C2233.writeData(all_str);
    wait(4);
    C2233.setBrightness(PT6312_BRT3);    
    wait(1);
    C2233.setBrightness(PT6312_BRT0);        
    wait(1);
    C2233.setBrightness(PT6312_BRT7);            

    wait(1);
    C2233.cls(true); 
    C2233.writeData(hello_str); 
    
    while (1) {
     
      // Check and read keydata
      if (C2233.getKeys(&keydata)) {
        pc.printf("Keydata 0..2 = 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2]);

        if (keydata[0] == 0x01) { //sw4  
          C2233.cls(); 
          C2233.writeData(all_str);
        }  

        if (keydata[0] == 0x02) { //sw7  
          C2233.cls(); 
//          C2233.writeData(hello_str);
#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          C2233.cls(); 
         
          for (int i=0; i<PT6312_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              C2233.cls(); 

              bits = 0x01 << bit;              
              C2233.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
          
        }  


        if (keydata[0] == 0x04) { //sw3   
//          C2233.cls(); 
//          C2233.writeData(mbed_str);

#if(0)
//test to show all chars
          pc.printf("Show all chars\r\n");
          wait(1);          
          C2233.cls(); 
         
          for (int i=0; i<26; i++) {
            C2233.writeData(0, FONT_16S[i][0]);
            C2233.writeData(1, FONT_16S[i][1]);
            wait(1);                      
          }
          pc.printf("Show all chars done\r\n");                    
#endif            


#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          C2233.cls(); 

          int val = 1; 
          for (int i=0; i<C2233_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              C2233.locate(0);
              C2233.printf("%07d", (val * cnt));

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 10;
          }
          pc.printf("Show all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          C2233.cls(); 

          C2233.printf("%07x", 0x012ABCD);
          cmd = pc.getc(); // wait for key                                     
          
          int val = 1; 
          for (int i=0; i<C2233_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              C2233.locate(0);
              C2233.printf("%07x", (val * cnt));

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 0x10;
          }
          pc.printf("Show all digits done\r\n");          
#endif                

        }
        
        if (keydata[0] == 0x10) { //sw5   
//          C2233.cls(); 
//          C2233.writeData(mbed_str); 
#if(1)
//test to show all icons
          pc.printf("Show all icons\r\n");
          wait(1);          
          C2233.cls(true); // Also clear all Icons
          wait(1);          
         
          C2233.setIcon(PT6312_C2233::MP3);
          C2233.setIcon(PT6312_C2233::PBC);

          C2233.setIcon(PT6312_C2233::COL5);
          C2233.setIcon(PT6312_C2233::CAM);      

          C2233.setIcon(PT6312_C2233::COL3);
          C2233.setIcon(PT6312_C2233::DDD);      

          C2233.setIcon(PT6312_C2233::ARW);
          C2233.setIcon(PT6312_C2233::ALL);
          C2233.setIcon(PT6312_C2233::PSE);
          C2233.setIcon(PT6312_C2233::PLY);         
          C2233.setIcon(PT6312_C2233::CD);
          C2233.setIcon(PT6312_C2233::V);
          C2233.setIcon(PT6312_C2233::S);
          C2233.setIcon(PT6312_C2233::DTS);

          C2233.setIcon(PT6312_C2233::P1);
          C2233.setIcon(PT6312_C2233::P2);
          C2233.setIcon(PT6312_C2233::P3);
          C2233.setIcon(PT6312_C2233::P4);
          C2233.setIcon(PT6312_C2233::P5);
          C2233.setIcon(PT6312_C2233::P6);
          C2233.setIcon(PT6312_C2233::P7);
          C2233.setIcon(PT6312_C2233::P8);                                                                      
          C2233.setIcon(PT6312_C2233::P9);
          C2233.setIcon(PT6312_C2233::P10);
          C2233.setIcon(PT6312_C2233::P11);
          C2233.setIcon(PT6312_C2233::P12);
          C2233.setIcon(PT6312_C2233::P13); 
          C2233.setIcon(PT6312_C2233::DVD);
          
          wait(1);          
          C2233.cls(); // clear all, preserve Icons         
          pc.printf("Show all icons done\r\n");                    
#endif           
        }       

        if (keydata[0] == 0x20) { //sw6   
//          C2233.cls(); 
//          C2233.writeData(mbed_str);
          
          //write LEDs off
          C2233.setLED(0x01);
        }

        if (keydata[0] == 0x40) { //sw2   
//          C2233.cls(); 
//          C2233.writeData(mbed_str);

          //write LEDs on 
          C2233.setLED(0x00);
                  
        }

        if (keydata[0] == 0x80) { //sw1   
          C2233.cls(true); 
//          C2233.writeData(mbed_str);
//          C2233.writeData(mbed_str);  
          
          float delay=0.1;
          // Piechart Icons on          
          C2233.setIcon(PT6312_C2233::P13); wait(delay);
          C2233.setIcon(PT6312_C2233::P12); wait(delay);
          C2233.setIcon(PT6312_C2233::P11); wait(delay);
          C2233.setIcon(PT6312_C2233::P10); wait(delay);
          C2233.setIcon(PT6312_C2233::P9); wait(delay);
          C2233.setIcon(PT6312_C2233::P8); wait(delay);
          C2233.setIcon(PT6312_C2233::P7); wait(delay);
          C2233.setIcon(PT6312_C2233::P6); wait(delay);                                                                      
          C2233.setIcon(PT6312_C2233::P5); wait(delay);
          C2233.setIcon(PT6312_C2233::P4); wait(delay);
          C2233.setIcon(PT6312_C2233::P3); wait(delay);
          C2233.setIcon(PT6312_C2233::P2); wait(delay);
          C2233.setIcon(PT6312_C2233::P1); wait(delay);

          wait(delay);
 
          // Piechart Icons off          
          C2233.clrIcon(PT6312_C2233::P13); wait(delay);
          C2233.clrIcon(PT6312_C2233::P12); wait(delay);
          C2233.clrIcon(PT6312_C2233::P11); wait(delay);
          C2233.clrIcon(PT6312_C2233::P10); wait(delay);
          C2233.clrIcon(PT6312_C2233::P9); wait(delay);
          C2233.clrIcon(PT6312_C2233::P8); wait(delay);
          C2233.clrIcon(PT6312_C2233::P7); wait(delay);
          C2233.clrIcon(PT6312_C2233::P6); wait(delay);           
          C2233.clrIcon(PT6312_C2233::P5); wait(delay);                                                                      
          C2233.clrIcon(PT6312_C2233::P4); wait(delay);
          C2233.clrIcon(PT6312_C2233::P3); wait(delay);
          C2233.clrIcon(PT6312_C2233::P2); wait(delay);
          C2233.clrIcon(PT6312_C2233::P1); wait(delay);          
        }
      
      } //if Key


      // Check and read switch data (not available on C2233)
      switchdata = C2233.getSwitches();
      
      if (switchdata != 0) {
        pc.printf("Switchdata = 0x%02x\r\n", switchdata);

        if (switchdata == PT6312_SW1) { //S1   
          C2233.cls(); 
          C2233.writeData(hello_str);
        }  

        if (switchdata == PT6312_SW2) { //S2   
          C2233.cls(); 
//          C2233.writeData(bye_str);
        }  

        if (switchdata == PT6312_SW3) { //S3   
          C2233.cls(); 
//          C2233.writeData(mbed_str);
        } 
        
        C2233.setLED(switchdata); //write LEDs in same pattern (not available on C2233)
      } //if Switch


      myled = !myled;
      wait(0.3);      
    } //while
}
#endif



#if(PT6312_TEST == 1)
// Direct PT6312 Test
#include "mbed.h"
#include "PT6312.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 8 bytes (4 digits @ max 16 segments) ... 22 bytes (11 digits @ max 11 segments) 
// DisplayData_t size default is 14 bytes (7 Grids @ 15 Segments) 
PT6312::DisplayData_t all_str   = {0xFF,0x7F, 0xFF,0x7F, 0xFF,0x7F, 0xFF,0x7F, 0xFF,0x7F, 0xFF,0x7F, 0xFF,0x7F};  
PT6312::DisplayData_t cls_str   = {0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00};  

// KeyData_t size is 3 bytes  
PT6312::KeyData_t keydata; 

// Switchdata is 1 byte  
char switchdata; 

PT6312 PT6312(p5,p6,p7, p8);
//PT6312 PT6312(p5,p6,p7, p8, PT6312::Grid4_Seg16);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    PT6312.cls(); 
    PT6312.writeData(all_str);
    wait(4);
    PT6312.setBrightness(PT6312_BRT3);    
    wait(1);
    PT6312.setBrightness(PT6312_BRT0);        
    wait(1);
    PT6312.setBrightness(PT6312_BRT7);            
    
    while (1) {
     
      // Check and read keydata
      if (PT6312.getKeys(&keydata)) {
        pc.printf("Keydata 0..2 = 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2]);

        if (keydata[0] == 0x01) { //play   
          PT6312.cls(); 
          PT6312.writeData(all_str);
        }  

        if (keydata[0] == 0x02) { //stop   
          PT6312.cls(); 
          PT6312.writeData(cls_str);
        }  

        if (keydata[0] == 0x04) { //open/close   
          PT6312.cls(); 
          PT6312.writeData(all_str);  

#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          PT6312.cls(); 
         
          for (int i=0; i<PT6312_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              PT6312.cls(); 

              bits = 0x01 << bit;              
              PT6312.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
          
        }       
       
      } //if Key


      // Check and read switch data
      switchdata = PT6312.getSwitches();
      
      if (switchdata != 0) {
        pc.printf("Switchdata = 0x%02x\r\n", switchdata);

        if (switchdata == PT6312_SW1) { //S1   
          PT6312.cls(); 
          PT6312.writeData(all_str);
        }  

        if (switchdata == PT6312_SW2) { //S2   
          PT6312.cls(); 
          PT6312.writeData(cls_str);
        }  

        if (switchdata == PT6312_SW3) { //S3   
          PT6312.cls(); 
          PT6312.writeData(all_str);
        } 
        
        PT6312.setLED(switchdata); //write LEDs in same pattern
      } //if Switch


      myled = !myled;
      wait(0.3);      
    } //while
}
#endif
