/* mbed PT6311 Test program, for Princeton PT6311 VFD controller
 * Copyright (c) 2016, v01: WH, Initial version, VFDEM2
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "PT6311.h"

// Select one of the testboards for Princeton PT6311 VFD controller

#if (VFDEM2_TEST == 1) 
// VFDEM2 PT6311 Test
#include "mbed.h"
#include "PT6311.h"
#include "Font_16Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 24 bytes (8 grids @ max 20 segments) ... 48 bytes (16 grids @ max 12 segments) 
// DisplayData_t size for VFDEM2 is 36 bytes (12 Grids @ 16 Segments) 
PT6311::DisplayData_t all_str  = {0xFF,0xFF,0x00, 0xFF,0xFF,0x00, 0xFF,0xFF,0x00, 0xFF,0xFF,0x00, \
                                  0xFF,0xFF,0x00, 0xFF,0xFF,0x00, 0xFF,0xFF,0x00, 0xFF,0xFF,0x00, \
                                  0xFF,0xFF,0x00, 0xFF,0xFF,0x00, 0xFF,0xFF,0x00, 0xFF,0xFF,0x00};

PT6311::DisplayData_t cls_str  = {0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00}; 

PT6311::DisplayData_t bye_str  = {0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  LO(C16_E),MD(C16_E),HI(C16_E), LO(C16_Y),MD(C16_Y),HI(C16_Y), LO(C16_B),MD(C16_B),HI(C16_B), 0x00,0x00,0x00};

PT6311::DisplayData_t hello_str = {0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                   0x00,0x00,0x00, 0x00,0x00,0x00, LO(C16_O),MD(C16_O),HI(C16_O), LO(C16_L),MD(C16_L),HI(C16_L), \
                                   LO(C16_L),MD(C16_L),HI(C16_L), LO(C16_E),MD(C16_E),HI(C16_E), LO(C16_H),MD(C16_H),HI(C16_H), 0x00,0x00,0x00};  

PT6311::DisplayData_t mbed_str  = {0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                   0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, LO(C16_D),MD(C16_D),HI(C16_D), \
                                   LO(C16_E),MD(C16_E),HI(C16_E), LO(C16_B),MD(C16_B),HI(C16_B), LO(C16_M),MD(C16_M),HI(C16_M), 0x00,0x00,0x00};  

// KeyData_t size is 3 bytes  
PT6311::KeyData_t keydata; 

// Switchdata is 1 byte  
char switchdata; 

//PT6311_VFDEM2 declaration, Setting 12 Grids @ 16 Segments
PT6311_VFDEM2 VFDEM2(p5,p6,p7, p8);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    VFDEM2.cls(); 
    VFDEM2.writeData(all_str);
    wait(4);
    VFDEM2.setBrightness(PT6311_BRT3);    
    wait(1);
    VFDEM2.setBrightness(PT6311_BRT0);        
    wait(1);
    VFDEM2.setBrightness(PT6311_BRT7);            
    
    while (1) {
     
      // Check and read keydata
      if (VFDEM2.getKeys(&keydata)) {
        pc.printf("Keydata 0..5 = 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3], keydata[4], keydata[5]);

        if (keydata[0] == 0x01) { //K1
          VFDEM2.cls(); 
          VFDEM2.writeData(all_str);
        }  

        if (keydata[0] == 0x02) { //K2   
          VFDEM2.cls(); 

#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          VFDEM2.cls(); 
         
          for (int i=0; i<PT6311_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              VFDEM2.cls(); 

              bits = 0x01 << bit;              
              VFDEM2.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif           
        }  


        if (keydata[0] == 0x04) { //K3   

#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          VFDEM2.cls(); 

          long long int val = 1; 
          for (int i=0; i<VFDEM2_NR_DIGITS; i++) {

            for (long long int cnt=0; cnt<10; cnt++) {
              VFDEM2.locate(0);
              VFDEM2.printf("%010lld", (val * cnt));

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 10;
          }
          pc.printf("Show all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all digits\r\n");
          wait(1);          

          VFDEM2.cls(); 
          VFDEM2.printf("%d", 0);
          cmd = pc.getc(); // wait for key

          VFDEM2.cls();           
          VFDEM2.printf("%3.4f", 12.3456);
          cmd = pc.getc(); // wait for key

          VFDEM2.cls();           
          VFDEM2.printf("%d", 123456);
          cmd = pc.getc(); // wait for key

          VFDEM2.cls(); 
          VFDEM2.printf("%010llx", 0x0123456ABCl);  //Note this value needs 64bits
          cmd = pc.getc(); // wait for key
          
          long long int val = 1; 
          for (int i=0; i<VFDEM2_NR_DIGITS; i++) {

            for (long long int cnt=0; cnt<0x10; cnt++) {
              VFDEM2.locate(0);
              VFDEM2.printf("%010llx", (val * cnt));
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
            val = val * 0x10;
          }
          pc.printf("Show all digits done\r\n");          
#endif                

        }

        if (keydata[0] == 0x08) { //K4   

#if(1)
//test to show all alpha chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          VFDEM2.cls(); 
         
          for (int i=0; i<26; i++) {
            VFDEM2.printf("%c", char(i + 'A'));
//            VFDEM2.printf("%c", char(i + 'a'));
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            

#if(0)
//test to show all chars
          pc.printf("Show all chars\r\n");
          wait(1);          
          VFDEM2.cls(); 

          for (int i=FONT_16S_START; i<FONT_16S_END; i++) {
            VFDEM2.printf("%c", char(i));
//            wait(0.25);
            cmd = pc.getc(); // wait for key            
          }
          pc.printf("Show all chars done\r\n");                    
#endif            

#if(1)
          //wheel
          for(int cnt=0;cnt<10;cnt++) {
            for(int idx=0;idx<8;idx++) {         
              VFDEM2.setUDC(0, WHEEL_ANI[idx]);
              VFDEM2.locate(0);
              VFDEM2.printf("%c%c%c%c%c%c%c%c%c%c",(char)0,(char)0, (char)0,(char)0, (char)0,(char)0, (char)0,(char)0, (char)0,(char)0);
                
              wait(0.1); 
            }  
          }
#endif       
 

#if(1)          
          float delay=0.1;
          // Piechart Icons on
          VFDEM2.setIcon(PT6311_VFDEM2::CIR); wait(delay);

          for(int cnt=0; cnt<10; cnt++) {
            VFDEM2.setIcon(PT6311_VFDEM2::PIE_R);
            VFDEM2.clrIcon(PT6311_VFDEM2::PIE_B); wait(delay);
                        
            VFDEM2.setIcon(PT6311_VFDEM2::PIE_G);
            VFDEM2.clrIcon(PT6311_VFDEM2::PIE_R); wait(delay);
            
            VFDEM2.setIcon(PT6311_VFDEM2::PIE_B);
            VFDEM2.clrIcon(PT6311_VFDEM2::PIE_G); wait(delay);
          }                                                

          VFDEM2.clrIcon(PT6311_VFDEM2::PIE_B); wait(delay);
          
          VFDEM2.clrIcon(PT6311_VFDEM2::CIR); wait(delay);

          wait(delay);
#endif   

          VFDEM2.cls();   
//                       0123456789                         
          VFDEM2.printf("Hello mbed");               
        }
         
        if (keydata[0] == 0x10) { //K5

#if(1)
//test to show all icons
          pc.printf("Show all icons\r\n");
          wait(1);          
          VFDEM2.cls(true); // Also clear all Icons
          wait(1);          
          
          float delay=0.1;
          VFDEM2.setIcon(PT6311_VFDEM2::STP); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::PSE); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::PLY); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::RR); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::LL); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::PCM); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::DTS); wait(delay);          
          VFDEM2.setIcon(PT6311_VFDEM2::MIC); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::DLB); wait(delay);      
          VFDEM2.setIcon(PT6311_VFDEM2::REC); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::PRG); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::RND); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::DP8); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::COL8); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::ANG); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::ZM); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::PBC); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::COL6); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::MP3); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::CDDA); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::SS); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::VCD); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::DVD); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::ARW); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::ONE); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::ALL); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::AA); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::BB); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::TTL); wait(delay);
          VFDEM2.setIcon(PT6311_VFDEM2::CHP); wait(delay);
          wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::STP); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::PSE); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::PLY); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::RR); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::LL); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::PCM); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::DTS); wait(delay);          
          VFDEM2.clrIcon(PT6311_VFDEM2::MIC); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::DLB); wait(delay);      
          VFDEM2.clrIcon(PT6311_VFDEM2::REC); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::PRG); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::RND); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::DP8); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::COL8); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::ANG); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::ZM); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::PBC); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::COL6); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::MP3); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::CDDA); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::SS); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::VCD); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::DVD); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::ARW); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::ONE); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::ALL); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::AA); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::BB); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::TTL); wait(delay);
          VFDEM2.clrIcon(PT6311_VFDEM2::CHP); wait(delay);

          wait(1);          
          VFDEM2.cls(); // clear all, preserve Icons         
          pc.printf("Show all icons done\r\n");                    
#endif           
        }       

        if (keydata[0] == 0x20) { //K6            
          //write LEDs off
          VFDEM2.setLED(0x01);
        }

        if (keydata[0] == 0x40) { //K7  
          //write LEDs on 
          VFDEM2.setLED(0x00);                 
        }
     
      } //if Key


      // Check and read switch data (not supported on VFDEM2)
      switchdata = VFDEM2.getSwitches();
      
      if (switchdata != 0) {
        pc.printf("Switchdata = 0x%02x\r\n", switchdata);

        if (switchdata == PT6311_SW1) { //S1   
          VFDEM2.cls(); 
          VFDEM2.writeData(hello_str);
        }  

        if (switchdata == PT6311_SW2) { //S2   
          VFDEM2.cls(); 
          VFDEM2.writeData(bye_str);
        }  

        if (switchdata == PT6311_SW3) { //S3   
          VFDEM2.cls(); 
          VFDEM2.writeData(mbed_str);
        } 
        
        VFDEM2.setLED(switchdata); //write LEDs in same pattern
      } //if Switch


      myled = !myled;
      wait(0.3);      
    } //while
}
#endif


#if(PT6311_TEST == 1)
// Direct PT6311 Test
#include "mbed.h"
#include "PT6311.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

// DisplayData_t size is 24 bytes (8 digits @ max 20 segments) ... 48 bytes (16 digits @ max 12 segments) 
// DisplayData_t size default is 48 bytes (16 Grids @ 12 Segments) 
PT6311::DisplayData_t all_str  = {0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, \
                                  0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, \
                                  0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, \
                                  0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00, 0xFF,0x0F,0x00};  

PT6311::DisplayData_t cls_str  = {0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, \
                                  0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0x00,0x00};

// KeyData_t size is 6 bytes  
PT6311::KeyData_t keydata; 

// Switchdata is 1 byte  
char switchdata; 

PT6311 PT6311(p5,p6,p7, p8);
//PT6311 PT6311(p5,p6,p7, p8, PT6311::Grid16_Seg12);

char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n"); //    
    
    PT6311.cls(); 
    PT6311.writeData(all_str);
    wait(4);
    PT6311.setBrightness(PT6311_BRT3);    
    wait(1);
    PT6311.setBrightness(PT6311_BRT0);        
    wait(1);
    PT6311.setBrightness(PT6311_BRT7);            
    
    while (1) {
     
      // Check and read keydata
      if (PT6311.getKeys(&keydata)) {
        pc.printf("Keydata 0..5 = 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\r\n", keydata[0], keydata[1], keydata[2], keydata[3], keydata[4], keydata[5]);

        if (keydata[0] == 0x01) { //play   
          PT6311.cls(); 
          PT6311.writeData(all_str);
        }  

        if (keydata[0] == 0x02) { //stop   
          PT6311.cls(); 
          PT6311.writeData(cls_str);
        }  

        if (keydata[0] == 0x04) { //open/close   
          PT6311.cls(); 
          PT6311.writeData(all_str);  

#if(1)
//test to show all segs
          pc.printf("Show all segs\r\n");
          wait(1);          
          PT6311.cls(); 
         
          for (int i=0; i<PT6311_DISPLAY_MEM; i++) {            
            for (int bit=0; bit<8; bit++) {
              PT6311.cls(); 

              bits = 0x01 << bit;              
              PT6311.writeData(i, bits);

              pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("Show all segs done\r\n");                    
#endif 
          
        }       
       
      } //if Key


      // Check and read switch data
      switchdata = PT6311.getSwitches();
      
      if (switchdata != 0) {
        pc.printf("Switchdata = 0x%02x\r\n", switchdata);

        if (switchdata == PT6311_SW1) { //S1   
          PT6311.cls(); 
          PT6311.writeData(all_str);
        }  

        if (switchdata == PT6311_SW2) { //S2   
          PT6311.cls(); 
          PT6311.writeData(cls_str);
        }  

        if (switchdata == PT6311_SW3) { //S3   
          PT6311.cls(); 
          PT6311.writeData(all_str);
        } 
        
        PT6311.setLED(switchdata); //write LEDs in same pattern
      } //if Switch


      myled = !myled;
      wait(0.3);      
    } //while
}
#endif
