/* mbed PT6302 Test program, for Princeton PT6302 VFD controller
 * Note the PT6302 is identical to the OKI ML9208 
 *
 * Copyright (c) 2017, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "PT6302.h"


// Select one of the testboards for Princeton PT6302 VFD controller
#include "PT6302_Config.h"

#if (HANNSTAR_TEST == 1)

// PT6302 Test
#include "mbed.h"
#include "PT6302.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

//PT6302_HANNSTAR PT6302(p5, p7, p8);
PT6302_HANNSTAR PT6302(p11, p13, p14);

void show_menu() {
//    pc.printf("0:   Exit\n\r");
    pc.printf("1:   All\n\r");    
    pc.printf("2:   Show UDC chars\n\r");    
    pc.printf("3:   Show all chars\n\r");
    pc.printf("4:   Show all digits\n\r");    
//    pc.printf("5:   Show all icons\n\r");
    pc.printf("6:   Counter\n\r");
    pc.printf("7:   Floats\n\r");
    pc.printf("8:   Kitt\n\r");
    pc.printf("9:   Cls\n\r");    
    pc.printf("A/B: LED On/Off\n\r");
    pc.printf("C:   Bye\n\r");    
}


int main() {
  pc.printf("Hello World: PT6302 Hannstar test\n\r");

  PT6302.locate(0);    
  PT6302.printf("Hello mbed");    

  PT6302.setBrightness(PT6302_BRT_7);
  wait(1);  
  PT6302.setBrightness(PT6302_BRT_0);
  wait(1);  
  PT6302.setBrightness(PT6302_BRT_DEF);
  wait(1);

    char cmd, cmd2 = '0';
    while (1) {
      
      show_menu();
      cmd2 = pc.getc();

      switch (cmd2) {
        case '1' : {
                      pc.printf("all\r\n");
                      PT6302.cls(); 
                      PT6302.printf("Hello mbed");
                      break;
        }


        case '2' : {
                      pc.printf("UDC\r\n");
                      PT6302.cls();
                     
                      // Store UDC_idx=0, 1 
                      PT6302.setUDC(0, (char *) udc_LAR); // Left Arrow
                      PT6302.setUDC(1, (char *) udc_RAR); // Right Arrow                      

                      // Show UDC_idx=0, 1 
                      PT6302.locate(0);
                      PT6302.putc((char) 0);
                      PT6302.putc((char) 1);                      
                    
                      break;
        }

        case '3' : {
#if(1)
//test to show all chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          PT6302.cls(); 
         
          for (int i=0; i<26; i++) {
            PT6302.printf("%c", char(i + 'A'));
            PT6302.printf("%c", char(i + 'a'));            
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            
          break;          
        }

        case '4': {
#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          PT6302.cls(); 

          for (int i=0; i<PT6302_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              PT6302.locate(i);
              PT6302.printf("%0d", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          PT6302.cls(); 

          PT6302.printf("%010X", 0x0123ABCDEF);
          cmd = pc.getc(); // wait for key
          PT6302.locate(0);          
          PT6302.printf("%016X", 0x0);
                    
          for (int i=0; i<HANNSTAR_NR_DIGITS; i++) {
//          for (int i=0; i<1; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              PT6302.locate(i);
              PT6302.printf("%0X", cnt);
//              pc.printf("%0X", cnt);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif                
          break;          
        }
        
        case '5':  { 
          break;
        }                          

        case '6': {
          pc.printf("Show counter\r\n");          
          PT6302.cls(); // clear all, preserve Icons

#if(1)
          PT6302.locate(0);
          PT6302.printf("Cnt=");
          for (int cnt=0; cnt<=0xFF; cnt++) {
            PT6302.locate(8);
            PT6302.printf("%02X", cnt);           
            wait(0.2);
          }  
#endif
          break;          
        }

        case '7': {
          pc.printf("Show floats\r\n");
          
          PT6302.cls(); // clear all, preserve Icons
          PT6302.printf("%1.7f", -0.1234567);  // test decimal point display
          wait(0.5);
          PT6302.cls(); // clear all, preserve Icons          
          PT6302.printf("%3.6f", 123.456789);  // test decimal point display
          break;          
        }

        case '8': {

#if(1)
//test to show KITT
          pc.printf("Show KITT scanner\r\n");
          
//                          0123456789
const char KITT[][11]  = {{"8         "},
                          {"38        "},
                          {" 38       "},
                          {"  38      "},
                          {"   38     "},
                          {"    38    "},
                          {"     38   "},
                          {"      38  "},
                          {"       38 "},
                          {"        38"},
                          {"         3"},
                          {"          "},
                          {"         8"},
                          {"        8E"},
                          {"       8E "},
                          {"      8E  "},
                          {"     8E   "},
                          {"    8E    "},                                                                              
                          {"   8E     "},
                          {"  8E      "},
                          {" 8E       "},
                          {"8E        "},
                          {"E         "},
                          {"          "}
                        };     
         
          PT6302.cls(); // clear all, preserve Icons
          
          while (!pc.readable()) { // wait for key            
            for (int i=0; i < (sizeof(KITT) / 11) ; i++) {
              PT6302.locate(0);
              PT6302.printf("%s", KITT[i]);
              wait(0.1);
            }
          }
          cmd = pc.getc(); // read key           
          pc.printf("Show KITT done\r\n");
#endif
          break;
        }  


        case '9': {
          PT6302.cls(true); // clear all, including Icons      
          break;
        }  

        case 'A': {
          pc.printf("LED On\r\n");
          PT6302.setPort(0x02);          
          break;
        } 

        case 'B': {
          pc.printf("LED Off\r\n");
          PT6302.setPort(0x00);          
          break;
        } 

        case 'C': {
          PT6302.cls(); // clear all, preserve Icons
          PT6302.printf("Bye");          
       
          break;
        } 

        default : {
          break;
        }         
     
      } //switch cmd

    myled = !myled;
    wait(0.3);
  }
}
#endif


#if (PT6302_TEST == 1)

// PT6302 Bare Metal Test
#include "mbed.h"
#include "PT6302.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

// PT6302 declaration, Default setting 16 Grids @ 35 Segments
PT6302 PT6302(p5, p7, p8); // DI, CLK, CS

int main() {
  pc.printf("Hello World: PT6302 test\n\r");

  PT6302.writeData((char)'H', 9);
  PT6302.writeData((char)'e', 8);
  PT6302.writeData((char)'l', 7);
  PT6302.writeData((char)'l', 6);
  PT6302.writeData((char)'o', 5);

  PT6302.setBlink(true, (PT6302_GR10 | PT6302_GR9 | PT6302_GR8 | PT6302_GR7 | PT6302_GR6) );
                      
  while(1) {
    myled = !myled;
    wait(1);
  }
}
#endif