/* mbed PT6301 Test program, for Princeton PT6301 VFD controller
 *             The controller is used by Futaba 'Chip In Glass' (CIG) VFD tubes. 
 *
 * Copyright (c) 2021, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "PT6301.h"

// Select one of the testboards for Princeton PT6301 VFD controller
#include "PT6301_Config.h"


#if (SMTG7400_TEST == 1)

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

// PT6301_SMTG7400 declaration, Default setting 16 Grids @ 5x7 Segments, with 4 additional Icons and 1 Row
PT6301_SMTG7400 PT6301(p5, p7, p8, p9); // DI, CLK, CS, RST

int main() {
  pc.printf("Hello World: PT6301_SMTG7400 test\n\r");

//  PT6301.printf("Hello World");
  PT6301.printf("Hello World %1.2f", 1.23);  
  PT6301.refresh();

  PT6301.setBrightness(PT6301_BRT_6);
  wait(1);  
  PT6301.setBrightness(PT6301_BRT_DEF);                      
  wait(1);

  PT6301.setIcon(SMTG7400_ICON_OFFLINE);
  PT6301.setIcon(SMTG7400_ICON_WIFI);
  PT6301.setIcon(SMTG7400_ICON_PHONE);
  PT6301.setIcon(SMTG7400_ICON_REC);
  PT6301.refresh();  
  wait(1);
  
  PT6301.cls();
//  PT6301.locate(0, 0);
  PT6301.setUDC(0, (char*) udc_LAR);
  PT6301.setUDC(1, (char*) udc_RAR);  
  PT6301.putc(char(0));
  PT6301.putc(char(1));
  PT6301.refresh();
  wait(1); 
  
  while(1) {
    myled = !myled;
    PT6301.clrIcon(SMTG7400_ICON_OFFLINE);    
    PT6301.refresh();
    wait(1);

    myled = !myled;    
    PT6301.setIcon(SMTG7400_ICON_OFFLINE);    
    PT6301.refresh();
    wait(1);    
  }
}
#endif





#if (SMTC7140_TEST == 1)

// PT6301 Test
#include "mbed.h"
#include "PT6301.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

// PT6301_SMTC7140 declaration, Default setting 12 Grids @ 5x7 Segments, without additional Icons, 2 Rows. Separate Grid13 for Icons
PT6301_SMTC7140 PT6301(p5, p7, p8, p9);

void show_menu() {
//    pc.printf("0:   Exit\n\r");
    pc.printf("1:   All\n\r");    
    pc.printf("2:   Show UDC chars\n\r");    
    pc.printf("3:   Show all chars\n\r");
    pc.printf("4:   Show all digits\n\r");    
    pc.printf("5:   Show all icons\n\r");
    pc.printf("6:   Counter\n\r");
    pc.printf("7:   Floats\n\r");
    pc.printf("8:   Kitt\n\r");
    pc.printf("9:   Cls\n\r");
    pc.printf("A:   Display All Off / Normal\n\r");        
    pc.printf("B:   Display All On / Normal\n\r");
    pc.printf("C:   Bye\n\r");    
}


int main() {
  pc.printf("Hello World: PT6301 SMTC7140 test\n\r");

  PT6301.locate(0, 0);    
  PT6301.printf("Hello mbed");
  PT6301.refresh();      
  wait(1);  
  
  PT6301.setBrightness(PT6301_BRT_7);
  wait(1);  
//  PT6301.setBrightness(PT6301_BRT_0);
//  wait(1);  
  PT6301.setBrightness(PT6301_BRT_DEF);

    char cmd, cmd2 = '0';
    while (1) {
      
      show_menu();
      cmd2 = pc.getc();

      switch (cmd2) {
        case '1' : {
                      pc.printf("all\r\n");
                      PT6301.cls(); 
                      PT6301.printf("Hello mbed");
                      PT6301.refresh();
                      break;
        }


        case '2' : {
                      pc.printf("UDC\r\n");
                      PT6301.cls();
                      PT6301.refresh();                      

                      // Store UDC_idx=0, reserved for Icons on SMTC7140

                      // Store UDC_idx=1, 2 
                      PT6301.setUDC(1, (char *) udc_LAR); // Left Arrow
                      PT6301.setUDC(2, (char *) udc_RAR); // Right Arrow                      
                                            
                      // Show UDC_idx=1, 2 
                      PT6301.locate(0,0);
                      PT6301.putc((char) 1);
                      PT6301.putc((char) 2);                      
                      PT6301.refresh();                    
                      pc.printf("\r\nShow all UDC done\r\n");
                      break;
        }

        case '3' : {
#if(1)
//test to show all chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          PT6301.cls(); 
         
          for (int i=0; i<26; i++) {
            PT6301.printf("%c", char(i + 'A'));
            PT6301.printf("%c", char(i + 'a'));
            PT6301.refresh();                        
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            
          break;          
        }

        case '4': {
#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          PT6301.cls(); 

          for (int i=0; i<SMTC7140_NR_COLS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              PT6301.locate(0, i);
              PT6301.printf("%0d", cnt);
              PT6301.refresh();              

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          PT6301.cls(); 

          PT6301.printf("%010X", 0x0123ABCDEF);
          PT6301.refresh();          
          cmd = pc.getc(); // wait for key
          PT6301.locate(0,0);          
          PT6301.printf("%012X", 0x0);
          PT6301.refresh();          
                    
          for (int i=0; i<SMTC7140_NR_COLS; i++) {
//          for (int i=0; i<1; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              PT6301.locate(0, i);
              PT6301.printf("%0X", cnt);
              PT6301.refresh();              
//              pc.printf("%0X", cnt);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif                
          break;          
        }
        
        case '5':  { 
                      pc.printf("\r\nShow all icon bits\r\n");        
//                      PT6301.cls();
//                      PT6301.refresh();                      
        
                      // Store UDC_idx=0, reserved for Icons on SMTC7140                                         
                      // Show UDC_idx=0 on Position (0, 12), ie Grid13 
#if(0)
                      //Test version to check all bits
                      for (int i=0; i<5; i++) {
                        char bits = 0x40;
            
                        for (int cnt=0; cnt<7; cnt++) {
                          PT6301.setIconGrid13( (i << 8) | bits); // Test
                          pc.printf("Showing icon [%d] => bits 0x%0X\r\n", i, bits);                                              
                          bits = bits >> 1;
                          cmd = pc.getc(); // wait for key
                        }  
                      }
                      pc.printf("\r\nShow all icon bits done\r\n");
#else
                      pc.printf("\r\nShow all icon bits\r\n");
                      cmd = pc.getc(); // wait for key                      
                      PT6301.setIconGrid13(SMTC7140_ICON_DOLBY);
                      cmd = pc.getc(); // wait for key
                      PT6301.setIconGrid13(SMTC7140_ICON_PLUS);
                      cmd = pc.getc(); // wait for key
                      PT6301.setIconGrid13(SMTC7140_ICON_HD);
                      cmd = pc.getc(); // wait for key
                      PT6301.setIconGrid13(SMTC7140_ICON_CLOCK);
                      cmd = pc.getc(); // wait for key
                      PT6301.setIconGrid13(SMTC7140_ICON_REC);
                      cmd = pc.getc(); // wait for key
                      PT6301.setIconGrid13(SMTC7140_ICON_MAIL);
                      cmd = pc.getc(); // wait for key
                      
                      PT6301.clrIconGrid13(SMTC7140_ICON_DOLBY);
                      cmd = pc.getc(); // wait for key
                      PT6301.clrIconGrid13(SMTC7140_ICON_PLUS);
                      cmd = pc.getc(); // wait for key
                      PT6301.clrIconGrid13(SMTC7140_ICON_HD);
                      cmd = pc.getc(); // wait for key
                      PT6301.clrIconGrid13(SMTC7140_ICON_CLOCK);
                      cmd = pc.getc(); // wait for key
                      PT6301.clrIconGrid13(SMTC7140_ICON_REC);
                      cmd = pc.getc(); // wait for key
                      PT6301.clrIconGrid13(SMTC7140_ICON_MAIL);
                      cmd = pc.getc(); // wait for key
                      
                      pc.printf("\r\nShow all icon bits done\r\n");
#endif        
          break;
        }                          

        case '6': {
          pc.printf("Show counter\r\n");          
          PT6301.cls(false); // clear all, preserve Icons

#if(1)
          PT6301.locate(0, 0);
          PT6301.printf("Cnt=");
          for (int cnt=0; cnt<=0xFF; cnt++) {
            PT6301.locate(0, 8);
            PT6301.printf("%02X", cnt);
            PT6301.refresh();                       
            wait(0.2);
          }  
#endif
          break;          
        }

        case '7': {
          pc.printf("Show floats\r\n");
          
          PT6301.cls(false); // clear all, preserve Icons
          PT6301.printf("%1.7f", -0.1234567);  // test decimal point display
          PT6301.refresh();          
          wait(0.5);
          PT6301.cls(false); // clear all, preserve Icons          
          PT6301.printf("%3.6f", 123.456789);  // test decimal point display
          PT6301.refresh();          
          break;          
        }

        case '8': {

#if(1)
//test to show KITT
          pc.printf("Show KITT scanner\r\n");
          
//                          0123456789
const char KITT[][11]  = {{"8         "},
                          {"38        "},
                          {" 38       "},
                          {"  38      "},
                          {"   38     "},
                          {"    38    "},
                          {"     38   "},
                          {"      38  "},
                          {"       38 "},
                          {"        38"},
                          {"         3"},
                          {"          "},
                          {"         8"},
                          {"        8E"},
                          {"       8E "},
                          {"      8E  "},
                          {"     8E   "},
                          {"    8E    "},                                                                              
                          {"   8E     "},
                          {"  8E      "},
                          {" 8E       "},
                          {"8E        "},
                          {"E         "},
                          {"          "}
                        };     
         
          PT6301.cls(false); // clear all, preserve Icons
          
          while (!pc.readable()) { // wait for key            
            for (int i=0; i < (sizeof(KITT) / 11) ; i++) {
              PT6301.locate(0,0);
              PT6301.printf("%s", KITT[i]);
              PT6301.refresh();              
              wait(0.1);
            }
          }
          cmd = pc.getc(); // read key           
          pc.printf("Show KITT done\r\n");
#endif
          break;
        }  

        case '9': {
          PT6301.cls(true); // clear all, including Icons
          PT6301.refresh();
          break;
        }  

        case 'A': {
          pc.printf("Display All Off / Normal\n\r");                    
          PT6301.setDisplay(false);
          wait(1.0);
          PT6301.setDisplay(true);
          wait(1.0);
          break;
        } 

        case 'B': {
          pc.printf("Display All On / Normal\n\r");          
          PT6301.setDisplayTest(true);
          wait(1.0);
          PT6301.setDisplayTest(false);
          wait(1.0);
          break;
        } 

        case 'C': {
          PT6301.cls(false); // clear all, preserve Icons
//          PT6301.printf("Bye");    
//                      "0123456789AB");      
          PT6301.printf("Stack...\r\n");
          PT6301.printf("  ..Overflow");                    
          PT6301.refresh();
          break;
        } 

        default : {
          break;
        }         
     
      } //switch cmd

    myled = !myled;
    wait(0.3);
  }
}
#endif


#if (PT6301_TEST == 1)

// PT6301 Bare Metal Test
#include "mbed.h"
#include "PT6301.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

// PT6301 declaration, Default setting 20 Grids @ 5x7 Segments for 2 rows of characters
PT6301 PT6301(p5, p7, p8, p9); // DI, CLK, CS, RST

int main() {
  pc.printf("Hello World: PT6301 test\n\r");

//  PT6301.writeData((char)'H', 0, 0);
//  PT6301.writeData((char)'e', 0, 1);
//  PT6301.writeData((char)'l', 0, 2);
//  PT6301.writeData((char)'l', 0, 3);
//  PT6301.writeData((char)'o', 0, 4);
  PT6301.printf("Hello World");
  PT6301.refresh();  
                     
  while(1) {
    myled = !myled;
    wait(1);
  }
}
#endif