/* mbed LC75711 Test program, for Sanyo LC75711 VFD controller
 * Copyright (c) 2017, v01: WH, Initial version
 *               2017, v02: WH, Modified setBlink  
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "LC75711.h"

// Select one of the testboards for Sanyo LC75711 VFD controller
#include "LC75711_Config.h"

#if (ASTON_TEST == 1)

// LC75711 Test
#include "mbed.h"
#include "LC75711.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

LC75711_ASTON LC75711(p5, p7, p8);

void show_menu() {
//    pc.printf("0:   Exit\n\r");
    pc.printf("1:   All\n\r");    
    pc.printf("2:   Show UDC chars\n\r");    
    pc.printf("3:   Show all chars\n\r");
    pc.printf("4:   Show all digits\n\r");    
    pc.printf("5:   Show all icons\n\r");
    pc.printf("6:   Counter\n\r");
    pc.printf("7:   Floats\n\r");
    pc.printf("8:   Kitt\n\r");
    pc.printf("9:   Cls\n\r");    
    pc.printf("A/B: Blink On/Off\n\r");
    pc.printf("C:   Bye\n\r");    
}


int main() {
  pc.printf("Hello World: LC75711 test\n\r");

  LC75711.locate(0);    
  LC75711.printf("Hello mbed");    

  LC75711.setBrightness(LC75711_BRT_4);
  wait(1);  
  LC75711.setBrightness(LC75711_BRT_1);
  wait(1);  
  LC75711.setBrightness(LC75711_BRT_4);
  wait(1);

    char cmd, cmd2 = '0';
    while (1) {
      
      show_menu();
      cmd2 = pc.getc();

      switch (cmd2) {
        case '1' : {
                      pc.printf("all\r\n");
                      LC75711.cls(); 
                      LC75711.printf("Hello mbed");                          
                      break;
        }


        case '2' : {
                      pc.printf("UDC\r\n");
                      LC75711.cls();
                     
                      // Note that UDC_idx=0 is reserved for Grid11 to display Icons
                      LC75711.setUDC(1, (char *) udc_checker);
                      LC75711.setUDC(2, (char *) udc_Bat_Hi);
                      LC75711.setUDC(3, (char *) udc_Bat_Ha);
                      LC75711.setUDC(4, (char *) udc_Bat_Lo);
                      LC75711.locate(0);
                      LC75711.putc((char) 1);
                      LC75711.putc((char) 2);
                      LC75711.putc((char) 3);
                      LC75711.putc((char) 4);                                                                  
                     
                      break;
        }

        case '3' : {
#if(1)
//test to show all chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          LC75711.cls(); 
         
          for (int i=0; i<26; i++) {
            LC75711.printf("%c", char(i + 'A'));
//            LC75711.printf("%c", char(i + 'a'));            
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            
          break;          
        }

        case '4': {
#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          LC75711.cls(); 

          for (int i=0; i<LC75711_NR_DIGITS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              LC75711.locate(i);
              LC75711.printf("%0d", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          LC75711.cls(); 

          LC75711.printf("%010X", 0x0123ABCDEF);
          cmd = pc.getc(); // wait for key                                     
          LC75711.printf("%010X", 0x0);
                    
          for (int i=0; i<ASTON_NR_DIGITS; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              LC75711.locate(i);
              LC75711.printf("%0X", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif                
          break;          
        }
        
        case '5':  { 
#if(1)
//test to show all icons
          pc.printf("Show all icons\r\n");
          LC75711.cls(true); // Also clear all Icons
          
#if(0)
          // activate each icon sequentially to find mapping
          char udc[7] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00}; 
          for (int row=0; row<7; row++) {
            for (int bit=0; bit<5; bit++) {
              udc[row] = (1 << bit);  
              LC75711.setUDC(0, (char *) udc);
              pc.printf("Icon row= %d, bit= %d\r\n", row, bit);              
              cmd = pc.getc(); // wait for key                        
            }
            udc[row] = 0x00;  
          }  
#endif

          float delay=0.1;

          // Icons on
          LC75711.setIcon(LC75711_ASTON::R0); wait(delay);
          LC75711.setIcon(LC75711_ASTON::R1); wait(delay);
          LC75711.setIcon(LC75711_ASTON::R2); wait(delay);
          LC75711.setIcon(LC75711_ASTON::R3); wait(delay);
          LC75711.setIcon(LC75711_ASTON::CRD1); wait(delay);
          LC75711.setIcon(LC75711_ASTON::CRD2); wait(delay);
          LC75711.setIcon(LC75711_ASTON::CARD); wait(delay);
          LC75711.setIcon(LC75711_ASTON::KEY); wait(delay);
          LC75711.setIcon(LC75711_ASTON::VDCRP); wait(delay);
          LC75711.setIcon(LC75711_ASTON::D); wait(delay);
          LC75711.setIcon(LC75711_ASTON::D2); wait(delay);
          LC75711.setIcon(LC75711_ASTON::MAC); wait(delay);
          LC75711.setIcon(LC75711_ASTON::R16_9); wait(delay);
          LC75711.setIcon(LC75711_ASTON::DISH); wait(delay);          
          LC75711.setIcon(LC75711_ASTON::DSH1); wait(delay);
          LC75711.setIcon(LC75711_ASTON::DSH2); wait(delay);
          LC75711.setIcon(LC75711_ASTON::TMR); wait(delay);
          LC75711.setIcon(LC75711_ASTON::CBND); wait(delay);
          LC75711.setIcon(LC75711_ASTON::KBND); wait(delay);
          LC75711.setIcon(LC75711_ASTON::AFC); wait(delay);

          wait(delay);
 
          // Icons off
          LC75711.clrIcon(LC75711_ASTON::AFC); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::KBND); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::CBND); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::TMR); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::DSH2); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::DSH1); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::DISH); wait(delay);          
          LC75711.clrIcon(LC75711_ASTON::R16_9); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::MAC); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::D2); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::D); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::VDCRP); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::KEY); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::CRD2); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::CRD1); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::CARD); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::R3); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::R2); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::R1); wait(delay);
          LC75711.clrIcon(LC75711_ASTON::R0); wait(delay);                                        

          pc.printf("Show all icons done\r\n");                    
#endif           
          break;
        }                          

        case '6': {
          pc.printf("Show counter\r\n");          
          LC75711.cls(); // clear all, preserve Icons

#if(1)
          LC75711.locate(0);
          LC75711.printf("Cnt=");
          for (int cnt=0; cnt<=0xFF; cnt++) {
            LC75711.locate(8);
            LC75711.printf("%02X", cnt);           
            wait(0.2);
          }  
#endif
          break;          
        }

        case '7': {
          pc.printf("Show floats\r\n");
          
          LC75711.cls(); // clear all, preserve Icons
          LC75711.printf("%1.7f", -0.1234567);  // test decimal point display
          wait(0.5);
          LC75711.cls(); // clear all, preserve Icons          
          LC75711.printf("%3.6f", 123.456789);  // test decimal point display
          break;          
        }

        case '8': {

#if(1)
//test to show KITT
          pc.printf("Show KITT scanner\r\n");
          
//                          0123456789
const char KITT[][11]  = {{"8         "},
                          {"38        "},
                          {" 38       "},
                          {"  38      "},
                          {"   38     "},
                          {"    38    "},
                          {"     38   "},
                          {"      38  "},
                          {"       38 "},
                          {"        38"},
                          {"         3"},
                          {"          "},
                          {"         8"},
                          {"        8E"},
                          {"       8E "},
                          {"      8E  "},
                          {"     8E   "},
                          {"    8E    "},                                                                              
                          {"   8E     "},
                          {"  8E      "},
                          {" 8E       "},
                          {"8E        "},
                          {"E         "},
                          {"          "}
                        };     
         
          LC75711.cls(); // clear all, preserve Icons
          
          while (!pc.readable()) { // wait for key            
            for (int i=0; i < (sizeof(KITT) / 11) ; i++) {
              LC75711.locate(0);
              LC75711.printf("%s", KITT[i]);
              wait(0.1);
            }
          }
          cmd = pc.getc(); // read key           
          pc.printf("Show KITT done\r\n");
#endif
          break;
        }  


        case '9': {
          LC75711.cls(true); // clear all, including Icons      
          break;
        }  

        case 'A': {
          //Blink some grids
          LC75711.setBlink( (LC75711_GR1 | LC75711_GR2 | LC75711_GR3 | LC75711_GR4) );
          break;
        } 

        case 'B': {
          //Disable Blinking grids          
          LC75711.clrBlink(LC75711_GR3); // Clear GR3 Blink
          wait(2);
          LC75711.clrBlink(); //Clear All
          
          break;
        } 

        case 'C': {
          LC75711.cls(); // clear all, preserve Icons
          LC75711.printf("Bye");          
       
          break;
        } 

        default : {
          break;
        }         
     
      } //switch cmd

    myled = !myled;
    wait(0.3);
  }
}
#endif


#if (LC75711_TEST == 1)

// LC75711 Bare Metal Test
#include "mbed.h"
#include "LC75711.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

// LC75711 declaration, Default setting 16 Grids @ 35 Segments
LC75711 LC75711(p5, p7, p8); // DI, CLK, CS

int main() {
  pc.printf("Hello World: LC75711 test\n\r");

  LC75711.writeData((char)'H', 9);
  LC75711.writeData((char)'e', 8);
  LC75711.writeData((char)'l', 7);
  LC75711.writeData((char)'l', 6);
  LC75711.writeData((char)'o', 5);

  LC75711.setBlink(true, (LC75711_GR10 | LC75711_GR9 | LC75711_GR8 | LC75711_GR7 | LC75711_GR6) );
                      
  while(1) {
    myled = !myled;
    wait(1);
  }
}
#endif