/* mbed HP03SA I2C Pressure and Temperature sensor Test
 *      LM77 Temperature sensor Test
 *
 * Copyright (c) 2015 Wim Huiskamp
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * version 0.1 Initial Release
 */
#define PCF8593_TST            0
#define LM77_TST               1
#define HP03SA_TST             1

#include "mbed.h"

#if (HP03SA_TST == 1)
#include "HP03SA.h"
#endif

#if (LM77_TST == 1)
#include "LM77.h"
#endif
 
//Pin Defines for I2C Bus
#define D_SDA                  p9
#define D_SCL                  p10
//#define D_SDA                  p28
//#define D_SCL                  p27
I2C i2c(D_SDA, D_SCL);

//Pin Defines for XCLR
#define D_XCLR                 p11  

//Host PC Baudrate (Virtual Com Port on USB)
#define D_BAUDRATE            9600
//#define D_BAUDRATE            57600

// mbed Interface Hardware definitions
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut heartbeatLED(LED4);

// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx

#if (HP03SA_TST == 1)
// Generate the 32kHz master clock for HP03SA
PwmOut mclk(p21);

// Instantiate HP03SA
HP03SA hp03sa(&i2c, D_XCLR); // I2C bus, XCLK Pin
#endif

#if (LM77_TST == 1)
// Instantiate LM77
LM77 lm77(&i2c, LM77_SA0); // I2C bus, XCLK Pin
#endif

int main() {
  pc.baud(D_BAUDRATE);
  pc.printf("\r\n\r\n");  
  pc.printf("Hello world\r\n");

#if (PCF8593_TST == 1)
  char buffer[8];
  char status;

  //Init PCF8593 RTC
  buffer[0] = 0x00; //control reg
  buffer[1] = 0x00; //control reg value (32Khz osc)
  status = i2c.write(0xA2, buffer, 2);

  if (status == 0) {
    pc.printf("RTC status = Ok\n\r");
  }
  else {
    pc.printf("RTC status = Not Ok\n\r");      
  }  
#endif

#if (LM77_TST == 1)
  if (lm77.getStatus()) {
    pc.printf("LM77 status = Ok\n\r");   

    pc.printf("Critical Alert temperature from LM77 is %.1f [C]\r\n", lm77.getCritAlertTemp());     
    pc.printf("Low Alert temperature from LM77 is %.1f [C]\r\n", lm77.getLowAlertTemp());     
    pc.printf("High Alert temperature from LM77 is %.1f [C]\r\n", lm77.getHighAlertTemp());             
    pc.printf("Alert Hysteresis from LM77 is %.1f [C]\r\n", lm77.getAlertHyst());  
    wait(1.0);

#if(0)
#define CA          95.0f     
#define LA           8.0f     
#define HA          15.0f     
#define HY           3.0f     
    lm77.setCritAlertTemp(CA);     
    lm77.setLowAlertTemp(LA);         
    lm77.setHighAlertTemp(HA);
    lm77.setAlertHyst(HY);             
    pc.printf("Critical Alert temperature set at %.1f [C]. Read from LM77 is %.1f [°C]\r\n", CA, lm77.getCritAlertTemp());     
    pc.printf("Low Alert temperature set at %.1f [C]. Read from LM77 is %.1f [°C]\r\n", LA, lm77.getLowAlertTemp());     
    pc.printf("High Alert temperature set at %.1f [C]. Read from LM77 is %.1f [°C]\r\n", HA, lm77.getHighAlertTemp());             
    pc.printf("Alert Hysteresis set at %.1f [C]. Read from LM77 is %.1f [°C]\r\n", HY, lm77.getAlertHyst());  
#endif                      
  }
  else {
    pc.printf("LM77 status = not Ok\n\r");            
  } 
#endif

#if (HP03SA_TST == 1)
  //Init MCLK
  mclk.period_us(30);       //32768 KHz
  mclk.pulsewidth_us(15);   //32768 KHz
    
  if (hp03sa.getStatus()) {
    pc.printf("HP03S status = Ok\n\r");    
  }
  else {
    pc.printf("HP03S status = not Ok\n\r");            
  }
  
  // Take reading from sensor before setting calibration value!
  hp03sa.sample();

  // Set QNH pressure. The Altitude reading will be 0 for the set pressure.
//    hp03sa.setPressure(10247);  // MSL pressure at time of testing 1024.7 hPa
//                                // Results in getAltitude() = 6m because it matches local MSL pressure
    
  // Set QNH altitude. The Altitude reading will be the set value at current pressure.
  hp03sa.setAltitude(6);          // About right where I live..
#endif
  
  while(1) {
#if (HP03SA_TST == 1)    
    // Take reading from sensor            
    hp03sa.sample();
    
    // Show Pressure    
    pc.printf("Absolute atmospheric pressure is %.1f [hPa]\r\n", (float) hp03sa.getAbsPressure() / 10.0f);
    pc.printf("Sealevel atmospheric pressure is %.1f [hPa]\r\n", (float) hp03sa.getSeaPressure(6) / 10.0f); // About right where I live..
    
    // Show Temperature
//    pc.printf("Ambient temperature is %.1f [°C]\r\n", (float) hp03sa.getTemperatureInt() / 10.0f);       
    pc.printf("Ambient temperature is %.1f [C]\r\n", hp03sa.getTemperature());       
    pc.printf("Ambient temperature is %.1f [F]\r\n", hp03sa.celsiusToFahrenheit(hp03sa.getTemperature()) );       
        
    // Show Altitude
    pc.printf("Altitude estimated at %d [m]\r\n", hp03sa.getAltitude());       

    // Show Altitude Ft
    pc.printf("Altitude estimated at %d [ft]\r\n", hp03sa.getAltitudeFt());       
#endif

#if (LM77_TST == 1)
    // Show Temperature LM77
//    pc.printf("Ambient temperature from LM77 is %.1f [°C]\r\n", (float) lm77.getTemperatureInt() / 10.0f);       
    pc.printf("Ambient temperature from LM77 is %.1f [C]\r\n", lm77.getTemperature());     
#endif

    wait(1.0);
    myled1 = 1;
    wait(0.2);    
    myled1 = 0;    
  }
}
