/** 
 * @file main.cpp 
 * @brief  mbed Avago/HP HCMS2975 LED matrix display Library test. 
 * @author WH
 * @date   Copyright (c) 2014
 *         v01: WH, Initial release
 *              Info available at http://playground.arduino.cc/Main/LedDisplay and http://www.pjrc.com/teensy/td_libs_LedDisplay.html
*/
#include "mbed.h"
#include "HCMS2975.h"

// mbed Interface Hardware definitions
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut heartbeatLED(LED4);

// Host PC Communication channels
Serial pc(USBTX, USBRX);

// SPI Communication
SPI spi_led(p5, NC, p7); // MOSI, MISO, SCLK

//Display
//HCMS2975 led(&spi_led, p8, p9, NC, HCMS2975::LED8x1); // SPI bus, CS pin, RS pin, RST pin, LEDType = Ok
//HCMS2975 led(&spi_led, p8, p9, NC, HCMS2975::LED16x1); // SPI bus, CS pin, RS pin, RST pin, LEDType = Ok
//HCMS2975 led(&spi_led, p8, p20, NC, HCMS2975::LED8x1); // SPI bus, CS pin, RS pin, RST pin, LEDType = Ok
//HCMS2975 led(&spi_led, p8, p20, NC, HCMS2975::LED8x2); // SPI bus, CS pin, RS pin, RST pin, LEDType = Ok
//HCMS2975 led(&spi_led, p8, p20, NC, HCMS2975::LED16x1); // SPI bus, CS pin, RS pin, RST pin, LEDType = Ok
HCMS2975 led(&spi_led, p8, p20, NC, HCMS2975::LED16x2); // SPI bus, CS pin, RS pin, RST pin, LEDType = Ok

// Variables for Heartbeat and Status monitoring
Ticker heartbeat;
bool heartbeatflag=false;

// Heartbeat monitor
void pulse() {
  heartbeatLED = !heartbeatLED;
}

void heartbeat_start() {
  heartbeat.attach(&pulse, 0.5);
  heartbeatflag = true;
}

void heartbeat_stop() {
  heartbeat.detach();
  heartbeatflag = false;
}

int main() {
  int cnt;
  
  pc.printf("Hello mbed from HCMS2975\n\r");  
    
  heartbeat_start();

  led.locate(0, 0);                               

//led.printf("*=%6d", 123456);
//            12345678 
  led.printf("Hi mbed ");  
  wait(2);

  led.setUDC(0, (char *) udc_0);
  led.setUDC(1, (char *) udc_1);
  led.setUDC(2, (char *) udc_2);
  led.setUDC(3, (char *) udc_3);
  led.setUDC(4, (char *) udc_Bat_Hi);
  led.setUDC(5, (char *) udc_Bat_Ha);
  led.setUDC(6, (char *) udc_Bat_Lo);
//  led.setUDC(7, (char *) udc_smiley);
  led.setUDC(7, (char *) udc_AC);  
  
  led.putc(0);
  led.putc(1);
  led.putc(2);
  led.putc(3);
  led.putc(4);
  led.putc(5);
  led.putc(6);
  led.putc(7);            
  wait(2);

  led.setBrightness(HCMS2975_BRIGHT_3_3);  
 
  cnt=0x20;  
  while(1) {
    wait(0.25);
                        
    led.putc(cnt);
    pc.putc('#');      
    cnt++;
    if (cnt == 0x80) cnt=0x20;
  }
  
}
