/* mbed CU209SCPB Test program for Noritake Itron CU209SCPB VFD module
 *
 * Copyright (c) 2017, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "CU209SCPB.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

CU209SCPB CU209SCPB(p9);
//CU209SCPB CU209SCPB(p13);

void show_menu() {
//    pc.printf("0:   Exit\n\r");
    pc.printf("1:   All\n\r");    
    pc.printf("2:   Show UDC chars\n\r");    
    pc.printf("3:   Show all chars\n\r");
    pc.printf("4:   Show all digits\n\r");    
    pc.printf("6:   Counter\n\r");
    pc.printf("7:   Floats\n\r");
    pc.printf("8:   Kitt\n\r");
    pc.printf("9:   Cls\n\r");
    pc.printf("A/B: Cursor On/Off\n\r");
    pc.printf("C:   Bye\n\r");
}


int main() {
  pc.printf("Hello World: CU209SCPB test\n\r");

  CU209SCPB.locate(0);    
  CU209SCPB.printf("Hello mbed");    

  CU209SCPB.setBrightness(CU209SCPB_BRT_3);
  wait(1);  
  CU209SCPB.setBrightness(CU209SCPB_BRT_0);
  wait(1);  
  CU209SCPB.setBrightness(CU209SCPB_BRT_DEF);
  wait(1);

    char cmd, cmd2 = '0';
    while (1) {
      
      show_menu();
      cmd2 = pc.getc();

      switch (cmd2) {
        case '1' : {
                      pc.printf("all\r\n");
                      CU209SCPB.cls(); 
                      CU209SCPB.printf("Hello mbed");
                      break;
        }


        case '2' : {
                      pc.printf("UDC\r\n");
                      CU209SCPB.cls();
                     
                      // Store UDC_idx=0, 1 
                      CU209SCPB.setUDC(0, (char *) udc_LAR); // Left Arrow
                      CU209SCPB.setUDC(1, (char *) udc_RAR); // Right Arrow                      

                      // Show UDC_idx=0, 1 
                      CU209SCPB.locate(0);
                      CU209SCPB.putc((char) 0);
                      CU209SCPB.putc((char) 1);                      
                    
                      break;
        }

        case '3' : {
#if(1)
//test to show all chars
          pc.printf("Show all alpha chars\r\n");
          wait(1);          
          CU209SCPB.cls(); 
         
          for (int i=0; i<26; i++) {
            CU209SCPB.printf("%c", char(i + 'A'));
            CU209SCPB.printf("%c", char(i + 'a'));            
            wait(0.25);                      
          }
          pc.printf("Show all alpha chars done\r\n");                    
#endif            
          break;          
        }

        case '4': {
#if(0)
//test to show all digits (base is 10)
          pc.printf("Show all digits\r\n");
          wait(1);          
          CU209SCPB.cls(); 

          for (int i=0; i<CU209SCPB_NR_COLS; i++) {

            for (int cnt=0; cnt<10; cnt++) {
              CU209SCPB.locate(i);
              CU209SCPB.printf("%0d", cnt);

//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all digits done\r\n");                    
#endif                

#if(1)
//test to show all digits (base is 0x10)
          pc.printf("Show all hex digits\r\n");
          wait(1);          
          CU209SCPB.cls(); 

          CU209SCPB.printf("%010X", 0x0123ABCDEF);
          cmd = pc.getc(); // wait for key
          CU209SCPB.locate(0);          
          CU209SCPB.printf("%020X", 0x0);
                    
          for (int i=0; i<CU209SCPB_NR_COLS; i++) {
//          for (int i=0; i<1; i++) {

            for (int cnt=0; cnt<0x10; cnt++) {
              CU209SCPB.locate(i);
              CU209SCPB.printf("%0X", cnt);
//              pc.printf("%0X", cnt);              
//              wait(0.5);
              cmd = pc.getc(); // wait for key
            }  
          }
          pc.printf("\r\nShow all hex digits done\r\n");          
#endif                
          break;          
        }
        
        case '5':  { 
          break;
        }                          

        case '6': {
          pc.printf("Show counter\r\n");          
          CU209SCPB.cls(); // clear all, preserve Icons

#if(1)
          CU209SCPB.locate(0);
          CU209SCPB.printf("Cnt=");
          for (int cnt=0; cnt<=0xFF; cnt++) {
            CU209SCPB.locate(8);
            CU209SCPB.printf("%02X", cnt);           
            wait(0.2);
          }  
#endif
          break;          
        }

        case '7': {
          pc.printf("Show floats\r\n");
          
          CU209SCPB.cls(); // clear all, preserve Icons
          CU209SCPB.printf("%1.7f", -0.1234567);  // test decimal point display
          wait(0.5);
          CU209SCPB.cls(); // clear all, preserve Icons          
          CU209SCPB.printf("%3.6f", 123.456789);  // test decimal point display
          break;          
        }

        case '8': {

#if(1)
//test to show KITT
          pc.printf("Show KITT scanner\r\n");
          
//                          0123456789
const char KITT[][11]  = {{"8         "},
                          {"38        "},
                          {" 38       "},
                          {"  38      "},
                          {"   38     "},
                          {"    38    "},
                          {"     38   "},
                          {"      38  "},
                          {"       38 "},
                          {"        38"},
                          {"         3"},
                          {"          "},
                          {"         8"},
                          {"        8E"},
                          {"       8E "},
                          {"      8E  "},
                          {"     8E   "},
                          {"    8E    "},                                                                              
                          {"   8E     "},
                          {"  8E      "},
                          {" 8E       "},
                          {"8E        "},
                          {"E         "},
                          {"          "}
                        };     
         
          CU209SCPB.cls(); // clear all, preserve Icons
          
          while (!pc.readable()) { // wait for key            
            for (int i=0; i < (sizeof(KITT) / 11) ; i++) {
              CU209SCPB.locate(0);
              CU209SCPB.printf("%s", KITT[i]);
              wait(0.1);
            }
          }
          cmd = pc.getc(); // read key           
          pc.printf("Show KITT done\r\n");
#endif
          break;
        }  

        case '9': {
          CU209SCPB.cls(); // clear all
          break;
        }  

        case 'A': {
          pc.printf("Cursor On\r\n");
          CU209SCPB.setCursor(true);          
          break;
        } 

        case 'B': {
          pc.printf("Cursor Off\r\n");
          CU209SCPB.setCursor(false);          
          break;
        } 

        case 'C': {
          CU209SCPB.cls(); // clear all
          CU209SCPB.printf("Bye");          
       
          break;
        } 

        default : {
          break;
        }         
     
      } //switch cmd

    myled = !myled;
    wait(0.3);
  }
}

