/* mbed Example Program
 * Copyright (c) 2006-2014 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#include "TextLCD.h"
 
Serial pc(USBTX, USBRX); // tx, rx

DigitalOut red(LED_RED);        // PC_8
DigitalOut green(LED_GREEN);    // PC_9
DigitalOut blue(LED_BLUE);      // PC_5


I2C i2c_lcd(D14, D15); //SDA, SCL = PA_10, PA_9
char cnt = 0;   

//TextLCD_I2C_N lcd(&i2c_lcd, US2066_SA0, TextLCD::LCD20x4D, NC, TextLCD::US2066_3V3); // I2C bus, slaveaddress, LCDType=LCD20x4D, BL=NC, LCDTCtrl=US2066
TextLCD_I2C_N lcd(&i2c_lcd, US2066_SA0, TextLCD::LCD20x2, NC, TextLCD::US2066_3V3); // I2C bus, slaveaddress, LCDType=LCD20x2, BL=NC, LCDTCtrl=US2066
   
int main() {
  pc.printf("\n\r");  
  pc.printf("Hello World from W7500!\n\r");
  pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);   

//Test to fix the SystemCoreClock
#if(0)
#ifdef SYSCLK_EXTERN_OSC
  pc.printf("SYSCLK_EXTERN_OSC = 1; EXTERN_XTAL = %d\n\r", EXTERN_XTAL);
//  CRG->PLL_IFSR = CRG_PLL_IFSR_OCLK;  
#else  
  pc.printf("SYSCLK_EXTERN_OSC = 0; INTERN_XTAL = %d\n\r", INTERN_XTAL);
//  CRG->PLL_IFSR = CRG_PLL_IFSR_RCLK;  
#endif      
  pc.printf("CRG->PLL_IFSR = 0x%0X\n\r", CRG->PLL_IFSR);
  
  pc.printf("CRG->PLL_FCR = 0x%0X\n\r", CRG->PLL_FCR);  

uint8_t M,N,OD;

  OD = (1 << (CRG->PLL_FCR & 0x01)) * (1 << ((CRG->PLL_FCR & 0x02) >> 1));
   N = (CRG->PLL_FCR >>  8 ) & 0x3F;
   M = (CRG->PLL_FCR >> 16) & 0x3F;
   pc.printf("M = %d; N = %d; OD = %d\n\r", M, N, OD);  
   
  pc.printf("Adapt PLL\n\r");
  wait(1.0);
      
  CRG->PLL_FCR = 0x060100;      
  pc.printf("CRG->PLL_FCR = 0x%0X\n\r", CRG->PLL_FCR);      
  SystemCoreClockUpdate();
  pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);   
#endif

  red = 1;  
  green = 1;  
  blue = 1;      

  if (! i2c_lcd.write(US2066_SA0, &cnt, 1)) {
//  if (! i2c_lcd.write(0x40, &cnt, 1)) {    
    
    pc.printf("Found I2C Slave Device\n\r");
  }    
  else {  
    pc.printf("Ooops, cant find I2C Slave Device\n\r");
  }

  lcd.setOrient(TextLCD::Bottom);
      
  while(1) {
    red = !red;
    wait(0.5);
    
    lcd.printf("Hi mbed! ");    
//    i2c_lcd.write(0x40, &cnt, 1);
//    cnt++;
       
    pc.putc('#'); 
  }
}